<?php
/**
 * Shortcode Map For Blog
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Blog */
/*-----------------------------------------------------------------------------------*/

  $blog_class = 'pofo_blog_'.time() . '-2-' . rand( 0, 100 );   
   
  vc_map( array(
      'name' => esc_html__( 'Blog List', 'pofo-addons'),
      'description' => esc_html__( 'Create a blog list', 'pofo-addons' ),    
      'icon' => 'pofo-shortcode-icon fas fa-list',
      'base' => 'pofo_blog',
      'category' => 'Pofo',
      'params' => array(
        array(
          'type' => 'hidden',
          'heading' => esc_html__( 'Text', 'pofo-addons' ),
          'param_name' => 'pofo_token_class',
          'value' => $blog_class,
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Style', 'pofo-addons'),
          'param_name' => 'pofo_blog_premade_style',
          'value' => array( esc_html__( 'Select Style', 'pofo-addons') => '',
                            esc_html__( 'Full width', 'pofo-addons') => 'blog-full-width',
                            esc_html__( 'Classic', 'pofo-addons') => 'blog-classic',
                            esc_html__( 'List', 'pofo-addons') => 'blog-list',
                            esc_html__( 'Grid', 'pofo-addons') => 'blog-grid',
                            esc_html__( 'Masonry', 'pofo-addons') => 'blog-masonry',
                            esc_html__( 'Simple', 'pofo-addons') => 'blog-simple',
                            esc_html__( 'Clean', 'pofo-addons') => 'blog-clean',
                            esc_html__( 'Image boxes', 'pofo-addons') => 'blog-personal',
                            esc_html__( 'Only text', 'pofo-addons') => 'blog-only-text',
                          ),
        ),
        array(
          'type' => 'pofo_preview_image',
          'heading' => esc_html__( 'Select pre-made style', 'pofo-addons'),
          'param_name' => 'slider_filter_preview_image',
          'admin_label' => true,
          'value' => array( esc_html__( 'Blog type', 'pofo-addons') => '',
                            esc_html__( 'Full width', 'pofo-addons') => 'blog-full-width',
                            esc_html__( 'Classic', 'pofo-addons') => 'blog-classic',
                            esc_html__( 'List', 'pofo-addons') => 'blog-list',
                            esc_html__( 'Grid', 'pofo-addons') => 'blog-grid',
                            esc_html__( 'Masonry', 'pofo-addons') => 'blog-masonry',
                            esc_html__( 'Simple', 'pofo-addons') => 'blog-simple',
                            esc_html__( 'Clean', 'pofo-addons') => 'blog-clean',
                            esc_html__( 'Image boxes', 'pofo-addons') => 'blog-personal',
                            esc_html__( 'Only text', 'pofo-addons') => 'blog-only-text',
                          ),
        ),
        array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'No. of columns', 'pofo-addons'),
        'param_name' => 'pofo_blog_column',
        'value' => array( esc_html__( 'Select column', 'pofo-addons') => '',
                          esc_html__( '2 columns', 'pofo-addons') => '2',
                          esc_html__( '3 columns', 'pofo-addons') => '3',
                          esc_html__( '4 columns', 'pofo-addons') => '4',
                          esc_html__( '5 columns', 'pofo-addons') => '5',
                          esc_html__( '6 columns', 'pofo-addons') => '6',
                        ),
        'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-classic','blog-simple','blog-grid','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'No. of columns', 'pofo-addons'),
        'param_name' => 'pofo_blog_masonry_column',
        'value' => array( esc_html__( 'Select column', 'pofo-addons') => '',
                          esc_html__( '2 columns', 'pofo-addons') => '2',
                          esc_html__( '3 columns', 'pofo-addons') => '3',
                          esc_html__( '4 columns', 'pofo-addons') => '4',
                          esc_html__( '5 columns', 'pofo-addons') => '5',
                        ),
        'std' => '3',
        'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-masonry') ),
        ),
        array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Spacing between columns', 'pofo-addons'),
        'param_name' => 'pofo_blog_type',
        'value' => array( esc_html__( 'Select spacing between columns', 'pofo-addons') => '',
                          esc_html__( 'Gutter large', 'pofo-addons') => 'gutter-large',
                          esc_html__( 'Gutter medium', 'pofo-addons') => 'gutter-medium',
                          esc_html__( 'Gutter small', 'pofo-addons') => 'gutter-small',
                          esc_html__( 'Gutter very small', 'pofo-addons') => 'gutter-very-small',
                        ),
        'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-classic','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type' => 'pofo_multiple_select_option',
          'heading' => esc_html__( 'Categories', 'pofo-addons'),
          'param_name' => 'pofo_categories_list',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Posts order by', 'pofo-addons' ),
            'param_name' => 'pofo_orderby',
            'value' => array(esc_html__( 'Select order by', 'pofo-addons') => '',
                             esc_html__( 'Date', 'pofo-addons' ) => 'date',
                             esc_html__( 'ID', 'pofo-addons' ) => 'ID',
                             esc_html__( 'Author', 'pofo-addons' ) => 'author',
                             esc_html__( 'Title', 'pofo-addons' ) => 'title',
                             esc_html__( 'Modified', 'pofo-addons' ) => 'modified',
                             esc_html__( 'Random', 'pofo-addons' ) => 'rand',
                             esc_html__( 'Comment count', 'pofo-addons' ) => 'comment_count',
                             esc_html__( 'Menu order', 'pofo-addons' ) => 'menu_order',
                            ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Posts sort by', 'pofo-addons' ),
          'param_name' => 'pofo_order',
          'value' => array(esc_html__( 'Select sort by', 'pofo-addons') => '',
                           esc_html__( 'Descending', 'pofo-addons' ) => 'DESC',
                           esc_html__( 'Ascending', 'pofo-addons' ) => 'ASC',
                          ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type' => 'animation_style',
          'heading' => esc_html__( 'Animation', 'pofo-addons' ),
          'param_name' => 'pofo_animation_style',
          'value' => '',
          'settings' => array(
            'type' => array(
              'in',
              'other',
            ),
          ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-list','blog-classic','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'description' => __( 'Select type of animation for element to be animated when it "enters" the browsers viewport (Note: works only in modern browsers).', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Animation delay', 'pofo-addons' ),
          'param_name' => 'pofo_animation_delay',
          'dependency' => array( 'element' => 'pofo_animation_style', 'value_not_equal_to' => array( 'none' ) ),
          'description' => esc_html__( 'Add animation delay in mls', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'No. of posts per page', 'pofo-addons'),
          'param_name' => 'pofo_post_per_page',
          'value'     => '15',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Pagination', 'pofo-addons'),
          'param_name' => 'pofo_show_pagination',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Pagination style', 'pofo-addons'),
          'param_name' => 'pofo_blog_pagination_style',
          'value' => array( esc_html__( 'Select pagination style', 'pofo-addons') => '',
                            esc_html__( 'Number', 'pofo-addons') => 'number-pagination',
                            esc_html__( 'Infinite scroll', 'pofo-addons') => 'infinite-scroll-pagination',
                          ),
          'std' => 'number-pagination',
          'dependency'  => array( 'element' => 'pofo_show_pagination', 'value' => array('1') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post thumbnail', 'pofo-addons'),
          'param_name' => 'pofo_show_post_thumbnail',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-list','blog-classic','blog-simple','blog-grid','blog-masonry','blog-clean','blog-only-text') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post featured image only', 'pofo-addons'),
          'param_name' => 'pofo_show_post_format',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'description' => esc_html__( 'If Off is selected then it will display block as per post format type like audio, video, gallery, etc… otherwise it will show post featured image no matter what is post format type.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_show_post_thumbnail', 'value' => array('1') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Post thumbnail size', 'pofo-addons' ),
          'param_name' => 'pofo_image_srcset',
          'value' => pofo_get_thumbnail_image_sizes(),
          'dependency'  => array( 'element' => 'pofo_show_post_thumbnail', 'value' => array('1') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post title', 'pofo-addons'),
          'param_name' => 'pofo_show_post_title',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-list','blog-classic','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Separator', 'pofo-addons'),
          'param_name' => 'pofo_show_separator',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-only-text') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post author', 'pofo-addons'),
          'param_name' => 'pofo_show_post_author',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post author image', 'pofo-addons'),
          'param_name' => 'pofo_show_post_author_image',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '0',
          'dependency'  => array( 'element' => 'pofo_show_post_author', 'value' => array('1') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post date', 'pofo-addons'),
          'param_name' => 'pofo_show_post_date',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Post date format', 'pofo-addons' ),
          'param_name'  => 'pofo_date_format',
          'description' => wp_kses( 'Date format should be like F j, Y, <a target="_blank" href="https://codex.wordpress.org/Formatting_Date_and_Time">click here</a> to see other date formats.', 'pofo-addons' ),
          'value'       => 'd F Y',
          'dependency'  => array( 'element' => 'pofo_show_post_date', 'value' => array('1') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post excerpt', 'pofo-addons'),
          'param_name' => 'pofo_show_excerpt',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std'         => '1',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Excerpt length', 'pofo-addons' ),
          'param_name'  => 'pofo_excerpt_length',
          'value'     => '15',
          'dependency'  => array( 'element' => 'pofo_show_excerpt', 'value' => array('1') ),
          'description' => esc_html__( 'Words length', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post full content', 'pofo-addons'),
          'param_name' => 'pofo_show_content',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std'         => '1',
          'dependency'  => array( 'element' => 'pofo_show_excerpt', 'value' => array('0') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post categories', 'pofo-addons'),
          'param_name' => 'pofo_show_category',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post likes', 'pofo-addons'),
          'param_name' => 'pofo_show_like',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post comments', 'pofo-addons'),
          'param_name' => 'pofo_show_comment',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Read more button', 'pofo-addons'),
          'param_name' => 'pofo_show_button',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Button text', 'pofo-addons' ),
          'param_name'  => 'pofo_button_text',
          'dependency'  => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Size', 'pofo-addons'),
            'param_name' => 'pofo_button_type',
            'value' => array(esc_html__('Select Button Size', 'pofo-addons') => '',
                      esc_html__('Extra Large', 'pofo-addons') => 'extra-large',
                      esc_html__('Large', 'pofo-addons') => 'large',
                      esc_html__('Medium', 'pofo-addons') => 'medium',
                      esc_html__('Small', 'pofo-addons') => 'small',
                      esc_html__('Very Small', 'pofo-addons') => 'vsmall',
            ),
            'dependency'  => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
            'std' => 'vsmall',
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Box border', 'pofo-addons'),
          'param_name' => 'pofo_box_enable_border',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-only-text') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Hover icon', 'pofo-addons'),
          'param_name' => 'pofo_hide_icon',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-grid') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Zoom effect on hover', 'pofo-addons'),
          'param_name' => 'pofo_zoom_effect',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-classic','blog-personal') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Opacity', 'pofo-addons'),
          'param_name' => 'pofo_blog_opacity',
          'value' => array( esc_html__( 'No Opacity', 'pofo-addons') => '0.0',
                            esc_html__( '0.1', 'pofo-addons') => '0.1',
                            esc_html__( '0.2', 'pofo-addons') => '0.2',
                            esc_html__( '0.3', 'pofo-addons') => '0.3',
                            esc_html__( '0.4', 'pofo-addons') => '0.4',
                            esc_html__( '0.5', 'pofo-addons') => '0.5',
                            esc_html__( '0.6', 'pofo-addons') => '0.6',
                            esc_html__( '0.7', 'pofo-addons') => '0.7',
                            esc_html__( '0.8', 'pofo-addons') => '0.8',
                            esc_html__( '0.9', 'pofo-addons') => '0.9',
                            esc_html__( '1.0', 'pofo-addons') => '1.0',
                          ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
          'std' => '0.5',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-classic','blog-personal') ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Overlay', 'pofo-addons' ),
          'param_name' => 'pofo_overlay_color',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-classic','blog-grid','blog-personal') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Box background color', 'pofo-addons' ),
          'param_name' => 'pofo_box_bg_color',
            'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-grid','blog-masonry','blog-only-text') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Box border color', 'pofo-addons' ),
          'param_name' => 'pofo_width_box_border_color',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Box background hover color', 'pofo-addons' ),
          'param_name' => 'pofo_box_bg_hover_color',
            'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-only-text') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'pofo_box_border_type',
          'heading' => esc_html__( 'Box border type', 'pofo-addons' ),
          'value' => array(esc_html__( 'no border', 'pofo-addons') => '',
                           esc_html__( 'Dotted', 'pofo-addons') => 'dotted',
                           esc_html__( 'Dashed', 'pofo-addons') => 'dashed',
                           esc_html__( 'Solid', 'pofo-addons') => 'solid',
                           esc_html__( 'Double', 'pofo-addons') => 'double',
                          ),
          'dependency'  => array( 'element' => 'pofo_box_enable_border', 'value' => array('1') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Box border thickness', 'pofo-addons' ),
          'param_name' => 'pofo_box_border_size',
          'dependency'  => array( 'element' => 'pofo_box_enable_border', 'value' => array('1') ),
          'description' => esc_html__( 'In pixel like 1px', 'pofo-addons' ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Box border color', 'pofo-addons' ),
          'param_name' => 'pofo_box_border_color',
          'dependency'  => array( 'element' => 'pofo_box_enable_border', 'value' => array('1') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Post meta color', 'pofo-addons' ),
          'param_name' => 'pofo_post_meta_color',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Post meta hover color', 'pofo-addons' ),
          'param_name' => 'pofo_post_meta_hover_color',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Button color', 'pofo-addons' ),
          'param_name' => 'pofo_button_color',
          'dependency' => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Button hover color', 'pofo-addons' ),
          'param_name' => 'pofo_button_hover_color',
          'dependency' => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Button text color', 'pofo-addons' ),
          'param_name' => 'pofo_button_text_color',
          'dependency' => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Button hover text color', 'pofo-addons' ),
          'param_name' => 'pofo_button_hover_text_color',
          'dependency' => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Button border color', 'pofo-addons' ),
          'param_name' => 'pofo_button_border_color',
          'dependency' => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Separator color', 'pofo-addons' ),
          'param_name' => 'pofo_separator_color',
          'dependency' => array( 'element' => 'pofo_show_separator', 'value' => array('1') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Separator hover color', 'pofo-addons' ),
          'param_name' => 'pofo_separator_hover_color',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-only-text') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Separator thickness', 'pofo-addons' ),
          'param_name' => 'pofo_separator_height',
          'dependency' => array( 'element' => 'pofo_show_separator', 'value' => array('1') ),
          'description' => esc_html__( 'In pixel like 1px', 'pofo-addons' ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Post title text case', 'pofo-addons' ),
        'param_name' => 'pofo_blog_post_title_text_transform',
        'value' => array( esc_html__( 'Select Post Meta Text Transform', 'pofo-addons' ) => '',
                          esc_html__( 'Uppercase', 'pofo-addons' ) => 'text-uppercase',
                          esc_html__( 'Lowercase', 'pofo-addons' ) => 'text-lowercase',
                          esc_html__( 'Capitalize', 'pofo-addons' ) => 'text-capitalize',
                          esc_html__( 'None', 'pofo-addons' ) => 'text-none',
                        ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'std' => '',
        'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Post meta text case', 'pofo-addons'),
        'param_name' => 'pofo_blog_post_meta_text_transform',
        'value' => array( esc_html__( 'Select Post Meta Text Transform', 'pofo-addons') => '',
                          esc_html__( 'Uppercase', 'pofo-addons') => 'text-uppercase',
                          esc_html__( 'Lowercase', 'pofo-addons') => 'text-lowercase',
                          esc_html__( 'Capitalize', 'pofo-addons') => 'text-capitalize',
                          esc_html__( 'None', 'pofo-addons' ) => 'text-none',
                        ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'std' => 'text-uppercase',
        'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
        ),
        array(
          'param_name' => 'pofo_custom_title_heading', // all params must have a unique name
          'type' => 'pofo_custom_title', // this param type
          'value' => esc_html__( 'Title Typography', 'pofo-addons' ), // your custom markup
          'dependency' => array( 'element' => 'pofo_show_post_title', 'value' => array('1') ),
          'responsive_settings' => true,
          'hide_show_element' => 'pofo_title_responsive_settings',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Font size', 'pofo-addons' ),
          'param_name' => 'pofo_title_font_size',
          'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_post_title', 'value' => array('1') ),
          'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4 vc_column-with-padding',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Line height', 'pofo-addons' ),
          'param_name' => 'pofo_title_line_height',
          'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_post_title', 'value' => array('1') ),
          'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
          'param_name' => 'pofo_title_letter_spacing',
          'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_post_title', 'value' => array('1') ),
          'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'pofo_title_font_weight',
          'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
          'value' => pofo_font_weight_style(),
          'dependency' => array( 'element' => 'pofo_show_post_title', 'value' => array('1') ),
          'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Font italic', 'pofo-addons'),
          'param_name' => 'pofo_title_italic',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency' => array( 'element' => 'pofo_show_post_title', 'value' => array('1') ),
          'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Font underline', 'pofo-addons'),
          'param_name' => 'pofo_title_underline',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency' => array( 'element' => 'pofo_show_post_title', 'value' => array('1') ),
          'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Color', 'pofo-addons' ),
          'param_name' => 'pofo_title_color',
          'dependency' => array( 'element' => 'pofo_show_post_title', 'value' => array('1') ),
          'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Hover Color', 'pofo-addons' ),
          'param_name' => 'pofo_title_hover_color',
          'dependency' => array( 'element' => 'pofo_show_post_title', 'value' => array('1') ),
          'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
          'param_name' => 'pofo_title_enable_responsive_font',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_post_title', 'value' => array('1') ),
          'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'responsive_font_settings',
          'param_name' => 'pofo_title_responsive_settings',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
          'hide_element_keys' => array( 'text-align', 'font-transform', ),
        ),
        array(
          'param_name' => 'pofo_custom_meta_heading', // all params must have a unique name
          'type' => 'pofo_custom_title', // this param type
          'value' => esc_html__( 'Meta Typography', 'pofo-addons' ), // your custom markup
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'responsive_settings' => true,
          'hide_show_element' => 'pofo_meta_responsive_settings',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Font size', 'pofo-addons' ),
          'param_name' => 'pofo_meta_font_size',
          'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_meta vc_col-sm-4 vc_column-with-padding',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Line height', 'pofo-addons' ),
          'param_name' => 'pofo_meta_line_height',
          'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_meta vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
          'param_name' => 'pofo_meta_letter_spacing',
          'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_meta vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'pofo_meta_font_weight',
          'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
          'value' => pofo_font_weight_style(),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_meta vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Font italic', 'pofo-addons'),
          'param_name' => 'pofo_meta_italic',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_meta vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Font underline', 'pofo-addons'),
          'param_name' => 'pofo_meta_underline',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_meta vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'responsive_font_settings',
          'param_name' => 'pofo_meta_responsive_settings',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
          'hide_element_keys' => array( 'text-align', 'font-transform', ),
        ),
        array(
          'param_name' => 'pofo_custom_content_heading', // all params must have a unique name
          'type' => 'pofo_custom_title', // this param type
          'value' => esc_html__( 'Content Typography', 'pofo-addons' ), // your custom markup
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'responsive_settings' => true,
          'hide_show_element' => 'pofo_content_responsive_settings',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Font size', 'pofo-addons' ),
          'param_name' => 'pofo_content_font_size',
          'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4 vc_column-with-padding',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Line height', 'pofo-addons' ),
          'param_name' => 'pofo_content_line_height',
          'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
          'param_name' => 'pofo_content_letter_spacing',
          'description' => esc_html__( 'In pixel like 1px.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'pofo_content_font_weight',
          'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
          'value' => pofo_font_weight_style(),
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Color', 'pofo-addons' ),
          'param_name' => 'pofo_content_color',
          'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
          'param_name' => 'pofo_content_enable_responsive_font',
          'value' => array(esc_html__( 'NO', 'pofo-addons') => '0',
                           esc_html__( 'YES', 'pofo-addons') => '1'
                          ),
          'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
           'dependency'  => array( 'element' => 'pofo_blog_premade_style', 'value' => array('blog-full-width','blog-classic','blog-list','blog-simple','blog-grid','blog-masonry','blog-clean','blog-personal','blog-only-text') ),
          'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'responsive_font_settings',
          'param_name' => 'pofo_content_responsive_settings',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
          'hide_element_keys' => array( 'text-align', 'font-transform', ),
        ),
        $pofo_vc_extra_id,
        $pofo_vc_extra_class,
      ),
  ) );
