<?php
/**
 * Map For Button
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Button */
/*-----------------------------------------------------------------------------------*/

  vc_map( array(
    'icon' => 'pofo-shortcode-icon fas fa-stop',
    'name' => esc_html__('Button', 'pofo-addons'),
    'description' => esc_html__( 'Add an awesome button', 'pofo-addons' ),
    'base' => 'pofo_button',
    'category' => 'Pofo',
    'content_element' => true,
    'params' => array(
        array(
          'type' => 'dropdown',
          'heading' => esc_html__('Style', 'pofo-addons'),
          'param_name' => 'pofo_button_style',
          'value' => array(esc_html__('Select style', 'pofo-addons') => '',
                    esc_html__('Style 1', 'pofo-addons') => 'style1',
                    esc_html__('Style 2', 'pofo-addons') => 'style2',
                    esc_html__('Style 3', 'pofo-addons') => 'style3',
                    esc_html__('Style 4', 'pofo-addons') => 'style4',
                    esc_html__('Style 5', 'pofo-addons') => 'style5',
                    esc_html__('Style 6', 'pofo-addons') => 'style6',
                    esc_html__('Style 7', 'pofo-addons') => 'style7',
                    esc_html__('Style 8', 'pofo-addons') => 'style8',
                    esc_html__('Style 9', 'pofo-addons') => 'style9',
          ),
        ),  
        array(
            'type' => 'pofo_preview_image',
            'heading' => esc_html__('Select pre-made style', 'pofo-addons'),
            'param_name' => 'pofo_button_preview_image',
            'admin_label' => true,
            'value' => array(esc_html__('Please select style', 'pofo-addons') => '',
                    esc_html__('Style 1', 'pofo-addons') => 'style1',
                    esc_html__('Style 2', 'pofo-addons') => 'style2',
                    esc_html__('Style 3', 'pofo-addons') => 'style3',
                    esc_html__('Style 4', 'pofo-addons') => 'style4',
                    esc_html__('Style 5', 'pofo-addons') => 'style5',
                    esc_html__('Style 6', 'pofo-addons') => 'style6',
                    esc_html__('Style 7', 'pofo-addons') => 'style7',
                    esc_html__('Style 8', 'pofo-addons') => 'style8',
                    esc_html__('Style 9', 'pofo-addons') => 'style9',
            ),
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__('Size', 'pofo-addons'),
            'param_name' => 'pofo_button_type',
            'value' => array(esc_html__('Select Button Size', 'pofo-addons') => '',
                      esc_html__('Extra Large', 'pofo-addons') => 'extra-large',
                      esc_html__('Large', 'pofo-addons') => 'large',
                      esc_html__('Medium', 'pofo-addons') => 'medium',
                      esc_html__('Small', 'pofo-addons') => 'small',
                      esc_html__('Very Small', 'pofo-addons') => 'vsmall',
            ),
            'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'holder' => 'div',
          'class' => '',
          'heading' => esc_html__( 'Icon / Image', 'pofo-addons'),
          'param_name' => 'pofo_enable_icon',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__('Custom icon image', 'pofo-addons'),
          'param_name' => 'custom_icon',
          'value' => array(esc_html__('Off', 'pofo-addons') => '0',
                           esc_html__('On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_enable_icon', 'value' => '1' ),
        ),
        array(
          'type' => 'attach_image',
          'heading' => esc_html__('Custom image', 'pofo-addons'),
          'param_name' => 'custom_icon_image',
          'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
          'description' => esc_html__( 'Recommended size: Extra Large - 60px X 60px, Large - 50px X 50px, Medium - 40px X 40px, Small - 25px X 25px, Extra Small - 18px X 18px', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Maximum width', 'pofo-addons' ),
          'param_name' => 'custom_icon_max_height',
          'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
          'description' => esc_html__( 'In pixel like 40px.', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__('Icon size', 'pofo-addons'),
          'param_name' => 'pofo_icon_type',
          'value' => array(esc_html__('Select Icon Size', 'pofo-addons') => '',
                    esc_html__('Large', 'pofo-addons') => 'icon-large',
                    esc_html__('Medium', 'pofo-addons') => 'icon-medium',
                    esc_html__('Small', 'pofo-addons') => 'icon-small',
                    esc_html__('Very Small', 'pofo-addons') => 'icon-very-small',
          ),
          'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
        ),
        array(
          'type' => 'pofo_icon',
          'heading' => esc_html__('Font icon', 'pofo-addons'),
          'param_name' => 'pofo_button_icon',
          'admin_label' => true,
          'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__('Icon position', 'pofo-addons'),
          'param_name' => 'pofo_icon_position',
          'value' => array(esc_html__('Left', 'pofo-addons') => 'left',
                    esc_html__('Right', 'pofo-addons') => 'right',
          ),
          'std' => 'left',
          'dependency' => array( 'element' => 'custom_icon', 'value' => array( '0', '1' ) ),
        ),
        array(
          'type'        => 'vc_link',
          'heading'     => esc_html__('Button configuration', 'pofo-addons' ),
          'param_name'  => 'pofo_button_text',
          'admin_label' => true,
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__('Button one page navigation', 'pofo-addons'),
          'param_name' => 'pofo_button_one_page',
          'value' => array(esc_html__('Off', 'pofo-addons') => '0',
                           esc_html__('On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
        ),
        array(
          'type' => 'animation_style',
          'heading' => esc_html__( 'CSS animation', 'pofo-addons' ),
          'param_name' => 'pofo_animation_style',
          'value' => '',
          'settings' => array(
            'type' => array(
              'in',
              'other',
            ),
          ),
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'description' => __( 'Select type of animation for element to be animated when it "enters" the browsers viewport (Note: works only in modern browsers).', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Text color', 'pofo-addons' ),
          'param_name' => 'pofo_button_text_color',
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Icon color', 'pofo-addons' ),
          'param_name' => 'pofo_button_icon_color',
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Border color', 'pofo-addons' ),
          'param_name' => 'pofo_button_border_color',
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Hover background color', 'pofo-addons' ),
          'param_name' => 'pofo_button_hover_bg_color',
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Hover text color', 'pofo-addons' ),
          'param_name' => 'pofo_button_hover_text_color',
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Hover icon color', 'pofo-addons' ),
          'param_name' => 'pofo_button_hover_icon_color',
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Hover border color', 'pofo-addons' ),
          'param_name' => 'pofo_button_hover_border_color',
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'desktop_display',
          'heading' => esc_html__( 'Display in desktop', 'pofo-addons' ),
          'value' => array(esc_html__( 'Select display type', 'pofo-addons') => '',
                           esc_html__( 'Block', 'pofo-addons') => 'display-block',
                           esc_html__( 'Inline', 'pofo-addons') => 'display-inline',
                           esc_html__( 'Inline block', 'pofo-addons') => 'display-inline-block',
                           esc_html__( 'Table', 'pofo-addons') => 'display-table',
                           esc_html__( 'None', 'pofo-addons') => 'display-none',
                          ),
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'desktop_mini_display',
          'heading' => esc_html__( 'Display in mini desktop', 'pofo-addons' ),
          'value' => array(esc_html__( 'Select display type', 'pofo-addons') => '',
                           esc_html__( 'Block', 'pofo-addons') => 'md-display-block',
                           esc_html__( 'Inline', 'pofo-addons') => 'md-display-inline',
                           esc_html__( 'Inline block', 'pofo-addons') => 'md-display-inline-block',
                           esc_html__( 'Table', 'pofo-addons') => 'md-display-table',
                           esc_html__( 'None', 'pofo-addons') => 'md-display-none',
                          ),
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'ipad_display',
          'heading' => esc_html__( 'Display in tablet', 'pofo-addons' ),
          'value' => array(esc_html__( 'Select display type', 'pofo-addons') => '',
                           esc_html__( 'Block', 'pofo-addons') => 'sm-display-block',
                           esc_html__( 'Inline', 'pofo-addons') => 'sm-display-inline',
                           esc_html__( 'Inline block', 'pofo-addons') => 'sm-display-inline-block',
                           esc_html__( 'Table', 'pofo-addons') => 'sm-display-table',
                           esc_html__( 'None', 'pofo-addons') => 'sm-display-none',
                          ),
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'mobile_display',
          'heading' => esc_html__( 'Display in mobile', 'pofo-addons' ),
          'value' => array(esc_html__( 'Select display type', 'pofo-addons') => '',
                           esc_html__( 'Block', 'pofo-addons') => 'xs-display-block',
                           esc_html__( 'Inline', 'pofo-addons') => 'xs-display-inline',
                           esc_html__( 'Inline block', 'pofo-addons') => 'xs-display-inline-block',
                           esc_html__( 'Table', 'pofo-addons') => 'xs-display-table',
                           esc_html__( 'None', 'pofo-addons') => 'xs-display-none',
                          ),
          'dependency'  => array( 'element' => 'pofo_button_style', 'value' => array('style1','style2','style3','style4','style5','style6','style7','style8','style9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'css_editor',
          'heading' => esc_html__( 'CSS box', 'pofo-addons' ),
          'param_name' => 'css',
          'group' => esc_html__( 'Design Options', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'pofo_bg_image_type', 
          'heading' => esc_html__( 'Background type', 'pofo-addons' ),
          'value' => array(esc_html__('Select background type', 'pofo-addons') => '',
                           esc_html__('Fix background', 'pofo-addons') => 'fix-background',
                           esc_html__('Cover background', 'pofo-addons') => 'cover-background',
                          ),
          'edit_field_class' => 'vc_col-sm-3 vc_column-with-padding',
          'group' => esc_html__( 'Design Options', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Background position', 'pofo-addons' ),
          'param_name' => 'desktop_bg_image_position',
          'value' => $pofo_desktop_bg_image_position,
          'edit_field_class' => 'vc_col-sm-3',
          'group' => esc_html__( 'Design Options', 'pofo-addons' ),
        ),
        array(
          'param_name' => 'pofo_custom_separator_heading', // all params must have a unique name
          'type' => 'pofo_custom_title', // this param type
          'value' => '', // your custom markup
          'group' => esc_html__( 'Design Options', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'holder' => 'div',
          'class' => '',
          'heading' => esc_html__( 'Enable responsive css box', 'pofo-addons'),
          'param_name' => 'pofo_enable_responsive_css',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'group' => esc_html__( 'Design Options', 'pofo-addons' ),
        ),
        array(
          'type' => 'responsive_css_editor',
          'heading' => esc_html__( 'Responsive css box', 'pofo-addons' ),
          'param_name' => 'responsive_css',
          'height' => 'no',
          'width' => 'no',
          'dependency' => array( 'element' => 'pofo_enable_responsive_css', 'value' => array('1') ),
          'group' => esc_html__( 'Design Options', 'pofo-addons' ),
        ),
        $pofo_vc_extra_id,
        $pofo_vc_extra_class,
    )
  ) );