<?php
/**
 * Shortcode Map For Content Block
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Pofo Content Block  */
/*-----------------------------------------------------------------------------------*/


  vc_map( array(
      'name' => esc_html__( 'Special Content Block', 'pofo-addons' ),
      'base' => 'pofo_content_block',
      'category' => 'Pofo',
      'icon' => 'fas fa-list-alt pofo-shortcode-icon',
      'description' => esc_html__( 'Create a special content block', 'pofo-addons' ),
      'params' => array(
          array(
            'type' => 'dropdown',
            'holder' => 'div',
            'class' => '',
            'heading' => esc_html__('Style', 'pofo-addons'),
            'param_name' => 'pofo_block_premade_style',
            'admin_label' => true,
            'value' => array(esc_html__('Select style', 'pofo-addons') => '',
                             esc_html__('Block style 1', 'pofo-addons') => 'block-1',
                             esc_html__('Block style 2', 'pofo-addons') => 'block-2',
                             esc_html__('Block style 3', 'pofo-addons') => 'block-3',
                             esc_html__('Block style 4', 'pofo-addons') => 'block-4',
                          ),
          ),
          array(
            'type' => 'pofo_preview_image',
            'heading' => esc_html__('Select style for block', 'pofo-addons'),
            'param_name' => 'pofo_block_preview_image',
            'value' => array(esc_html__('Block image', 'pofo-addons') => '',
                             esc_html__('Block style 1', 'pofo-addons') => 'block-1',
                             esc_html__('Block style 2', 'pofo-addons') => 'block-2',
                             esc_html__('Block style 3', 'pofo-addons') => 'block-3',
                             esc_html__('Block style 4', 'pofo-addons') => 'block-4',
                          ),
          ),
          array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Title', 'pofo-addons' ),
            'param_name' => 'pofo_block_title',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
          ),
          array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Subtitle', 'pofo-addons' ),
            'param_name' => 'pofo_block_subtitle',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-3') ),
          ),
          array(
            'type' => 'textarea_html',
            'heading' => esc_html__( 'Content', 'pofo-addons' ),
            'param_name' => 'content',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
          ),
          array(
            'type' => 'pofo_custom_switch_option',
            'holder' => 'div',
            'class' => '',
            'heading' => esc_html__('Separator', 'pofo-addons'),
            'param_name' => 'pofo_show_separator',
            'value' => array(esc_html__('Off', 'pofo-addons') => '0', 
                             esc_html__('On', 'pofo-addons') => '1'
                            ),
            'std' => '1',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
          ),
          array(
            'type'        => 'vc_link',
            'heading'     => esc_html__('Button configuration', 'pofo-addons' ),
            'param_name'  => 'pofo_button_config',
            'admin_label' => true,
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
          ),
          array(
            'type' => 'pofo_custom_switch_option',
            'heading' => esc_html__('Button one page navigation', 'pofo-addons'),
            'param_name' => 'pofo_button_one_page',
            'value' => array(esc_html__('Off', 'pofo-addons') => '0',
                             esc_html__('On', 'pofo-addons') => '1'
                            ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
          ),
          array(
            'type' => 'pofo_custom_switch_option',
            'holder' => 'div',
            'class' => '',
            'heading' => esc_html__('Quote icon', 'pofo-addons'),
            'param_name' => 'pofo_show_quote',
            'value' => array(esc_html__('Off', 'pofo-addons') => '0', 
                             esc_html__('On', 'pofo-addons') => '1'
                            ),
            'std' => '1',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-4') ),
          ),
          array(
            'type' => 'animation_style',
            'heading' => esc_html__( 'CSS animation', 'pofo-addons' ),
            'param_name' => 'initial_loading_animation',
            'value' => '',
            'settings' => array(
              'type' => array(
                'in',
                'other',
              ),
            ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
            'description' => __( 'Select type of animation for element to be animated when it "enters" the browsers viewport (Note: works only in modern browsers).', 'pofo-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Title text case', 'pofo-addons'),
            'param_name' => 'pofo_title_text_transform',
            'value' => array(  esc_html__('Select', 'pofo-addons') => '', 
                               esc_html__('Lowercase', 'pofo-addons') => 'text-lowercase',
                               esc_html__('Uppercase', 'pofo-addons') => 'text-uppercase',
                               esc_html__('Capitalize', 'pofo-addons') => 'text-capitalize',
                               esc_html__( 'None', 'pofo-addons' ) => 'text-none',
                              ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'textfield',
            'heading' => esc_html__('Separator thickness', 'pofo-addons'),
            'param_name' => 'pofo_separator_height',
            'description' => esc_html__( 'In pixel like 2px', 'pofo-addons' ),
            'dependency' => array( 'element' => 'pofo_show_separator', 'value' => array('1') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => esc_html__( 'Separator color', 'pofo-addons' ),
            'param_name' => 'pofo_separator_color',
            'dependency' => array( 'element' => 'pofo_show_separator', 'value' => array('1') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => esc_html__( 'Quote icon color', 'pofo-addons' ),
            'param_name' => 'pofo_quote_color',
            'dependency' => array( 'element' => 'pofo_show_quote', 'value' => array('1') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'content_desktop_width',
            'heading' => esc_html__( 'Content width in desktop', 'pofo-addons' ),
            'value' => $pofo_desktop_width,
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'content_desktop_mini_width',
            'heading' => esc_html__( 'Content width in mini desktop', 'pofo-addons' ),
            'value' => $pofo_desktop_mini_width,
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'content_ipad_width',
            'heading' => esc_html__( 'Content width in tablet', 'pofo-addons' ),
            'value' => $pofo_ipad_width,
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'content_mobile_width',
            'heading' => esc_html__( 'Content width in mobile', 'pofo-addons' ),
            'value' => $pofo_mobile_width,
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => esc_html__( 'Button background color', 'pofo-addons' ),
            'param_name' => 'pofo_button_bg_color',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => esc_html__( 'Button text color', 'pofo-addons' ),
            'param_name' => 'pofo_button_text_color',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => esc_html__( 'Button hover background color', 'pofo-addons' ),
            'param_name' => 'pofo_button_hover_bg_color',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => esc_html__( 'Button hover text color', 'pofo-addons' ),
            'param_name' => 'pofo_button_hover_text_color',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => esc_html__( 'Button border color', 'pofo-addons' ),
            'param_name' => 'pofo_button_border_color',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2') ),
            'group' => esc_html__( 'Style', 'pofo-addons' ),
          ),
          array(
            'param_name' => 'pofo_custom_title_heading', // all params must have a unique name
            'type' => 'pofo_custom_title', // this param type
            'value' => esc_html__( 'Title typography', 'pofo-addons' ), // your custom markup
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
            'responsive_settings' => true,
            'hide_show_element' => 'pofo_title_responsive_settings',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Font size', 'pofo-addons' ),
            'param_name' => 'pofo_title_font_size',
            'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
            'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4 vc_column-with-padding',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Line height', 'pofo-addons' ),
            'param_name' => 'pofo_title_line_height',
            'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
            'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
            'param_name' => 'pofo_title_letter_spacing',
            'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
            'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'pofo_title_font_weight',
            'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
            'value' => pofo_font_weight_style(),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
            'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'pofo_custom_switch_option',
            'heading' => esc_html__( 'Font italic', 'pofo-addons'),
            'param_name' => 'pofo_title_italic',
            'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                             esc_html__( 'On', 'pofo-addons') => '1'
                            ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
            'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'pofo_custom_switch_option',
            'heading' => esc_html__( 'Font underline', 'pofo-addons'),
            'param_name' => 'pofo_title_underline',
            'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                             esc_html__( 'On', 'pofo-addons') => '1'
                            ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
            'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Element tag', 'pofo-addons'),
            'param_name' => 'pofo_title_element_tag',
            'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                             esc_html__( 'h1', 'pofo-addons') => 'h1',
                             esc_html__( 'h2', 'pofo-addons') => 'h2',
                             esc_html__( 'h3', 'pofo-addons') => 'h3',
                             esc_html__( 'h4', 'pofo-addons') => 'h4',
                             esc_html__( 'h5', 'pofo-addons') => 'h5',
                             esc_html__( 'h6', 'pofo-addons') => 'h6',
                            ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
            'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => esc_html__( 'Color', 'pofo-addons' ),
            'param_name' => 'pofo_title_color',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
            'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'pofo_custom_switch_option',
            'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
            'param_name' => 'pofo_title_enable_responsive_font',
            'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                             esc_html__( 'On', 'pofo-addons') => '1'
                            ),
            'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-3','block-4') ),
            'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'responsive_font_settings',
            'param_name' => 'pofo_title_responsive_settings',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
            'hide_element_keys' => array( 'text-align', 'font-transform', ),
          ),
          array(
            'param_name' => 'pofo_custom_subtitle_heading', // all params must have a unique name
            'type' => 'pofo_custom_title', // this param type
            'value' => esc_html__( 'Subtitle Typography', 'pofo-addons' ), // your custom markup
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-3') ),
            'responsive_settings' => true,
            'hide_show_element' => 'pofo_subtitle_responsive_settings',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Font size', 'pofo-addons' ),
            'param_name' => 'pofo_subtitle_font_size',
            'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-3') ),
            'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4 vc_column-with-padding',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Line height', 'pofo-addons' ),
            'param_name' => 'pofo_subtitle_line_height',
            'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-3') ),
            'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
            'param_name' => 'pofo_subtitle_letter_spacing',
            'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-3') ),
            'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'pofo_subtitle_font_weight',
            'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
            'value' => pofo_font_weight_style(),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-3') ),
            'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'pofo_custom_switch_option',
            'heading' => esc_html__( 'Font italic', 'pofo-addons'),
            'param_name' => 'pofo_subtitle_italic',
            'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                             esc_html__( 'On', 'pofo-addons') => '1'
                            ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-3') ),
            'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'pofo_custom_switch_option',
            'heading' => esc_html__( 'Font underline', 'pofo-addons'),
            'param_name' => 'pofo_subtitle_underline',
            'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                             esc_html__( 'On', 'pofo-addons') => '1'
                            ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-3') ),
            'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => esc_html__( 'Color', 'pofo-addons' ),
            'param_name' => 'pofo_subtitle_color',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-3') ),
            'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'pofo_custom_switch_option',
            'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
            'param_name' => 'pofo_subtitle_enable_responsive_font',
            'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                             esc_html__( 'On', 'pofo-addons') => '1'
                            ),
            'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-3') ),
            'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
          ),
          array(
            'type' => 'responsive_font_settings',
            'param_name' => 'pofo_subtitle_responsive_settings',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
            'hide_element_keys' => array( 'text-align', 'font-transform', ),
          ),
          array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'CSS box', 'pofo-addons' ),
            'param_name' => 'css',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-4') ),
            'group' => esc_html__( 'Design Options', 'pofo-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'pofo_bg_image_type', 
            'heading' => esc_html__( 'Background type', 'pofo-addons' ),
            'value' => array(esc_html__('Select background type', 'pofo-addons') => '',
                             esc_html__('Fix background', 'pofo-addons') => 'fix-background',
                             esc_html__('Cover background', 'pofo-addons') => 'cover-background',
                            ),
            'edit_field_class' => 'vc_col-sm-3 vc_column-with-padding',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-4') ),
            'group' => esc_html__( 'Design Options', 'pofo-addons' ),
          ),
          array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Background position', 'pofo-addons' ),
            'param_name' => 'desktop_bg_image_position',
            'value' => $pofo_desktop_bg_image_position,
            'edit_field_class' => 'vc_col-sm-3',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-4') ),
            'group' => esc_html__( 'Design Options', 'pofo-addons' ),
          ),
          array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Width', 'pofo-addons' ),
            'param_name' => 'desktop_width',
            'value' => '',
            'edit_field_class' => 'vc_col-sm-3',
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-4') ),
            'group' => esc_html__( 'Design Options', 'pofo-addons' ),
          ),
          array(
            'param_name' => 'pofo_custom_separator_heading', // all params must have a unique name
            'type' => 'pofo_custom_title', // this param type
            'value' => '', // your custom markup
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-4') ),
            'group' => esc_html__( 'Design Options', 'pofo-addons' ),
          ),
          array(
            'type' => 'pofo_custom_switch_option',
            'holder' => 'div',
            'class' => '',
            'heading' => esc_html__( 'Enable responsive css', 'pofo-addons'),
            'param_name' => 'pofo_enable_responsive_css',
            'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                             esc_html__( 'On', 'pofo-addons') => '1'
                            ),
            'dependency' => array( 'element' => 'pofo_block_premade_style', 'value' => array('block-1','block-2','block-4') ),
            'group' => esc_html__( 'Design Options', 'pofo-addons' ),
          ),
          array(
            'type' => 'responsive_css_editor',
            'heading' => esc_html__( 'Responsive css box', 'pofo-addons' ),
            'param_name' => 'responsive_css',
            'height' => 'no',
            'dependency' => array( 'element' => 'pofo_enable_responsive_css', 'value' => array('1') ),
            'group' => esc_html__( 'Design Options', 'pofo-addons' ),
          ),
          $pofo_vc_extra_id,
          $pofo_vc_extra_class,
        ),
      ) 
    );
