<?php
/**
 * Shortcode Map For Counter 
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Pofo Counter  */
/*-----------------------------------------------------------------------------------*/

  vc_map( 
    array(
    'name' => esc_html__( 'Counter / Skill', 'pofo-addons'),
    'base' => 'pofo_counter_or_skill',
    'category' => 'Pofo',
    'description' => esc_html__( 'Place a counter', 'pofo-addons' ),
    'icon' => 'far fa-clock pofo-shortcode-icon', //URL or CSS class with icon image.
    'params' => array(
      array(
        'type' => 'dropdown',
        'holder' => 'div',
        'class' => '',
        'heading' => esc_html__( 'Style', 'pofo-addons'),
        'param_name' => 'pofo_counter_style',
        'value' => array(esc_html__( 'Select counter or skill', 'pofo-addons') => '',
                         esc_html__( 'Counter style 1', 'pofo-addons') => 'counter-style1',
                         esc_html__( 'Counter style 2', 'pofo-addons') => 'counter-style2',
                         esc_html__( 'Counter style 3', 'pofo-addons') => 'counter-style3',
                         esc_html__( 'Counter style 4', 'pofo-addons') => 'counter-style4',
                         esc_html__( 'Counter style 5', 'pofo-addons') => 'counter-style5',
                         esc_html__( 'Skill style 1', 'pofo-addons')   => 'skill-style1',
                         esc_html__( 'Skill style 2', 'pofo-addons')   => 'skill-style2',
                        ),
      ),
      array(
        'type' => 'pofo_preview_image',
        'heading' => esc_html__( 'Select pre-made style', 'pofo-addons'),
        'param_name' => 'pofo_counter_skill_preview_image',
        'admin_label' => true,
        'value' => array(esc_html__( 'Select counter or skill', 'pofo-addons') => '',
                         esc_html__( 'Counter style 1', 'pofo-addons') => 'counter-style1',
                         esc_html__( 'Counter style 2', 'pofo-addons') => 'counter-style2',
                         esc_html__( 'Counter style 3', 'pofo-addons') => 'counter-style3',
                         esc_html__( 'Counter style 4', 'pofo-addons') => 'counter-style4',
                         esc_html__( 'Counter style 5', 'pofo-addons') => 'counter-style5',
                         esc_html__( 'Skill style 1', 'pofo-addons')   => 'skill-style1',
                         esc_html__( 'Skill style 2', 'pofo-addons')   => 'skill-style2',
                        ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Custom icon image', 'pofo-addons'),
        'param_name' => 'custom_icon',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style4', 'counter-style5') ),
      ),
        array(
          'type' => 'attach_image',
          'heading' => esc_html__( 'Custom image', 'pofo-addons'),
          'param_name' => 'custom_icon_image',
          'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
          'description' => esc_html__( 'Recommended size: Extra Large - 60px X 60px, Large - 50px X 50px, Medium - 40px X 40px, Small - 25px X 25px, Extra Small - 18px X 18px', 'pofo-addons' ),
        ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Maximum width', 'pofo-addons' ),
        'param_name' => 'custom_icon_max_height',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
        'description' => esc_html__( 'In pixel like 40px.', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_icon',
        'heading' => esc_html__( 'Icon', 'pofo-addons'),
        'param_name' => 'counter_icon',
        'admin_label' => true,
        'value' => '',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
      ),
      array(
        'type' => 'textfield',
        'heading' =>esc_html__( 'Counter number', 'pofo-addons'),
        'param_name' => 'counter_number',
        'admin_label' => true,
        'dependency'  => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Number postfix', 'pofo-addons'),
        'param_name' => 'number_postfix',
        'dependency'  => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Title', 'pofo-addons'),
        'param_name' => 'title',
        'admin_label' => true,
        'description' => esc_html__( 'Use || to break the word in new line.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
      ),
      array(
        'type' => 'attach_image',
        'heading' => esc_html__( 'Title Bottom image', 'pofo-addons'),
        'param_name' => 'custom_title_bottom_image',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style5' ) ),
      ),
      array(
        'type' => 'textarea_html',
        'heading' => esc_html__( 'Content', 'pofo-addons'),
        'param_name' => 'content',
        'dependency'  => array( 'element' => 'pofo_counter_style', 'value' => array('skill-style2') ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Use additional font for counter', 'pofo-addons'),
        'param_name' => 'pofo_enable_counter_alternate_font',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Counting duration', 'pofo-addons'),
        'param_name' => 'pofo_counter_animation_duration',
        'admin_label' => true,
        'value' => array(esc_html__( 'Default', 'pofo-addons') => '',
                         esc_html__( '1000ms', 'pofo-addons') => '1000', 
                         esc_html__( '2000ms', 'pofo-addons') => '2000',
                         esc_html__( '3000ms', 'pofo-addons') => '3000',
                         esc_html__( '4000ms', 'pofo-addons') => '4000',
                         esc_html__( '5000ms', 'pofo-addons') => '5000',
                         esc_html__( '6000ms', 'pofo-addons') => '6000',
                         esc_html__( '7000ms', 'pofo-addons') => '7000',
                        ),
        'std' => '2000',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
          
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Link on text', 'pofo-addons'),
        'param_name' => 'pofo_enable_link',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Link target', 'pofo-addons'),
        'param_name' => 'pofo_link_target',
        'value' => array(esc_html__('Self', 'pofo-addons') => '_self', 
                           esc_html__('New tab / window', 'pofo-addons') => '_blank',
                           esc_html__('One page', 'pofo-addons') => 'one_page',
                          ),
        'dependency'  => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' =>esc_html__( 'Add link on', 'pofo-addons'),
        'param_name' => 'pofo_link_on',
        'admin_label' => true,
        'value' => array( esc_html__( 'Select','pofo-addons') => '',
                          esc_html__( 'Icon','pofo-addons') => 'icon',
                          esc_html__( 'Counter','pofo-addons') => 'counter',
                          esc_html__( 'Title','pofo-addons') => 'title',
                          esc_html__( 'All','pofo-addons') => 'all',
                        ),
        'dependency'  => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
      ),
      array(
        'type' => 'textfield',
        'heading' =>esc_html__( 'Link / URL', 'pofo-addons'),
        'param_name' => 'pofo_link_url',
        'admin_label' => true,
        'dependency'  => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
        'description' => esc_html__( 'Enter full URL with http, like http://www.example.com', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Link hover color', 'pofo-addons' ),
        'param_name' => 'pofo_link_hover_color',
        'dependency'  => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Border', 'pofo-addons'),
        'param_name' => 'pofo_enable_border',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1') ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Separator', 'pofo-addons'),
        'param_name' => 'pofo_enable_separator',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency'  => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style2', 'counter-style3'))
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Box shadow', 'pofo-addons'),
        'param_name' => 'pofo_enable_box_shadow',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('skill-style1') ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Plus Icon', 'pofo-addons'),
        'param_name' => 'pofo_enable_plus_icon',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency'  => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style4'))
      ),
      array(
        'type' => 'animation_style',
        'heading' => esc_html__( 'CSS animation', 'pofo-addons' ),
        'param_name' => 'initial_loading_animation',
        'value' => '',
        'settings' => array(
          'type' => array(
            'in',
            'other',
          ),
        ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'description' => __( 'Select type of animation for element to be animated when it "enters" the browsers viewport (Note: works only in modern browsers).', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Icon size', 'pofo-addons'),
        'param_name' => 'pofo_counter_icon_size',
        'admin_label' => true,
        'value' => array( esc_html__( 'Default','pofo-addons') => '',
                          esc_html__( 'Extra large','pofo-addons') => 'icon-extra-large', 
                          esc_html__( 'Large','pofo-addons') => 'icon-large',
                          esc_html__( 'Extra medium','pofo-addons') => 'icon-extra-medium',
                          esc_html__( 'Medium','pofo-addons') => 'icon-medium',
                          esc_html__( 'Small','pofo-addons') => 'icon-small',
                          esc_html__( 'Extra small','pofo-addons') => 'icon-extra-small',
                        ),
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Icon color', 'pofo-addons' ),
        'param_name' => 'pofo_icon_color',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Plus icon color', 'pofo-addons' ),
        'param_name' => 'pofo_plus_icon_color',
        'dependency' => array( 'element' => 'pofo_enable_plus_icon', 'value' => '1' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_border_type',
        'heading' => esc_html__( 'Border type', 'pofo-addons' ),
        'value' => array(esc_html__( 'no border', 'pofo-addons') => '',
                         esc_html__( 'Dotted', 'pofo-addons') => 'dotted',
                         esc_html__( 'Dashed', 'pofo-addons') => 'dashed',
                         esc_html__( 'Solid', 'pofo-addons') => 'solid',
                         esc_html__( 'Double', 'pofo-addons') => 'double',
                        ),
        'std' => 'solid',
        'dependency' => array( 'element' => 'pofo_enable_border', 'value' => array('1') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Border thickness', 'pofo-addons' ),
        'param_name' => 'pofo_border_size',
        'dependency' => array( 'element' => 'pofo_enable_border', 'value' => array('1') ),
        'description' => esc_html__( 'In pixel like 2px.', 'pofo-addons' ),
        'value' => '1px',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Border color', 'pofo-addons' ),
        'param_name' => 'pofo_border_color',
        'dependency' => array( 'element' => 'pofo_enable_border', 'value' => array('1') ),
        'value' => '#ededed',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Box background color', 'pofo-addons' ),
        'param_name' => 'pofo_box_background_color',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'skill-style1') ),
        'value' => '',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'class' => '',
        'heading' => esc_html__( 'Box hover border thickness', 'pofo-addons' ),
        'param_name' => 'pofo_box_hover_border_size',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1') ),
        'description' => esc_html__( 'In pixel like 2px.', 'pofo-addons' ),
        'value' => '',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Box hover border color', 'pofo-addons' ),
        'param_name' => 'pofo_box_hover_border_color',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1') ),
        'value' => '',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Separator thickness', 'pofo-addons' ),
        'param_name' => 'pofo_separator_height',
        'dependency' => array( 'element' => 'pofo_enable_separator', 'value' => array('1') ),
        'description' => esc_html__( 'In pixel like 2px.', 'pofo-addons' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Separator width', 'pofo-addons' ),
        'param_name' => 'pofo_separator_width',
        'dependency' => array( 'element' => 'pofo_enable_separator', 'value' => array('1') ),
        'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Separator color', 'pofo-addons' ),
        'param_name' => 'pofo_separator_color',
        'dependency' => array( 'element' => 'pofo_enable_separator', 'value' => array('1') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Chart size', 'pofo-addons' ),
        'param_name' => 'pofo_chart_size',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('skill-style1') ),
        'description' => esc_html__( 'In number like 150.', 'pofo-addons' ),
        'std' => '',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Track thickness', 'pofo-addons' ),
        'param_name' => 'pofo_track_width',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('skill-style1', 'skill-style2') ),
        'description' => esc_html__( 'In number like 2.', 'pofo-addons' ),
        'std' => '2',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Track color', 'pofo-addons' ),
        'param_name' => 'pofo_track_color',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('skill-style1', 'skill-style2') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Border radius', 'pofo-addons' ),
        'param_name' => 'pofo_border_radius',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('skill-style1') ),
        'description' => esc_html__( 'In pixel like 2px.', 'pofo-addons' ),
        'value' => '5px',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Progress bar color', 'pofo-addons' ),
        'param_name' => 'pofo_progress_bar_color',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('skill-style1', 'skill-style2') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Counter background color', 'pofo-addons' ),
        'param_name' => 'pofo_counter_background_color',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('skill-style2') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'param_name' => 'pofo_custom_counter_heading', // all params must have a unique name
        'type' => 'pofo_custom_title', // this param type
        'value' => esc_html__( 'Counter Typography', 'pofo-addons' ), // your custom markup
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'responsive_settings' => true,
        'hide_show_element' => 'pofo_counter_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Font size', 'pofo-addons' ),
        'param_name' => 'pofo_counter_font_size',
        'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_counter vc_col-sm-4 vc_column-with-padding',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Line height', 'pofo-addons' ),
        'param_name' => 'pofo_counter_line_height',
        'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_counter vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
        'param_name' => 'pofo_counter_letter_spacing',
        'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_counter vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_counter_font_weight',
        'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
        'value' => pofo_font_weight_style(),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_counter vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font italic', 'pofo-addons'),
        'param_name' => 'pofo_counter_italic',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_counter vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font underline', 'pofo-addons'),
        'param_name' => 'pofo_counter_underline',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_counter vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Element tag', 'pofo-addons'),
        'param_name' => 'pofo_counter_element_tag',
        'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                         esc_html__( 'h1', 'pofo-addons') => 'h1',
                         esc_html__( 'h2', 'pofo-addons') => 'h2',
                         esc_html__( 'h3', 'pofo-addons') => 'h3',
                         esc_html__( 'h4', 'pofo-addons') => 'h4',
                         esc_html__( 'h5', 'pofo-addons') => 'h5',
                         esc_html__( 'h6', 'pofo-addons') => 'h6',
                        ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_counter vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Color', 'pofo-addons' ),
        'param_name' => 'pofo_counter_color',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_counter vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
        'param_name' => 'pofo_counter_enable_responsive_font',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_counter vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'responsive_font_settings',
        'param_name' => 'pofo_counter_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
        'hide_element_keys' => array( 'text-align', 'font-transform', ),
      ),
      array(
        'param_name' => 'pofo_custom_title_heading', // all params must have a unique name
        'type' => 'pofo_custom_title', // this param type
        'value' => esc_html__( 'Title Typography', 'pofo-addons' ), // your custom markup
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
        'responsive_settings' => true,
        'hide_show_element' => 'pofo_title_responsive_settings',
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Font size', 'pofo-addons' ),
        'param_name' => 'pofo_title_font_size',
        'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4 vc_column-with-padding',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Line height', 'pofo-addons' ),
        'param_name' => 'pofo_title_line_height',
        'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
        'param_name' => 'pofo_title_letter_spacing',
        'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_title_font_weight',
        'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
        'value' => pofo_font_weight_style(),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font italic', 'pofo-addons'),
        'param_name' => 'pofo_title_italic',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font underline', 'pofo-addons'),
        'param_name' => 'pofo_title_underline',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Element tag', 'pofo-addons'),
        'param_name' => 'pofo_title_element_tag',
        'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                         esc_html__( 'h1', 'pofo-addons') => 'h1',
                         esc_html__( 'h2', 'pofo-addons') => 'h2',
                         esc_html__( 'h3', 'pofo-addons') => 'h3',
                         esc_html__( 'h4', 'pofo-addons') => 'h4',
                         esc_html__( 'h5', 'pofo-addons') => 'h5',
                         esc_html__( 'h6', 'pofo-addons') => 'h6',
                        ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Color', 'pofo-addons' ),
        'param_name' => 'pofo_title_color',
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
        'param_name' => 'pofo_title_enable_responsive_font',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_counter_style', 'value' => array('counter-style1', 'counter-style2', 'counter-style3', 'counter-style4', 'counter-style5', 'skill-style1', 'skill-style2') ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'responsive_font_settings',
        'param_name' => 'pofo_title_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
        'hide_element_keys' => array( 'text-align', 'font-transform', ),
      ),
      $pofo_vc_extra_id,
      $pofo_vc_extra_class,
      ),
    ) 
  );
