<?php
/**
 * Shortcode Map For Feature Box
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Feature Box */
/*-----------------------------------------------------------------------------------*/

  vc_map( array(
    'name' => esc_html__( 'Features Box', 'pofo-addons'),
    'description' => esc_html__( 'Place a features box', 'pofo-addons'),
    'icon' => 'fas fa-building pofo-shortcode-icon',
    'base' => 'pofo_feature_box',
    'category' => 'Pofo',
    'params' => array(
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Style', 'pofo-addons'),
        'param_name' => 'pofo_feature_type',
        'value' => array(esc_html__( 'Select style', 'pofo-addons') => '',
                         esc_html__( 'Contact info', 'pofo-addons')  => 'featurebox21',
                         esc_html__( 'Custom icon with text 1', 'pofo-addons')  => 'featurebox22',
                         esc_html__( 'Custom icon with text 2', 'pofo-addons')  => 'featurebox23',
                         esc_html__( 'Fancy text box style 1', 'pofo-addons')  => 'featurebox1',
                         esc_html__( 'Fancy text box style 2', 'pofo-addons')  => 'featurebox14',
                         esc_html__( 'Fancy text box style 3', 'pofo-addons')  => 'featurebox3',
                         esc_html__( 'Fancy text box style 4', 'pofo-addons')  => 'featurebox33',
                         esc_html__( 'Fancy text box style 5', 'pofo-addons')  => 'featurebox30',
                         esc_html__( 'Fancy text box style 6', 'pofo-addons')  => 'featurebox9',
                         esc_html__( 'Fancy text box style 7', 'pofo-addons')  => 'featurebox25',
                         esc_html__( 'Fancy text box style 8', 'pofo-addons')  => 'featurebox13',
                         esc_html__( 'Fancy text box style 9', 'pofo-addons')  => 'featurebox38',
                         esc_html__( 'Fancy text box style 10', 'pofo-addons')  => 'featurebox41',
                         esc_html__( 'Feature box style 1', 'pofo-addons')  => 'featurebox19',
                         esc_html__( 'Feature box style 2', 'pofo-addons')  => 'featurebox24',
                         esc_html__( 'Feature box style 3', 'pofo-addons')  => 'featurebox31',
                         esc_html__( 'Feature box style 4', 'pofo-addons')  => 'featurebox32',
                         esc_html__( 'Feature box style 5', 'pofo-addons')  => 'featurebox37',
                         esc_html__( 'Icon with text style 1', 'pofo-addons')  => 'featurebox5',
                         esc_html__( 'Icon with text style 2', 'pofo-addons')  => 'featurebox6',
                         esc_html__( 'Icon with text style 3', 'pofo-addons')  => 'featurebox8',
                         esc_html__( 'Icon with text style 4', 'pofo-addons')  => 'featurebox28',
                         esc_html__( 'Icon with text style 5', 'pofo-addons')  => 'featurebox29',
                         esc_html__( 'Icon with text style 6', 'pofo-addons')  => 'featurebox2',
                         esc_html__( 'Icon with text style 7', 'pofo-addons')  => 'featurebox39',
                         esc_html__( 'Icon with text style 8', 'pofo-addons')  => 'featurebox40',
                         esc_html__( 'Info banner style 1', 'pofo-addons')  => 'featurebox34',
                         esc_html__( 'Info banner style 2', 'pofo-addons')  => 'featurebox20',
                         esc_html__( 'Interactive banner style 1', 'pofo-addons')  => 'featurebox15',
                         esc_html__( 'Interactive banner style 2', 'pofo-addons')  => 'featurebox4',
                         esc_html__( 'Interactive banner style 3', 'pofo-addons')  => 'featurebox16',
                         esc_html__( 'Interactive banner style 4', 'pofo-addons')  => 'featurebox17',
                         esc_html__( 'Interactive banner style 5', 'pofo-addons')  => 'featurebox18',
                         esc_html__( 'Process step style 1', 'pofo-addons')  => 'featurebox11',
                         esc_html__( 'Process step style 2', 'pofo-addons')  => 'featurebox10',
                         esc_html__( 'Rotate box style 1', 'pofo-addons')  => 'featurebox26',
                         esc_html__( 'Rotate box style 2', 'pofo-addons')  => 'featurebox12',
                         esc_html__( 'Rotate box style 3', 'pofo-addons')  => 'featurebox35',
                         esc_html__( 'Text box style 1', 'pofo-addons')  => 'featurebox7',
                         esc_html__( 'Text box style 2', 'pofo-addons')  => 'featurebox27',
                         esc_html__( 'Text box style 3', 'pofo-addons')  => 'featurebox36',
                        ),
      ),
      array(
        'type' => 'pofo_preview_image',
        'heading' => esc_html__( 'Select pre-made style for Feature', 'pofo-addons'),
        'param_name' => 'feature_box_preview_image',
        'admin_label' => true,
        'value' => array(esc_html__( 'Select style', 'pofo-addons') => '',
                         esc_html__( 'Contact info', 'pofo-addons')  => 'featurebox21',
                         esc_html__( 'Custom icon with text 1', 'pofo-addons')  => 'featurebox22',
                         esc_html__( 'Custom icon with text 2', 'pofo-addons')  => 'featurebox23',
                         esc_html__( 'Fancy text box style 1', 'pofo-addons')  => 'featurebox1',
                         esc_html__( 'Fancy text box style 2', 'pofo-addons')  => 'featurebox14',
                         esc_html__( 'Fancy text box style 3', 'pofo-addons')  => 'featurebox3',
                         esc_html__( 'Fancy text box style 4', 'pofo-addons')  => 'featurebox33',
                         esc_html__( 'Fancy text box style 5', 'pofo-addons')  => 'featurebox30',
                         esc_html__( 'Fancy text box style 6', 'pofo-addons')  => 'featurebox9',
                         esc_html__( 'Fancy text box style 7', 'pofo-addons')  => 'featurebox25',
                         esc_html__( 'Fancy text box style 8', 'pofo-addons')  => 'featurebox13',
                         esc_html__( 'Fancy text box style 9', 'pofo-addons')  => 'featurebox38',
                         esc_html__( 'Fancy text box style 10', 'pofo-addons') => 'featurebox41',
                         esc_html__( 'Feature box style 1', 'pofo-addons')  => 'featurebox19',
                         esc_html__( 'Feature box style 2', 'pofo-addons')  => 'featurebox24',
                         esc_html__( 'Feature box style 3', 'pofo-addons')  => 'featurebox31',
                         esc_html__( 'Feature box style 4', 'pofo-addons')  => 'featurebox32',
                         esc_html__( 'Feature box style 5', 'pofo-addons')  => 'featurebox37',
                         esc_html__( 'Icon with text style 1', 'pofo-addons')  => 'featurebox5',
                         esc_html__( 'Icon with text style 2', 'pofo-addons')  => 'featurebox6',
                         esc_html__( 'Icon with text style 3', 'pofo-addons')  => 'featurebox8',
                         esc_html__( 'Icon with text style 4', 'pofo-addons')  => 'featurebox28',
                         esc_html__( 'Icon with text style 5', 'pofo-addons')  => 'featurebox29',
                         esc_html__( 'Icon with text style 6', 'pofo-addons')  => 'featurebox2',
                         esc_html__( 'Icon with text style 7', 'pofo-addons')  => 'featurebox39',
                         esc_html__( 'Icon with text style 8', 'pofo-addons')  => 'featurebox40',
                         esc_html__( 'Info banner style 1', 'pofo-addons')  => 'featurebox34',
                         esc_html__( 'Info banner style 2', 'pofo-addons')  => 'featurebox20',
                         esc_html__( 'Interactive banner style 1', 'pofo-addons')  => 'featurebox15',
                         esc_html__( 'Interactive banner style 2', 'pofo-addons')  => 'featurebox4',
                         esc_html__( 'Interactive banner style 3', 'pofo-addons')  => 'featurebox16',
                         esc_html__( 'Interactive banner style 4', 'pofo-addons')  => 'featurebox17',
                         esc_html__( 'Interactive banner style 5', 'pofo-addons')  => 'featurebox18',
                         esc_html__( 'Process step style 1', 'pofo-addons')  => 'featurebox11',
                         esc_html__( 'Process step style 2', 'pofo-addons')  => 'featurebox10',
                         esc_html__( 'Rotate box style 1', 'pofo-addons')  => 'featurebox26',
                         esc_html__( 'Rotate box style 2', 'pofo-addons')  => 'featurebox12',
                         esc_html__( 'Rotate box style 3', 'pofo-addons')  => 'featurebox35',
                         esc_html__( 'Text box style 1', 'pofo-addons')  => 'featurebox7',
                         esc_html__( 'Text box style 2', 'pofo-addons')  => 'featurebox27',
                         esc_html__( 'Text box style 3', 'pofo-addons')  => 'featurebox36',
                        ),
      ),
      array(
        'type' => 'attach_image',
        'heading' => esc_html__( 'Image', 'pofo-addons'),
        'param_name' => 'pofo_image',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox20', 'featurebox26', 'featurebox32', 'featurebox34', 'featurebox35', 'featurebox37')),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Image thumbnail size', 'pofo-addons' ),
        'param_name' => 'pofo_image_srcset',
        'value' => pofo_get_thumbnail_image_sizes(),
        'std' => 'full',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox20', 'featurebox26', 'featurebox32', 'featurebox34', 'featurebox35', 'featurebox37')),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Image position', 'pofo-addons' ),
        'param_name' => 'pofo_image_position',
        'value' => array(esc_html__( 'Top', 'pofo-addons') => 'top', 
                         esc_html__( 'Bottom', 'pofo-addons') => 'bottom'
                        ),
        'std' => 'top',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox20')),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Custom icon image', 'pofo-addons'),
        'param_name' => 'custom_icon',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox2', 'featurebox3', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox37', 'featurebox39', 'featurebox40')),
      ),
      array(
        'type' => 'attach_image',
        'heading' => esc_html__( 'Custom image', 'pofo-addons'),
        'param_name' => 'custom_icon_image',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
        'description' => esc_html__( 'Recommended size: Extra Large - 60px X 60px, Large - 50px X 50px, Extra Medium - 40px X 40px, Medium - 35px X 35px, Small - 24px X 24px, Extra Small - 16px X 16px', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Maximum width', 'pofo-addons' ),
        'param_name' => 'custom_icon_max_height',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
        'description' => esc_html__( 'In pixel like 40px.', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_icon',
        'heading' => esc_html__( 'Font icon', 'pofo-addons'),
        'param_name' => 'pofo_icon_list',
        'admin_label' => true,
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Icon background', 'pofo-addons'),
        'param_name' => 'pofo_enable_icon_bg',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox8', 'featurebox11', 'featurebox12', 'featurebox21', 'featurebox23')),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Number text', 'pofo-addons' ),
        'param_name' => 'pofo_number_text',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox10', 'featurebox14', 'featurebox25', 'featurebox30', 'featurebox31', 'featurebox33','featurebox36', 'featurebox38','featurebox41')),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Title', 'pofo-addons' ),
        'param_name' => 'pofo_feature_title',
        'description' => esc_html__( 'Use || to break the word in new line.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Subtitle', 'pofo-addons' ),
        'param_name' => 'pofo_feature_subtitle',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox12', 'featurebox14', 'featurebox23', 'featurebox24', 'featurebox26', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox18')),
      ),
      array(
        'type' => 'textarea_html',
        'heading' => esc_html__( 'Content', 'pofo-addons'),
        'param_name' => 'content',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox37', 'featurebox38', 'featurebox40','featurebox41')),
      ),
      array(
        'type'        => 'vc_link',
        'heading'     => esc_html__( 'Button configuration', 'pofo-addons' ),
        'param_name'  => 'pofo_button_config',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox21', 'featurebox34', 'featurebox35','featurebox41') ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__('Button one page navigation', 'pofo-addons'),
        'param_name' => 'pofo_button_one_page',
        'value' => array(esc_html__('Off', 'pofo-addons') => '0',
                       esc_html__('On', 'pofo-addons') => '1'
                      ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox21', 'featurebox34', 'featurebox35') ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Strike line', 'pofo-addons'),
        'param_name' => 'pofo_enable_strike_line',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox21'))
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Separator', 'pofo-addons'),
        'param_name' => 'pofo_enable_separator',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox4', 'featurebox9', 'featurebox20', 'featurebox32', 'featurebox33', 'featurebox35'))
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Box hover', 'pofo-addons'),
        'param_name' => 'pofo_box_hover_effect',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox8', 'featurebox27')),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Box shadow', 'pofo-addons'),
        'param_name' => 'pofo_enable_box_shadow',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'std' => '1', 
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox8','featurebox36','featurebox38')),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Process line', 'pofo-addons'),
        'param_name' => 'pofo_enable_process_line',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox10','featurebox11'))
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Number / Icon border', 'pofo-addons'),
        'param_name' => 'pofo_enable_border',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox10', 'featurebox12') ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Link on text', 'pofo-addons'),
        'param_name' => 'pofo_enable_link',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox37', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Link target', 'pofo-addons'),
        'param_name' => 'pofo_link_target',
        'value' => array(esc_html__('Self', 'pofo-addons') => '_self', 
                           esc_html__('New tab / window', 'pofo-addons') => '_blank',
                           esc_html__('One page', 'pofo-addons') => 'one_page',
                          ),
        'dependency'  => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' =>esc_html__( 'Add link on', 'pofo-addons'),
        'param_name' => 'pofo_link_on',
        'admin_label' => true,
        'value' => array( esc_html__( 'Select','pofo-addons') => '',
                          esc_html__( 'Icon / Number','pofo-addons') => 'icon',
                          esc_html__( 'Title','pofo-addons') => 'title',
                          esc_html__( 'All','pofo-addons') => 'all',
                        ),
        'dependency'  => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
      ),
      array(
        'type' => 'textfield',
        'heading' =>esc_html__( 'Link / URL', 'pofo-addons'),
        'param_name' => 'pofo_link_url',
        'admin_label' => true,
        'dependency'  => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
        'description' => esc_html__( 'Enter full URL with http, like http://www.example.com', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Link hover color', 'pofo-addons' ),
        'param_name' => 'pofo_link_hover_color',
        'dependency'  => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Icon size', 'pofo-addons'),
        'param_name' => 'pofo_icon_size',
        'admin_label' => true,
        'value' => array(esc_html__( 'Default', 'pofo-addons') => '',
                         esc_html__( 'Extra large', 'pofo-addons') => 'icon-extra-large', 
                         esc_html__( 'Large', 'pofo-addons') => 'icon-large',
                         esc_html__( 'Extra medium', 'pofo-addons') => 'icon-extra-medium',
                         esc_html__( 'Medium', 'pofo-addons') => 'icon-medium',
                         esc_html__( 'Small', 'pofo-addons') => 'icon-small',
                         esc_html__( 'Extra small', 'pofo-addons') => 'icon-extra-small',
                        ),
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Icon color', 'pofo-addons' ),
        'param_name' => 'pofo_icon_color',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),      
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Icon background color', 'pofo-addons' ),
        'param_name' => 'pofo_icon_bg_color',
        'dependency' => array( 'element' => 'pofo_enable_icon_bg', 'value' => '1' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Box hover border color', 'pofo-addons' ),
        'param_name' => 'pofo_box_hover_border_color',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox3') ),
      ),
      array(
        'type' => 'textfield',
        'class' => '',
        'heading' => esc_html__( 'Box hover border thickness', 'pofo-addons' ),
        'param_name' => 'pofo_box_hover_border_size',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox3') ),
        'description' => esc_html__( 'In pixel like 2px.', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Box hover icon color', 'pofo-addons' ),
        'param_name' => 'pofo_box_hover_icon_color',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox7', 'featurebox8', 'featurebox9', 'featurebox27') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Box hover number color', 'pofo-addons' ),
        'param_name' => 'pofo_box_hover_number_color',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox36') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Box hover background color', 'pofo-addons' ),
        'param_name' => 'pofo_box_hover_bg_color',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox7', 'featurebox8', 'featurebox12', 'featurebox13', 'featurebox15', 'featurebox18', 'featurebox26', 'featurebox27','featurebox36','featurebox37') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Box hover icon background color', 'pofo-addons' ),
        'param_name' => 'pofo_box_hover_icon_bg_color',
        'dependency' => array( 'element' => 'pofo_enable_icon_bg', 'value' => '1' ),
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox8') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Box hover title color', 'pofo-addons' ),
        'param_name' => 'pofo_box_hover_title_color',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox7', 'featurebox8', 'featurebox27','featurebox36') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Box hover content color', 'pofo-addons' ),
        'param_name' => 'pofo_box_hover_content_color',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox8', 'featurebox27') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Separator thickness', 'pofo-addons' ),
        'param_name' => 'pofo_separator_height',
        'dependency' => array( 'element' => 'pofo_enable_separator', 'value' => array('1') ),
        'description' => esc_html__( 'In pixel like 1px.', 'pofo-addons' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Separator width', 'pofo-addons' ),
        'param_name' => 'pofo_separator_width',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox20')),
        'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Separator color', 'pofo-addons' ),
        'param_name' => 'pofo_separator_color',
        'dependency' => array( 'element' => 'pofo_enable_separator', 'value' => array('1') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'class' => '',
        'heading' => esc_html__( 'Box bottom border thickness', 'pofo-addons' ),
        'param_name' => 'pofo_box_border_bottom_size',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox8') ),
        'description' => esc_html__( 'In pixel like 1px.', 'pofo-addons' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Box bottom border color', 'pofo-addons' ),
        'param_name' => 'pofo_box_border_bottom_color',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox8') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_border_type',
        'heading' => esc_html__( 'Number / Icon border type', 'pofo-addons' ),
        'value' => array(esc_html__( 'no border', 'pofo-addons') => '',
                         esc_html__( 'Dotted', 'pofo-addons') => 'dotted',
                         esc_html__( 'Dashed', 'pofo-addons') => 'dashed',
                         esc_html__( 'Solid', 'pofo-addons') => 'solid',
                         esc_html__( 'Double', 'pofo-addons') => 'double',
                        ),
        'std' => 'solid',
        'dependency' => array( 'element' => 'pofo_enable_border', 'value' => array('1') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Number / Icon border thickness', 'pofo-addons' ),
        'param_name' => 'pofo_border_size',
        'dependency' => array( 'element' => 'pofo_enable_border', 'value' => array('1') ),
        'description' => esc_html__( 'In pixel like 2px.', 'pofo-addons' ),
        'value' => '1px',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Number / Icon border color', 'pofo-addons' ),
        'param_name' => 'pofo_border_color',
        'dependency' => array( 'element' => 'pofo_enable_border', 'value' => array('1') ),
        'value' => '#ff214f',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button background color', 'pofo-addons' ),
        'param_name' => 'pofo_button_bg_color',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox34') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button text color', 'pofo-addons' ),
        'param_name' => 'pofo_button_text_color',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox21', 'featurebox34', 'featurebox35') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button hover background color', 'pofo-addons' ),
        'param_name' => 'pofo_button_hover_bg_color',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox34') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button hover text color', 'pofo-addons' ),
        'param_name' => 'pofo_button_hover_text_color',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox21', 'featurebox34', 'featurebox35') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button border color', 'pofo-addons' ),
        'param_name' => 'pofo_button_border_color',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox34') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button border hover color', 'pofo-addons' ),
        'param_name' => 'pofo_button_border_hover_color',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox34') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'content_desktop_width',
        'heading' => esc_html__( 'Content width in desktop', 'pofo-addons' ),
        'value' => $pofo_desktop_width,
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox5', 'featurebox7', 'featurebox8', 'featurebox15', 'featurebox16', 'featurebox21', 'featurebox24', 'featurebox29', 'featurebox31','featurebox36', 'featurebox37', 'featurebox38','featurebox41') ),
        'edit_field_class' => 'vc_col-sm-3 vc_column-with-padding',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'content_desktop_mini_width',
        'heading' => esc_html__( 'Content width in mini desktop', 'pofo-addons' ),
        'value' => $pofo_desktop_mini_width,
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox5', 'featurebox7', 'featurebox8', 'featurebox15', 'featurebox16', 'featurebox21', 'featurebox24', 'featurebox29', 'featurebox31','featurebox36', 'featurebox37', 'featurebox38','featurebox41') ),
        'edit_field_class' => 'vc_col-sm-3',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'content_ipad_width',
        'heading' => esc_html__( 'Content width in tablet', 'pofo-addons' ),
        'value' => $pofo_ipad_width,
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox5', 'featurebox7', 'featurebox8', 'featurebox15', 'featurebox16', 'featurebox21', 'featurebox24', 'featurebox29', 'featurebox31','featurebox36', 'featurebox37', 'featurebox38','featurebox41') ),
        'edit_field_class' => 'vc_col-sm-3',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'content_mobile_width',
        'heading' => esc_html__( 'Content width in mobile', 'pofo-addons' ),
        'value' => $pofo_mobile_width,
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox5', 'featurebox7', 'featurebox8', 'featurebox15', 'featurebox16', 'featurebox21', 'featurebox24', 'featurebox29', 'featurebox31','featurebox36', 'featurebox37', 'featurebox38','featurebox41') ),
        'edit_field_class' => 'vc_col-sm-3',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',          
        'class' => '',
        'heading' => esc_html__( 'Overlay', 'pofo-addons'),
        'param_name' => 'pofo_show_overlay',
        'value' => array(
            esc_html__( 'No', 'pofo-addons') => '0', 
            esc_html__( 'Yes', 'pofo-addons') => '1'
        ),
        'std' => '1',        
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox17') ),
        'group' => esc_html__( 'Overlay', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Overlay color', 'pofo-addons' ),
        'param_name' => 'overlay_color',                
        'group' => esc_html__( 'Overlay', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_show_overlay', 'value' => array('1') ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Overlay opacity', 'pofo-addons' ),
        'param_name' => 'pofo_overlay_opacity',
        'admin_label' => true,
        'value' => array( esc_html__( 'No opacity','pofo-addons') => '',
            '0.1'  => '0.1',
            '0.2'  => '0.2',
            '0.3'  => '0.3',
            '0.4'  => '0.4',
            '0.5'  => '0.5',
            '0.6'  => '0.6',
            '0.7'  => '0.7',
            '0.8'  => '0.8',
            '0.9'  => '0.9',
            '1.0'  => '1.0',
        ),
        'group' => esc_html__( 'Overlay', 'pofo-addons' ),
        'std' => '0.5',
        'dependency' => array( 'element' => 'pofo_show_overlay', 'value' => array('1') ),
      ),
      array(
        'param_name' => 'pofo_custom_number_text_heading', // all params must have a unique name
        'type' => 'pofo_custom_title', // this param type
        'value' => esc_html__( 'Number text typography', 'pofo-addons' ), // your custom markup
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array( 'featurebox1', 'featurebox10', 'featurebox14', 'featurebox25', 'featurebox30', 'featurebox31', 'featurebox33','featurebox38','featurebox36','featurebox41' ) ),
        'responsive_settings' => true,
        'hide_show_element' => 'pofo_number_text_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Font size', 'pofo-addons' ),
        'param_name' => 'pofo_number_text_font_size',
        'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox10', 'featurebox14', 'featurebox25', 'featurebox30', 'featurebox31', 'featurebox33','featurebox38', 'featurebox36','featurebox41' ) ),
        'edit_field_class' => 'pofo_responsive_tab_number_text vc_col-sm-4 vc_column-with-padding',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Line height', 'pofo-addons' ),
        'param_name' => 'pofo_number_text_line_height',
        'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox10', 'featurebox14', 'featurebox25', 'featurebox30', 'featurebox31', 'featurebox33','featurebox38' ,'featurebox36','featurebox41' ) ),
        'edit_field_class' => 'pofo_responsive_tab_number_text vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_number_text_font_weight',
        'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
        'value' => pofo_font_weight_style(),
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox14', 'featurebox25', 'featurebox30', 'featurebox31', 'featurebox33','featurebox38', 'featurebox36','featurebox41') ),
        'edit_field_class' => 'pofo_responsive_tab_number_text vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Element tag', 'pofo-addons'),
        'param_name' => 'pofo_number_element_tag',
        'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                         esc_html__( 'h1', 'pofo-addons') => 'h1',
                         esc_html__( 'h2', 'pofo-addons') => 'h2',
                         esc_html__( 'h3', 'pofo-addons') => 'h3',
                         esc_html__( 'h4', 'pofo-addons') => 'h4',
                         esc_html__( 'h5', 'pofo-addons') => 'h5',
                         esc_html__( 'h6', 'pofo-addons') => 'h6',
                        ),
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox14', 'featurebox25', 'featurebox30', 'featurebox31', 'featurebox33','featurebox38', 'featurebox36','featurebox41' ) ),
        'edit_field_class' => 'pofo_responsive_tab_number_text vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Color', 'pofo-addons' ),
        'param_name' => 'pofo_number_text_color',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox10', 'featurebox14', 'featurebox25', 'featurebox30', 'featurebox31', 'featurebox33','featurebox38','featurebox41') ),
        'edit_field_class' => 'pofo_responsive_tab_number_text vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Hover text color', 'pofo-addons' ),
        'param_name' => 'pofo_number_text_hover_color',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox10') ),
        'edit_field_class' => 'pofo_responsive_tab_number_text vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Hover background color', 'pofo-addons' ),
        'param_name' => 'pofo_number_text_hover_bg_color',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox10') ),
        'edit_field_class' => 'pofo_responsive_tab_number_text vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'responsive_font_settings',
        'param_name' => 'pofo_number_text_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
         //'hide_element_keys' => array( 'text-align', 'font-size', 'line-height', 'letter-spacing', 'font-transform', 'font-weight' ),
        'hide_element_keys' => array( 'text-align', 'font-transform', 'letter-spacing',),
      ),
      array(
        'param_name' => 'pofo_custom_title_heading', // all params must have a unique name
        'type' => 'pofo_custom_title', // this param type
        'value' => esc_html__( 'Title typography', 'pofo-addons' ), // your custom markup
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
        'responsive_settings' => true,
        'hide_show_element' => 'pofo_title_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Font size', 'pofo-addons' ),
        'param_name' => 'pofo_title_font_size',
        'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4 vc_column-with-padding',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Line height', 'pofo-addons' ),
        'param_name' => 'pofo_title_line_height',
        'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
        'param_name' => 'pofo_title_letter_spacing',
        'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_title_font_weight',
        'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
        'value' => pofo_font_weight_style(),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font italic', 'pofo-addons'),
        'param_name' => 'pofo_title_italic',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font underline', 'pofo-addons'),
        'param_name' => 'pofo_title_underline',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),      
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Element tag', 'pofo-addons'),
        'param_name' => 'pofo_title_element_tag',
        'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                         esc_html__( 'h1', 'pofo-addons') => 'h1',
                         esc_html__( 'h2', 'pofo-addons') => 'h2',
                         esc_html__( 'h3', 'pofo-addons') => 'h3',
                         esc_html__( 'h4', 'pofo-addons') => 'h4',
                         esc_html__( 'h5', 'pofo-addons') => 'h5',
                         esc_html__( 'h6', 'pofo-addons') => 'h6',
                        ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Color', 'pofo-addons' ),
        'param_name' => 'pofo_title_color',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
        'param_name' => 'pofo_title_enable_responsive_font',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox1', 'featurebox2', 'featurebox3', 'featurebox4', 'featurebox5', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox9', 'featurebox10', 'featurebox11', 'featurebox12', 'featurebox13', 'featurebox14', 'featurebox15', 'featurebox16', 'featurebox17', 'featurebox18', 'featurebox19', 'featurebox20', 'featurebox21', 'featurebox22', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox26', 'featurebox27', 'featurebox28', 'featurebox29', 'featurebox30', 'featurebox31', 'featurebox32', 'featurebox33', 'featurebox34', 'featurebox35','featurebox36', 'featurebox38', 'featurebox39', 'featurebox40','featurebox41')),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Use additional font for title', 'pofo-addons'),
        'param_name' => 'pofo_enable_title_alternate_font',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'std'   => '1',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array( 'featurebox24', 'featurebox39' )),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-6',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
      'type' => 'responsive_font_settings',
      'param_name' => 'pofo_title_responsive_settings',
      'group' => esc_html__( 'Typography', 'pofo-addons' ),
      'hide_element_keys' => array( 'text-align', 'font-transform', ),
    ),
      array(
        'param_name' => 'pofo_custom_subtitle_heading', // all params must have a unique name
        'type' => 'pofo_custom_title', // this param type
        'value' => esc_html__( 'Subtitle typography', 'pofo-addons' ), // your custom markup
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox12', 'featurebox14', 'featurebox18', 'featurebox23', 'featurebox24', 'featurebox26', 'featurebox28', 'featurebox29', 'featurebox30')),
        'responsive_settings' => true,
        'hide_show_element' => 'pofo_subtitle_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Font size', 'pofo-addons' ),
        'param_name' => 'pofo_subtitle_font_size',
        'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox12', 'featurebox14', 'featurebox18', 'featurebox23', 'featurebox24', 'featurebox26', 'featurebox28', 'featurebox29', 'featurebox30')),
        'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4 vc_column-with-padding',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Line height', 'pofo-addons' ),
        'param_name' => 'pofo_subtitle_line_height',
        'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox12', 'featurebox14', 'featurebox18', 'featurebox23', 'featurebox24', 'featurebox26', 'featurebox28', 'featurebox29', 'featurebox30')),
        'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
        'param_name' => 'pofo_subtitle_letter_spacing',
        'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox12', 'featurebox14', 'featurebox18', 'featurebox23', 'featurebox24', 'featurebox26', 'featurebox28', 'featurebox29', 'featurebox30')),
        'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_subtitle_font_weight',
        'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
        'value' => pofo_font_weight_style(),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox12', 'featurebox14', 'featurebox18', 'featurebox23', 'featurebox24', 'featurebox26', 'featurebox28', 'featurebox29', 'featurebox30')),
        'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Color', 'pofo-addons' ),
        'param_name' => 'pofo_subtitle_color',
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox12', 'featurebox14', 'featurebox18', 'featurebox23', 'featurebox24', 'featurebox26', 'featurebox28', 'featurebox29', 'featurebox30')),
        'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
        'param_name' => 'pofo_subtitle_enable_responsive_font',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox4', 'featurebox12', 'featurebox14', 'featurebox18', 'featurebox23', 'featurebox24', 'featurebox26', 'featurebox28', 'featurebox29', 'featurebox30')),
        'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
      'type' => 'responsive_font_settings',
      'param_name' => 'pofo_subtitle_responsive_settings',
      'group' => esc_html__( 'Typography', 'pofo-addons' ),
      'hide_element_keys' => array( 'text-align', 'font-transform', ),
    ),
      array(
        'type' => 'css_editor',
        'heading' => esc_html__( 'CSS Box', 'pofo-addons' ),
        'param_name' => 'css',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox3', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox14', 'featurebox20', 'featurebox21', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox27','featurebox36', 'featurebox38', 'featurebox40','featurebox41') ),
        'group' => esc_html__( 'Design Options', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_bg_image_type', 
        'heading' => esc_html__( 'Background type', 'pofo-addons' ),
        'value' => array(esc_html__('Select background type', 'pofo-addons') => '',
                       esc_html__('Fix background', 'pofo-addons') => 'fix-background',
                       esc_html__('Cover background', 'pofo-addons') => 'cover-background',
                       //esc_html__('Fill background', 'pofo-addons') => 'fill',
                      ),
        'edit_field_class' => 'vc_col-sm-3 vc_column-with-padding',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox3', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox14', 'featurebox20', 'featurebox21', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox27','featurebox36', 'featurebox38'. 'featurebox40','featurebox41') ),
        'group' => esc_html__( 'Design Options', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Background position', 'pofo-addons' ),
        'param_name' => 'desktop_bg_image_position',
        'value' => $pofo_desktop_bg_image_position,
        'edit_field_class' => 'vc_col-sm-3',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox3', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox14', 'featurebox20', 'featurebox21', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox27','featurebox36', 'featurebox38', 'featurebox40','featurebox41') ),
        'group' => esc_html__( 'Design Options', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Width', 'pofo-addons' ),
        'param_name' => 'desktop_width',
        'value' => '',
        'edit_field_class' => 'vc_col-sm-3',
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox3', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox14', 'featurebox20', 'featurebox21', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox27','featurebox36', 'featurebox38', 'featurebox40','featurebox41') ),
        'group' => esc_html__( 'Design Options', 'pofo-addons' ),
      ),
      array(
        'param_name' => 'pofo_custom_separator_heading', // all params must have a unique name
        'type' => 'pofo_custom_title', // this param type
        'value' => '', // your custom markup
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox3', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox14', 'featurebox20', 'featurebox21', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox27','featurebox36', 'featurebox38', 'featurebox40','featurebox41') ),
        'group' => esc_html__( 'Design Options', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => esc_html__( 'Enable Responsive CSS', 'pofo-addons'),
        'param_name' => 'pofo_enable_responsive_css',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'pofo_feature_type', 'value' => array('featurebox3', 'featurebox6', 'featurebox7', 'featurebox8', 'featurebox14', 'featurebox20', 'featurebox21', 'featurebox23', 'featurebox24', 'featurebox25', 'featurebox27','featurebox36', 'featurebox38', 'featurebox40','featurebox41') ),
        'group' => esc_html__( 'Design Options', 'pofo-addons' ),
      ),
      array(
        'type' => 'responsive_css_editor',
        'heading' => esc_html__( 'Responsive CSS Box', 'pofo-addons' ),
        'param_name' => 'responsive_css',
        'height' => 'no',
        'dependency' => array( 'element' => 'pofo_enable_responsive_css', 'value' => array('1') ),
        'group' => esc_html__( 'Design Options', 'pofo-addons' ),
      ),
      $pofo_vc_extra_id,
      $pofo_vc_extra_class,
    )
  ) );
