<?php
/**
 * Shortcode Map For Image Slider
 *
 * @package Pofo
 */
?>
<?php 
/*-----------------------------------------------------------------------------------*/
/* Image Slider */
/*-----------------------------------------------------------------------------------*/
  vc_map( 
    array(
        'name' => esc_html__( 'Image Slider' , 'pofo-addons' ), //Name of your shortcode for human reading inside element list
        'base' => 'pofo_slider', //Shortcode tag. For [my_shortcode] shortcode base is my_shortcode
        'description' => esc_html__( 'Place an image slider', 'pofo-addons' ), //Short description of your element, it will be visible in 'Add element' window
        'icon' => 'fas fa-arrows-alt-h pofo-shortcode-icon', //URL or CSS class with icon image.
        'category' => 'Pofo',
        'params' => array( //List of shortcode attributes. Array which holds your shortcode params, these params will be editable in shortcode settings page
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Style', 'pofo-addons'),
                'param_name' => 'slider_premade_style',
                'admin_label' => true,
                'value' => array(esc_html__( 'Select style', 'pofo-addons') => '',
                                 esc_html__( 'Style 1', 'pofo-addons') => 'pofo-slider1',
                                 esc_html__( 'Style 2', 'pofo-addons') => 'pofo-slider2',
                                 esc_html__( 'Style 3', 'pofo-addons') => 'pofo-slider3',
                                 esc_html__( 'Style 4', 'pofo-addons') => 'pofo-slider4',
                                 esc_html__( 'Style 5', 'pofo-addons') => 'pofo-slider5',
                                 esc_html__( 'Style 6', 'pofo-addons') => 'pofo-slider6',
                                 esc_html__( 'Style 7', 'pofo-addons') => 'pofo-slider7',
                                 esc_html__( 'Style 8', 'pofo-addons') => 'pofo-slider8',
                                 esc_html__( 'Style 9', 'pofo-addons') => 'pofo-slider9',
                                 esc_html__( 'Style 10', 'pofo-addons') => 'pofo-slider10',
                                ),
            ),
            array(
                'type' => 'pofo_preview_image',
                'heading' => esc_html__( 'Select pre-made style', 'pofo-addons'),
                'param_name' => 'slider_preview_image',
                'admin_label' => true,
                'value' => array(esc_html__( 'Select a slider image', 'pofo-addons') => '',
                                 esc_html__( 'Style 1', 'pofo-addons') => 'pofo-slider1',
                                 esc_html__( 'Style 2', 'pofo-addons') => 'pofo-slider2',
                                 esc_html__( 'Style 3', 'pofo-addons') => 'pofo-slider3',
                                 esc_html__( 'Style 4', 'pofo-addons') => 'pofo-slider4',
                                 esc_html__( 'Style 5', 'pofo-addons') => 'pofo-slider5',
                                 esc_html__( 'Style 6', 'pofo-addons') => 'pofo-slider6',
                                 esc_html__( 'Style 7', 'pofo-addons') => 'pofo-slider7',
                                 esc_html__( 'Style 8', 'pofo-addons') => 'pofo-slider8',
                                 esc_html__( 'Style 9', 'pofo-addons') => 'pofo-slider9',
                                 esc_html__( 'Style 10', 'pofo-addons') => 'pofo-slider10',
                                ),
            ),
            array(
                  'type' => 'pofo_custom_switch_option',
                  'holder' => 'div',
                  'class' => '',
                  'heading' => esc_html__( 'Center Slide', 'pofo-addons'),
                  'param_name' => 'show_center_slide',
                  'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                                   esc_html__( 'On', 'pofo-addons') => '1'
                                  ),
                  'std' => '1',
                  'description' => esc_html__( 'Select ON to show center slide in slider', 'pofo-addons' ),
                  'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
            ),
            array(
                  'type' => 'pofo_custom_switch_option',
                  'heading' => esc_html__( 'Box shadow', 'pofo-addons'),
                  'param_name' => 'pofo_enable_box_shadow',
                  'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                                   esc_html__( 'On', 'pofo-addons') => '1'
                                  ),
                  'std' => '0', 
                  'dependency'  => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6')),
            ),
            array(
                  'type' => 'pofo_custom_switch_option',
                  'holder' => 'div',
                  'class' => '',
                  'heading' => esc_html__( 'Pagination', 'pofo-addons'),
                  'param_name' => 'show_pagination',
                  'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                                   esc_html__( 'On', 'pofo-addons') => '1'
                                  ),
                  'std' => '1',
                  'description' => esc_html__( 'Select ON to show pagination in slider', 'pofo-addons' ),
                  'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider5', 'pofo-slider6', 'pofo-slider7', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Pagination style', 'pofo-addons'),
                'param_name' => 'show_pagination_style',
                'admin_label' => true,
                'value' => array(esc_html__( 'Select pagination style', 'pofo-addons') => '',
                                 esc_html__( 'Dot style', 'pofo-addons') => '0',
                                 esc_html__( 'Line style', 'pofo-addons') => '1',
                                ),
                'dependency' => array( 'element' => 'show_pagination', 'value' => array('1') ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Pagination color style', 'pofo-addons'),
                'param_name' => 'show_pagination_color_style',
                'admin_label' => true,
                'value' => array(esc_html__( 'Select pagination color style', 'pofo-addons') => '',
                                 esc_html__( 'Dark style', 'pofo-addons') => '0',
                                 esc_html__( 'Light style', 'pofo-addons') => '1'
                                ),
                'dependency' => array( 'element' => 'show_pagination', 'value' => array('1') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Navigation', 'pofo-addons'),
              'param_name' => 'show_navigation',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'Select ON to show navigation in slider', 'pofo-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4','pofo-slider5', 'pofo-slider7', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Navigation style', 'pofo-addons'),
              'param_name' => 'show_navigation_style',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select navigation style', 'pofo-addons') => '',
                               esc_html__( 'Next/Prev long arrow', 'pofo-addons') => '0',
                               esc_html__( 'Next/Prev black arrow', 'pofo-addons') => '1',
                               esc_html__( 'Next/Prev white arrow', 'pofo-addons') => '2',
                               esc_html__( 'Next/Prev angel white arrow', 'pofo-addons') => '3'
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider5', 'pofo-slider7', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Navigation background color', 'pofo-addons' ),
              'param_name' => 'pofo_navigation_bg_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider4') ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Navigation color', 'pofo-addons' ),
              'param_name' => 'pofo_navigation_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider4') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Cursor color style', 'pofo-addons'),
              'param_name' => 'show_cursor_color_style',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select cursor color style', 'pofo-addons') => '',
                               esc_html__( 'White cursor', 'pofo-addons') => 'white-move',
                               esc_html__( 'Black cursor', 'pofo-addons') => 'black-move',
                               esc_html__( 'Default cursor', 'pofo-addons') => 'no-move',
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider5','pofo-slider6', 'pofo-slider7', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
            ),
            array(
              'param_name' => 'pofo_image_slides', // all params must have a unique name
              'type' => 'param_group', // this param type
              'heading' => esc_html__( 'Slide', 'pofo-addons' ),
              'value' => '',
              'params' => array(
                  array(
                      'type' => 'attach_image',
                      'heading' => esc_html__( 'Image', 'pofo-addons'),
                      'param_name' => 'pofo_image',
                      'holder' => 'div'
                  ),
                  array(
                      'type' => 'dropdown',
                      'heading' => esc_html__( 'Image thumbnail size', 'pofo-addons' ),
                      'param_name' => 'pofo_image_srcset',
                      'value' => pofo_get_thumbnail_image_sizes(),
                      'std' => 'full',
                  ),
                  array(
                      'type' => 'textfield',
                      'heading' => esc_html__( 'Title', 'pofo-addons'),
                      'param_name' => 'pofo_title',
                      'admin_label' => true,
                      'description' => esc_html__( 'Notes: It will only apply if your selected image slider style contains the title. and Use || to break the word in new line.', 'pofo-addons'),
                  ),
                  array(
                      'type' => 'textarea',
                      'heading' => esc_html__( 'Content', 'pofo-addons'),
                      'param_name' => 'pofo_content',
                      'description' => esc_html__( 'Notes: It will only apply if your selected image slider style contains the content', 'pofo-addons'),
                  ),
                  array(
                      'type' => 'dropdown',
                      'heading' => esc_html__( 'Choose button', 'pofo-addons'),
                      'param_name' => 'pofo_no_button',
                      'value' => array(esc_html__( 'No button', 'pofo-addons') => '',
                                       esc_html__( 'One button', 'pofo-addons') => 'singlebutton',
                                       esc_html__( 'Two button', 'pofo-addons') => 'twobutton',
                                      ),
                      'description' => esc_html__( 'Hide/show buttons in slide (Notes: It will only apply if your selected image slider style contains the button)', 'pofo-addons'),
                  ),
                  array(
                    'type'        => 'vc_link',
                    'heading'     => esc_html__( 'Button 1 configuration', 'pofo-addons' ),
                    'param_name'  => 'pofo_first_button_config',
                    'dependency'  => array( 'element' => 'pofo_no_button', 'value' => array('singlebutton','twobutton') ),
                  ),
                  array(
                    'type' => 'pofo_custom_switch_option',
                    'heading' => esc_html__('Button 1 one page navigation', 'pofo-addons'),
                    'param_name' => 'pofo_first_button_one_page',
                    'value' => array(esc_html__('Off', 'pofo-addons') => '0',
                                     esc_html__('On', 'pofo-addons') => '1'
                                    ),
                    'dependency'  => array( 'element' => 'pofo_no_button', 'value' => array('singlebutton','twobutton') ),
                  ),
                  array(
                    'type'        => 'vc_link',
                    'heading'     => esc_html__( 'Button 2 Configuration', 'pofo-addons' ),
                    'param_name'  => 'pofo_second_button_config',
                    'dependency'  => array( 'element' => 'pofo_no_button', 'value' => array('twobutton') ),
                  ),
                  array(
                    'type' => 'pofo_custom_switch_option',
                    'heading' => esc_html__('Button 2 one page navigation', 'pofo-addons'),
                    'param_name' => 'pofo_second_button_one_page',
                    'value' => array(esc_html__('Off', 'pofo-addons') => '0',
                                     esc_html__('On', 'pofo-addons') => '1'
                                    ),
                    'dependency'  => array( 'element' => 'pofo_no_button', 'value' => array('twobutton') ),
                  ),
              ),
              'callbacks' => array(
                  'after_add' => 'vcChartParamAfterAddCallback',
              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'param_name' => 'pofo_image_slides_style_seven', // all params must have a unique name
              'type' => 'param_group', // this param type
              'heading' => esc_html__( 'Slide', 'pofo-addons' ),
              'value' => '',
              'params' => array(
                  array(
                      'type' => 'attach_image',
                      'heading' => esc_html__( 'Image', 'pofo-addons'),
                      'param_name' => 'pofo_image',
                      'holder' => 'div'
                  ),
                  array(
                      'type' => 'dropdown',
                      'heading' => esc_html__( 'Image thumbnail size', 'pofo-addons' ),
                      'param_name' => 'pofo_image_srcset',
                      'value' => pofo_get_thumbnail_image_sizes(),
                      'std' => 'full',
                  ),
                  array(
                      'type' => 'textfield',
                      'heading' => esc_html__( 'Link / URL', 'pofo-addons' ),
                      'param_name' => 'pofo_image_link',
                      'value' => '',
                      'admin_label' => true,
                      'description' => esc_html__( 'Enter full URL with http, like http://www.example.com', 'pofo-addons' ),
                  ),
                  array(
                      'type' => 'dropdown',
                      'heading' => esc_html__( 'Link target', 'pofo-addons'),
                      'param_name' => 'pofo_image_link_target',
                      'value' => array(esc_html__('Self', 'pofo-addons') => '_self', 
                                       esc_html__('New tab / window', 'pofo-addons') => '_blank',
                                       esc_html__('One page', 'pofo-addons') => 'one_page',
                                      ),
                      'admin_label' => true,
                  ),
              ),
              'callbacks' => array(
                  'after_add' => 'vcChartParamAfterAddCallback',
              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6', 'pofo-slider7') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
                'type' => 'attach_images',
                'heading' => esc_html__('Images', 'pofo-addons'),
                'param_name' => 'image_gallery',
                'holder' => 'div',
                'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
                'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Image thumbnail size', 'pofo-addons' ),
                'param_name' => 'pofo_image_srcset',
                'value' => pofo_get_thumbnail_image_sizes(),
                'std' => 'full',
                'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
                'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'pofo-addons'),
                'param_name' => 'pofo_title',
                'admin_label' => true,
                'description' => esc_html__( 'Notes: It will only apply if your selected image slider style contains the title. and Use || to break the word in new line.', 'pofo-addons'),
                'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
                'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Content', 'pofo-addons'),
                'param_name' => 'pofo_subtitle',
                'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
                'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type'        => 'pofo_custom_social_sorting',
              'heading'     => esc_html__( 'Social sorting', 'pofo-addons'),
              'param_name'  => 'pofo_social_sorting',
              'value'      => array(
                                  esc_html__( 'Facebook', 'pofo-addons')      => 'facebook',
                                  esc_html__( 'Twitter', 'pofo-addons')       => 'twitter',
                                  esc_html__( 'Google+', 'pofo-addons')       => 'gplus',
                                  esc_html__( 'Dribbble', 'pofo-addons')      => 'dribbble',
                                  esc_html__( 'LinkedIn', 'pofo-addons')      => 'linkedin',
                                  esc_html__( 'Instagram', 'pofo-addons')     => 'instagram',
                                  esc_html__( 'Tumblr', 'pofo-addons')        => 'tumblr',
                                  esc_html__( 'Pinterest', 'pofo-addons')     => 'pinterest',
                                  esc_html__( 'Youtube', 'pofo-addons')       => 'youtube',
                                  esc_html__( 'Vimeo', 'pofo-addons')         => 'vimeo',
                                  esc_html__( 'Soundcloud', 'pofo-addons')    => 'soundcloud',
                                  esc_html__( 'Flickr', 'pofo-addons')        => 'flickr',
                                  esc_html__( 'RSS', 'pofo-addons')           => 'rss',
                                  esc_html__( 'Reddit', 'pofo-addons')        => 'reddit',
                                  esc_html__( 'Behance', 'pofo-addons')       => 'behance',
                                  esc_html__( 'Vine', 'pofo-addons')          => 'vine',
                                  esc_html__( 'GitHub', 'pofo-addons')        => 'github',
                                  esc_html__( 'Xing', 'pofo-addons')          => 'xing',
                                  esc_html__( 'VK', 'pofo-addons')            => 'vk',
                                  esc_html__( 'Yelp', 'pofo-addons')          => 'yelp',
                                  esc_html__( 'Discord', 'pofo-addons')       => 'discord',
                                  esc_html__( 'Email address', 'pofo-addons') => 'email',
                                  esc_html__( 'Skype', 'pofo-addons')         => 'skype',
                              ),
              'std' => '',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Facebook URL', 'pofo-addons'),
              'param_name' => 'pofo_fb_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Twitter URL', 'pofo-addons'),
              'param_name' => 'pofo_tw_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Google+ URL', 'pofo-addons'),
              'param_name' => 'pofo_gp_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Dribbble URL', 'pofo-addons'),
              'param_name' => 'pofo_db_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Linkedin URL', 'pofo-addons'),
              'param_name' => 'pofo_li_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Instagram URL', 'pofo-addons'),
              'param_name' => 'pofo_ig_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Tumblr URL', 'pofo-addons'),
              'param_name' => 'pofo_tb_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Pinterest URL', 'pofo-addons'),
              'param_name' => 'pofo_pi_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Youtube URL', 'pofo-addons'),
              'param_name' => 'pofo_yt_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Vimeo URL', 'pofo-addons'),
              'param_name' => 'pofo_vm_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Soundcloud URL', 'pofo-addons'),
              'param_name' => 'pofo_sc_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Flickr URL', 'pofo-addons'),
              'param_name' => 'pofo_fk_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('RSS URL', 'pofo-addons'),
              'param_name' => 'pofo_rss_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Reddit URL', 'pofo-addons'),
              'param_name' => 'pofo_rd_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Behance URL', 'pofo-addons'),
              'param_name' => 'pofo_bh_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Vine URL', 'pofo-addons'),
              'param_name' => 'pofo_vine_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('GitHub URL', 'pofo-addons'),
              'param_name' => 'pofo_gh_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Xing URL', 'pofo-addons'),
              'param_name' => 'pofo_xing_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('VK URL', 'pofo-addons'),
              'param_name' => 'pofo_vk_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Yelp URL', 'pofo-addons'),
              'param_name' => 'pofo_yelp_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Discord URL', 'pofo-addons'),
              'param_name' => 'pofo_discord_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Email Address', 'pofo-addons'),
              'param_name' => 'pofo_email_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Skype', 'pofo-addons'),
              'param_name' => 'pofo_skype_url',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textarea_raw_html',
              'heading' => esc_html__( 'Custom icons code', 'pofo-addons' ),
              'param_name' => 'pofo_custom_link',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__('Height', 'pofo-addons'),
              'param_name' => 'pofo_slider_height',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider7', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'description' => esc_html__( 'In pixel like 800px.', 'pofo-addons' ),
              'group'       => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Transition Style', 'pofo-addons'),
              'param_name' => 'transition_style',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select Transition Style', 'pofo-addons') => '',
                             esc_html__( 'Slide Style', 'pofo-addons') => 'slide',
                             esc_html__( 'Fade Style', 'pofo-addons') => 'fade',
                             esc_html__( 'Cube Style', 'pofo-addons') => 'cube',
                             esc_html__( 'Coverflow Style', 'pofo-addons') => 'coverflow',
                             esc_html__( 'Flip Style', 'pofo-addons') => 'flip'
                             
                            ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider5', 'pofo-slider6', 'pofo-slider7', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in desktop', 'pofo-addons'),
              'param_name' => 'slides_per_view_desktop',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select slide per view', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '2',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in mini desktop', 'pofo-addons'),
              'param_name' => 'slides_per_view_mini_desktop',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select slide per view', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '2',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in tablet', 'pofo-addons'),
              'param_name' => 'slides_per_view_tablet',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select slide per view', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '2',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in mobile', 'pofo-addons'),
              'param_name' => 'slides_per_view_mobile',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select slide per view', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '1',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per group in desktop', 'pofo-addons'),
              'param_name' => 'slides_per_group_desktop',
              'value' => array(esc_html__( 'Select slide per group', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per group in mini desktop', 'pofo-addons'),
              'param_name' => 'slides_per_group_mini_desktop',
              'value' => array(esc_html__( 'Select slide per group', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per group in tablet', 'pofo-addons'),
              'param_name' => 'slides_per_group_tablet',
              'value' => array(esc_html__( 'Select slide per group', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per group in mobile', 'pofo-addons'),
              'param_name' => 'slides_per_group_mobile',
              'value' => array(esc_html__( 'Select slide per group', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Space between slide in desktop', 'pofo-addons'),
              'param_name' => 'space_between_slide_desktop',
              'admin_label' => true,
              'value' => '',
              'std' => '15',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Space between slide in mini desktop', 'pofo-addons'),
              'param_name' => 'space_between_slide_mini_desktop',
              'admin_label' => true,
              'value' => '',
              'std' => '',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Space between slide in tablet', 'pofo-addons'),
              'param_name' => 'space_between_slide_tablet',
              'admin_label' => true,
              'value' => '',
              'std' => '',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Space between slide in mobile', 'pofo-addons'),
              'param_name' => 'space_between_slide_mobile',
              'admin_label' => true,
              'value' => '',
              'std' => '',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Transition speed', 'pofo-addons'),
              'param_name' => 'slidespeed',
              'admin_label' => true,
              'value' => '',
              'description' => esc_html__( 'Enter slide speed time like 500, where 1000 = 1 second', 'pofo-addons'),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider6', 'pofo-slider7', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Auto play', 'pofo-addons'),
              'param_name' => 'autoplay',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'Select ON to autoplay slider', 'pofo-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider6', 'pofo-slider7', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),            
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Delay time', 'pofo-addons'),
              'param_name' => 'slidedelay',
              'admin_label' => true,
              'value' => '',
              'std' => '3000',
              'description' => esc_html__( 'Enter delay time (before switching to other slide) like 500, where 1000 = 1 second', 'pofo-addons'),
              'dependency'  => array( 'element' => 'autoplay', 'value' => array('1') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Loop', 'pofo-addons'),
              'param_name' => 'autoloop',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'Select ON to autoloop slider', 'pofo-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider6', 'pofo-slider7', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Overlay', 'pofo-addons'),
              'param_name' => 'show_overlay',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider5', 'pofo-slider8', 'pofo-slider10') ),
              'group' => esc_html__( 'Overlay', 'pofo-addons'),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Overlay color', 'pofo-addons' ),
              'param_name' => 'pofo_row_overlay_color',
              'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
              'group' => esc_html__( 'Overlay', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Overlay opacity', 'pofo-addons'),
              'param_name' => 'pofo_overlay_opacity',
              'admin_label' => true,
              'value' => array( esc_html__( 'No opacity','pofo-addons') => '',
                                '0.1'  => '0.1',
                                '0.2'  => '0.2',
                                '0.3'  => '0.3',
                                '0.4'  => '0.4',
                                '0.5'  => '0.5',
                                '0.6'  => '0.6',
                                '0.7'  => '0.7',
                                '0.8'  => '0.8',
                                '0.9'  => '0.9',
                                '1.0'  => '1.0',
                              ),
              'std' => '0.7',
              'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
              'group' => esc_html__( 'Overlay', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Z-index', 'pofo-addons'),
              'param_name' => 'pofo_z_index',
              'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
              'group' => esc_html__( 'Overlay', 'pofo-addons'),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'std' => '1',
              'heading' => esc_html__( 'Content strikethrough', 'pofo-addons'),
              'param_name' => 'pofo_content_strikethrough',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider9') ),
              'group' => esc_html__( 'Style', 'pofo-addons'),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Content background color and opacity', 'pofo-addons' ),
              'param_name' => 'pofo_content_bg_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider4', 'pofo-slider9') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'title_desktop_width',
              'heading' => esc_html__( 'Title width in desktop', 'pofo-addons' ),
              'value' => $pofo_desktop_width,
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'title_desktop_mini_width',
              'heading' => esc_html__( 'Title width in mini desktop', 'pofo-addons' ),
              'value' => $pofo_desktop_mini_width,
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'title_ipad_width',
              'heading' => esc_html__( 'Title width in tablet', 'pofo-addons' ),
              'value' => $pofo_ipad_width,
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'title_mobile_width',
              'heading' => esc_html__( 'Title width in mobile', 'pofo-addons' ),
              'value' => $pofo_mobile_width,
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button 1 background color', 'pofo-addons' ),
              'param_name' => 'pofo_first_button_bg_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button 1 text color', 'pofo-addons' ),
              'param_name' => 'pofo_first_button_text_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button 1 hover background color', 'pofo-addons' ),
              'param_name' => 'pofo_first_button_hover_bg_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button 1 hover text color', 'pofo-addons' ),
              'param_name' => 'pofo_first_button_hover_text_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button 1 border color', 'pofo-addons' ),
              'param_name' => 'pofo_first_button_border_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-12',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button 2 background color', 'pofo-addons' ),
              'param_name' => 'pofo_second_button_bg_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button 2 text color', 'pofo-addons' ),
              'param_name' => 'pofo_second_button_text_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button 2 hover background color', 'pofo-addons' ),
              'param_name' => 'pofo_second_button_hover_bg_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button 2 hover text color', 'pofo-addons' ),
              'param_name' => 'pofo_second_button_hover_text_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button 2 border color', 'pofo-addons' ),
              'param_name' => 'pofo_second_button_border_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'vc_col-sm-12',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__('Icon size', 'pofo-addons'),
              'param_name' => 'pofo_icon_type',
              'value' => array(esc_html__('Select icon size', 'pofo-addons') => '',
                        esc_html__('Extra large', 'pofo-addons') => 'extra-large-icon',
                        esc_html__('Large', 'pofo-addons') => 'large-icon',
                        esc_html__('Medium', 'pofo-addons') => 'medium-icon',
                        esc_html__('Small', 'pofo-addons') => 'small-icon',
                        esc_html__('Extra small', 'pofo-addons') => 'extra-small-icon',
              ),
              'std' => 'large-icon',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Icon color', 'pofo-addons' ),
              'param_name' => 'pofo_icon_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Icon hover color', 'pofo-addons' ),
              'param_name' => 'pofo_icon_hover_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider5') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'param_name' => 'pofo_custom_title_heading', // all params must have a unique name
              'type' => 'pofo_custom_title', // this param type
              'value' => esc_html__( 'Title typography', 'pofo-addons' ), // your custom markup
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'responsive_settings' => true,
              'hide_show_element' => 'pofo_title_responsive_settings',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Font size', 'pofo-addons' ),
              'param_name' => 'pofo_title_font_size',
              'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4 vc_column-with-padding',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Line height', 'pofo-addons' ),
              'param_name' => 'pofo_title_line_height',
              'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
              'param_name' => 'pofo_title_letter_spacing',
              'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'pofo_title_font_weight',
              'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
              'value' => pofo_font_weight_style(),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Font italic', 'pofo-addons'),
              'param_name' => 'pofo_title_italic',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Font underline', 'pofo-addons'),
              'param_name' => 'pofo_title_underline',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Element tag', 'pofo-addons'),
              'param_name' => 'pofo_title_element_tag',
              'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                               esc_html__( 'h1', 'pofo-addons') => 'h1',
                               esc_html__( 'h2', 'pofo-addons') => 'h2',
                               esc_html__( 'h3', 'pofo-addons') => 'h3',
                               esc_html__( 'h4', 'pofo-addons') => 'h4',
                               esc_html__( 'h5', 'pofo-addons') => 'h5',
                               esc_html__( 'h6', 'pofo-addons') => 'h6',
                              ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Color', 'pofo-addons' ),
              'param_name' => 'pofo_title_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
              'param_name' => 'pofo_title_enable_responsive_font',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'responsive_font_settings',
              'param_name' => 'pofo_title_responsive_settings',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
              'hide_element_keys' => array( 'text-align', 'font-transform', ),
            ),
            array(
              'param_name' => 'pofo_custom_content_heading', // all params must have a unique name
              'type' => 'pofo_custom_title', // this param type
              'value' => esc_html__( 'Content typography', 'pofo-addons' ), // your custom markup
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'responsive_settings' => true,
              'hide_show_element' => 'pofo_content_responsive_settings',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Font size', 'pofo-addons' ),
              'param_name' => 'pofo_content_font_size',
              'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4 vc_column-with-padding',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Line height', 'pofo-addons' ),
              'param_name' => 'pofo_content_line_height',
              'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
              'param_name' => 'pofo_content_letter_spacing',
              'description' => esc_html__( 'In pixel like 1px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'pofo_content_font_weight',
              'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
              'value' => pofo_font_weight_style(),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Color', 'pofo-addons' ),
              'param_name' => 'pofo_content_color',
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
              'param_name' => 'pofo_content_enable_responsive_font',
              'value' => array(esc_html__( 'NO', 'pofo-addons') => '0',
                               esc_html__( 'YES', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'slider_premade_style', 'value' => array('pofo-slider1', 'pofo-slider2', 'pofo-slider3', 'pofo-slider4', 'pofo-slider5', 'pofo-slider8', 'pofo-slider9', 'pofo-slider10') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'responsive_font_settings',
              'param_name' => 'pofo_content_responsive_settings',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
              'hide_element_keys' => array( 'text-align', 'font-transform', ),
            ),
            array(
             'type'        => 'textfield',
             'heading'     => esc_html__( 'Element ID', 'pofo-addons' ),
             'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %s).', 'pofo-addons'), '<a target="_blank" href="https://www.w3schools.com/tags/att_global_id.asp">w3c specification</a>'),
             'param_name'  => 'pofo_slider_id',
             'group'       => esc_html__( 'Extras', 'pofo-addons' ),
            ),
            array(
             'type'        => 'textfield',
             'heading'     => esc_html__( 'Extra class name', 'pofo-addons' ),
             'description' => esc_html__( 'Add additional CSS class to this element, you can define multiple CSS class with use of space like "Class1 Class2". You can write css code using this class and add it in customizer or your child theme css file.', 'pofo-addons' ),
             'param_name'  => 'pofo_slider_class',
             'group'       => esc_html__( 'Extras', 'pofo-addons' ),
            ),
        ),
    )
  );
