<?php
/**
 * Shortcode Map For Inner Column
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Column & Inner Column */
/*-----------------------------------------------------------------------------------*/

  vc_map( 
    array(
        'name' => esc_html__( 'Inner Column' , 'pofo-addons' ),
        'base' => 'vc_column_inner',
        'description' => esc_html__( 'Place content elements inside the column', 'pofo-addons' ),
        'icon' => 'icon-wpb-row',
        'is_container' => true,
        'content_element' => false,
        'allowed_container_element' => false,
        'category' => 'Pofo',
        'js_view' => 'VcColumnView',
        'params' => array(
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Fullscreen class', 'pofo-addons'),
              'param_name' => 'fullscreen',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'Select On to add (fullscreen) class in section', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'No padding in column', 'pofo-addons'),
              'param_name' => 'no_column_padding',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'If On then this column default padding of left and right will be removed.', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Position relative', 'pofo-addons'),
              'param_name' => 'position_relative',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'pofo_overflow_type', 
              'heading' => esc_html__( 'Overflow', 'pofo-addons' ),
              'value' => array(esc_html__('Select overflow', 'pofo-addons') => '',
                               esc_html__('Overflow visible', 'pofo-addons') => 'overflow-visible',
                               esc_html__('Overflow hidden', 'pofo-addons') => 'overflow-hidden',
                               esc_html__('Overflow auto', 'pofo-addons') => 'overflow-auto',
                              ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'desktop_clear_both',
              'heading' => esc_html__( 'Clear both for desktop', 'pofo-addons' ),
              'value' => array(esc_html__( 'Default', 'pofo-addons') => '',
                               esc_html__( 'Clear both', 'pofo-addons') => 'clear-both',
                               esc_html__( 'Clear none', 'pofo-addons') => 'clear-none',
                              ),
              'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
              'description' => esc_html__( 'If Clear both then this column will go down.', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'desktop_mini_clear_both',
              'heading' => esc_html__( 'Clear both for mini desktop', 'pofo-addons' ),
              'value' => array(esc_html__( 'Default', 'pofo-addons') => '',
                               esc_html__( 'Clear both', 'pofo-addons') => 'md-clear-both',
                               esc_html__( 'Clear none', 'pofo-addons') => 'md-clear-none',
                              ),
              'edit_field_class' => 'vc_col-sm-6',
              'description' => esc_html__( 'If Clear both then this column will go down.', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'ipad_clear_both',
              'heading' => esc_html__( 'Clear both for tablet', 'pofo-addons' ),
              'value' => array(esc_html__( 'Default', 'pofo-addons') => '',
                               esc_html__( 'Clear both', 'pofo-addons') => 'sm-clear-both',
                               esc_html__( 'Clear none', 'pofo-addons') => 'sm-clear-none',
                              ),
              'edit_field_class' => 'vc_col-sm-6',
              'description' => esc_html__( 'If Clear both then this column will go down.', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'mobile_clear_both',
              'heading' => esc_html__( 'Clear both for mobile', 'pofo-addons' ),
              'value' => array(esc_html__( 'Default', 'pofo-addons') => '',
                               esc_html__( 'Clear both', 'pofo-addons') => 'xs-clear-both',
                               esc_html__( 'Clear none', 'pofo-addons') => 'xs-clear-none',
                              ),
              'edit_field_class' => 'vc_col-sm-6',
              'description' => esc_html__( 'If Clear both then this column will go down.', 'pofo-addons' ),
            ),
            array(
              'type' => 'animation_style',
              'heading' => esc_html__( 'CSS animation', 'pofo-addons' ),
              'param_name' => 'pofo_column_animation_style',
              'value' => '',
              'settings' => array(
                'type' => array(
                  'in',
                  'other',
                ),
              ),
              'description' => __( 'Select type of animation for element to be animated when it "enters" the browsers viewport (Note: works only in modern browsers).', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Animation delay', 'pofo-addons' ),
              'param_name' => 'pofo_column_animation_delay',
              'dependency' => array( 'element' => 'pofo_column_animation_style', 'value_not_equal_to' => array( 'none' ) ),
              'description' => esc_html__( 'Add animation delay in mls', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Overlay', 'pofo-addons'),
              'param_name' => 'show_overlay',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'group' => esc_html__( 'Overlay', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Overlay color', 'pofo-addons' ),
              'param_name' => 'pofo_row_overlay_color',
              'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
              'group' => esc_html__( 'Overlay', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Overlay opacity', 'pofo-addons'),
              'param_name' => 'pofo_overlay_opacity',
              'admin_label' => true,
              'value' => array( esc_html__( 'No opacity','pofo-addons') => '',
                                '0.1'  => '0.1',
                                '0.2'  => '0.2',
                                '0.3'  => '0.3',
                                '0.4'  => '0.4',
                                '0.5'  => '0.5',
                                '0.6'  => '0.6',
                                '0.7'  => '0.7',
                                '0.8'  => '0.8',
                                '0.9'  => '0.9',
                                '1.0'  => '1.0',
                              ),
              'std' => '0.7',
              'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
              'group' => esc_html__( 'Overlay', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Z-index', 'pofo-addons'),
              'param_name' => 'pofo_z_index',
              'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
              'group' => esc_html__( 'Overlay', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'SM Width', 'pofo-addons' ),
              'param_name' => 'width',
              'value' => $pofo_vc_column,
              'group' => esc_html__( 'Responsive Options', 'pofo-addons' ),
              'description' => 'Select column width',
            ),
            array(
              'type' => 'column_offset',
              'heading' => esc_html__( 'Responsiveness', 'pofo-addons' ),
              'param_name' => 'offset',
              'group' => esc_html__( 'Responsive Options', 'pofo-addons' ),
              'description' => 'Adjust column for different screen sizes. Control width, offset and visibility settings.',
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'desktop_alignment',
              'heading' => esc_html__( 'Alignment in desktop', 'pofo-addons' ),
              'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                               esc_html__( 'Left align', 'pofo-addons') => 'text-left',
                               esc_html__( 'Right align', 'pofo-addons') => 'text-right',
                               esc_html__( 'Center align', 'pofo-addons') => 'text-center',
                               esc_html__( 'Justify align', 'pofo-addons') => 'text-justify',
                              ),
              'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'desktop_mini_alignment',
              'heading' => esc_html__( 'Alignment in mini desktop', 'pofo-addons' ),
              'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                               esc_html__( 'Left align', 'pofo-addons') => 'md-text-left',
                               esc_html__( 'Right align', 'pofo-addons') => 'md-text-right',
                               esc_html__( 'Center align', 'pofo-addons') => 'md-text-center',
                               esc_html__( 'Justify align', 'pofo-addons') => 'md-text-justify',
                              ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'ipad_alignment',
              'heading' => esc_html__( 'Alignment in tablet', 'pofo-addons' ),
              'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                               esc_html__( 'Left align', 'pofo-addons') => 'sm-text-left',
                               esc_html__( 'Right align', 'pofo-addons') => 'sm-text-right',
                               esc_html__( 'Center align', 'pofo-addons') => 'sm-text-center',
                               esc_html__( 'Justify align', 'pofo-addons') => 'sm-text-justify',
                              ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'mobile_alignment',
              'heading' => esc_html__( 'Alignment in mobile', 'pofo-addons' ),
              'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                               esc_html__( 'Left align', 'pofo-addons') => 'xs-text-left',
                               esc_html__( 'Right align', 'pofo-addons') => 'xs-text-right',
                               esc_html__( 'Center align', 'pofo-addons') => 'xs-text-center',
                               esc_html__( 'Justify align', 'pofo-addons') => 'xs-text-justify',
                              ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'desktop_display',
              'heading' => esc_html__( 'Display in desktop', 'pofo-addons' ),
              'value' => array(esc_html__( 'Select display type', 'pofo-addons') => '',
                               esc_html__( 'Block', 'pofo-addons') => 'display-block',
                               esc_html__( 'Inline', 'pofo-addons') => 'display-inline',
                               esc_html__( 'Inline block', 'pofo-addons') => 'display-inline-block',
                               esc_html__( 'None', 'pofo-addons') => 'display-none',
                              ),
              'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'desktop_mini_display',
              'heading' => esc_html__( 'Display in mini desktop', 'pofo-addons' ),
              'value' => array(esc_html__( 'Select display type', 'pofo-addons') => '',
                               esc_html__( 'Block', 'pofo-addons') => 'md-display-block',
                               esc_html__( 'Inline', 'pofo-addons') => 'md-display-inline',
                               esc_html__( 'Inline block', 'pofo-addons') => 'md-display-inline-block',
                               esc_html__( 'None', 'pofo-addons') => 'md-display-none',
                              ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'ipad_display',
              'heading' => esc_html__( 'Display in tablet', 'pofo-addons' ),
              'value' => array(esc_html__( 'Select display type', 'pofo-addons') => '',
                               esc_html__( 'Block', 'pofo-addons') => 'sm-display-block',
                               esc_html__( 'Inline', 'pofo-addons') => 'sm-display-inline',
                               esc_html__( 'Inline block', 'pofo-addons') => 'sm-display-inline-block',
                               esc_html__( 'None', 'pofo-addons') => 'sm-display-none',
                              ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'mobile_display',
              'heading' => esc_html__( 'Display in mobile', 'pofo-addons' ),
              'value' => array(esc_html__( 'Select display type', 'pofo-addons') => '',
                               esc_html__( 'Block', 'pofo-addons') => 'xs-display-block',
                               esc_html__( 'Inline', 'pofo-addons') => 'xs-display-inline',
                               esc_html__( 'Inline block', 'pofo-addons') => 'xs-display-inline-block',
                               esc_html__( 'None', 'pofo-addons') => 'xs-display-none',
                              ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'css_editor',
              'heading' => esc_html__( 'CSS box', 'pofo-addons' ),
              'param_name' => 'css',
              'group' => esc_html__( 'Design Options', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'pofo_bg_image_type', 
              'heading' => esc_html__( 'Background type', 'pofo-addons' ),
              'value' => array(esc_html__('Select background type', 'pofo-addons') => '',
                               esc_html__('Fix background', 'pofo-addons') => 'fix-background',
                               esc_html__('Cover background', 'pofo-addons') => 'cover-background',
                              ),
              'edit_field_class' => 'vc_col-sm-3 vc_column-with-padding',
              'group' => esc_html__( 'Design Options', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Background position', 'pofo-addons' ),
              'param_name' => 'desktop_bg_image_position',
              'value' => $pofo_desktop_bg_image_position,
              'edit_field_class' => 'vc_col-sm-3',
              'group' => esc_html__( 'Design Options', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Minimum height', 'pofo-addons' ),
              'param_name' => 'desktop_height',
              'value' => '',
              'edit_field_class' => 'vc_col-sm-3',
              'group' => esc_html__( 'Design Options', 'pofo-addons' ),
            ),
            array(
              'param_name' => 'pofo_custom_separator_heading', // all params must have a unique name
              'type' => 'pofo_custom_title', // this param type
              'value' => '', // your custom markup
              'group' => esc_html__( 'Design Options', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Enable responsive css box', 'pofo-addons'),
              'param_name' => 'pofo_enable_responsive_css',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'This will enable mini dekstop, tablet and mobile css options.', 'pofo-addons' ),
              'group' => esc_html__( 'Design Options', 'pofo-addons' ),
            ),
            array(
              'type' => 'responsive_css_editor',
              'heading' => esc_html__( 'Responsive css box', 'pofo-addons' ),
              'param_name' => 'responsive_css',
              'width' => 'no',
              'dependency' => array( 'element' => 'pofo_enable_responsive_css', 'value' => array('1') ),
              'group' => esc_html__( 'Design Options', 'pofo-addons' ),
            ),
            $pofo_vc_extra_id,
            $pofo_vc_extra_class,
        ),
    )
  );