<?php
/**
 * Map For Popup
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Popup */
/*-----------------------------------------------------------------------------------*/

$date = date('Y-m-d H:i:s'); ## Get current date
$time = strtotime($date); ## Get timestamp of current date
vc_map( array(
  'name' => esc_html__('Popup', 'pofo-addons'),
  'description' => esc_html__('Add a popup with content ', 'pofo-addons'),
  'icon' => 'fas fa-expand pofo-shortcode-icon',
  'base' => 'pofo_popup',
  'category' => 'Pofo',
  'params' => array(
      array(
        'type' => 'dropdown',
        'heading' => esc_html__('Type', 'pofo-addons'),
        'param_name' => 'pofo_popup_type',
        'value' => array(esc_html__('Select type', 'pofo-addons') => '',
                  esc_html__('Popup contact form', 'pofo-addons') => 'popup-form-1',
                  esc_html__('Simple modal popup', 'pofo-addons') => 'modal-popup',
                  esc_html__('Youtube video', 'pofo-addons') => 'youtube-video-1',
                  esc_html__('Vimeo video', 'pofo-addons') => 'vimeo-video-1',
                  esc_html__('Html5 video', 'pofo-addons') => 'html5-video-1',
                  esc_html__('Google map', 'pofo-addons') => 'google-map-1',
        ),
      ),
      array(
        'type' => 'pofo_preview_image',
        'heading' => esc_html__('Select pre-made style for popup', 'pofo-addons'),
        'param_name' => 'pofo_popup_preview_image',
        'admin_label' => true,
        'value' => array(esc_html__('Select popup image', 'pofo-addons') => '',
                  esc_html__('Popup contact form', 'pofo-addons') => 'popup-form-1',
                  esc_html__('Simple modal popup', 'pofo-addons') => 'modal-popup',
                  esc_html__('Youtube video', 'pofo-addons') => 'youtube-video-1',
                  esc_html__('Vimeo video', 'pofo-addons') => 'vimeo-video-1',
                  esc_html__('Html5 video', 'pofo-addons') => 'html5-video-1',
                  esc_html__('Google map', 'pofo-addons') => 'google-map-1',
        ),
      ),
      array(
        'type'        => 'textfield',
        'heading'     => esc_html__('Button title', 'pofo-addons'),
        'param_name'  => 'pofo_popup_button_title',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('popup-form-1','modal-popup','youtube-video-1','vimeo-video-1','google-map-1','html5-video-1')),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__('Icon / Image', 'pofo-addons'),
        'param_name' => 'pofo_enable_icon',
        'value' => array(esc_html__('Off', 'pofo-addons') => '0',
                         esc_html__('On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('youtube-video-1','vimeo-video-1','google-map-1','html5-video-1')),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__('Custom icon image', 'pofo-addons'),
        'param_name' => 'custom_icon',
        'value' => array(esc_html__('Off', 'pofo-addons') => '0',
                         esc_html__('On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'pofo_enable_icon', 'value' => array('1')),
      ),
      array(
        'type' => 'attach_image',
        'heading' => esc_html__('Custom image', 'pofo-addons'),
        'param_name' => 'custom_icon_image',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
        'description' => esc_html__( 'Recommended size: Extra Large - 60px X 60px, Large - 50px X 50px, Medium - 40px X 40px, Small - 25px X 25px, Extra Small - 18px X 18px', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Maximum width', 'pofo-addons' ),
        'param_name' => 'custom_icon_max_height',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
        'description' => esc_html__( 'In pixel like 40px.', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Icon Size', 'pofo-addons'),
        'param_name' => 'pofo_icon_size',
        'admin_label' => true,
        'value' => array( esc_html__( 'Default','pofo-addons') => '',
                          esc_html__( 'Extra large','pofo-addons') => 'icon-extra-large', 
                          esc_html__( 'Large','pofo-addons') => 'icon-large',
                          esc_html__( 'Extra medium','pofo-addons') => 'icon-extra-medium',
                          esc_html__( 'Medium','pofo-addons') => 'icon-medium',
                          esc_html__( 'Small','pofo-addons') => 'icon-small',
                          esc_html__( 'Very small','pofo-addons') => 'icon-very-small',
                          esc_html__( 'Extra small','pofo-addons') => 'icon-extra-small',
                        ),
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__('Enable background icon', 'pofo-addons'),
        'param_name' => 'enable_background_icon',
        'value' => array(esc_html__('Off', 'pofo-addons') => '0',
                         esc_html__('On', 'pofo-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'custom_icon', 'value' => array('0')),
      ),
      array(
        'type' => 'pofo_icon',
        'heading' => esc_html__('Font icon', 'pofo-addons'),
        'param_name' => 'pofo_icon_list',
        'admin_label' => true,
        'description' => esc_html__('Select Font Type', 'pofo-addons'),
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Select form', 'pofo-addons' ),
        'param_name' => 'pofo_contact_forms_shortcode',
        'value' => $contact_forms,
        'description' => esc_html__( 'Select your desired form generated using contact form 7 plugin to make it visible in the popup.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('popup-form-1') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Popup title', 'pofo-addons'),
        'param_name' => 'pofo_inside_popup_title',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('modal-popup')),
      ),
      array(
        'type' => 'textarea_html',
        'heading' => esc_html__('Popup content', 'pofo-addons'),
        'param_name' => 'content',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('modal-popup')),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('YouTube URL', 'pofo-addons'),
        'param_name' => 'pofo_popup_youtube_url',
        'description' => esc_html__( 'Add YOUTUBE VIDEO URL like https://www.youtube.com/watch?v=xxxxxxxxxx, you will get this from youtube.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('youtube-video-1')),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Vimeo URL', 'pofo-addons'),
        'param_name' => 'pofo_popup_vimeo_url',
        'description' => esc_html__( 'Add VIMEO VIDEO URL like https://player.vimeo.com/video/xxxxxxxxxx, you will get this from vimeo.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('vimeo-video-1')),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('MP4 URL', 'pofo-addons'),
        'param_name' => 'pofo_popup_mp4_url',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('html5-video-1')),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('WEBM URL', 'pofo-addons'),
        'param_name' => 'pofo_popup_webm_url',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('html5-video-1')),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('OGG URL', 'pofo-addons'),
        'param_name' => 'pofo_popup_ogg_url',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('html5-video-1')),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Google map URL', 'pofo-addons'),
        'param_name' => 'pofo_popup_google_map_url',
        'description' => esc_html__( 'Add GOOGLE MAP URL like https://www.google.com/maps/embed?pb=xxxxxxxxxx, you will get this from google map.', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('google-map-1')),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => esc_html__('Auto play', 'pofo-addons'),
        'param_name' => 'video_autoplay',
        'value' => array(esc_html__('Off', 'pofo-addons') => '0', 
                         esc_html__('On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('html5-video-1')),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => esc_html__('Mute', 'pofo-addons'),
        'param_name' => 'video_muted',
        'value' => array(esc_html__('Off', 'pofo-addons') => '0', 
                         esc_html__('On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('html5-video-1')),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => esc_html__('Loop', 'pofo-addons'),
        'param_name' => 'video_loop',
        'value' => array(esc_html__('Off', 'pofo-addons') => '0', 
                         esc_html__('On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('html5-video-1')),
      ), 
      array(
        'type' => 'pofo_custom_switch_option',
        'holder' => 'div',
        'class' => '',
        'heading' => esc_html__('Controls', 'pofo-addons'),
        'param_name' => 'video_controls',
        'value' => array(esc_html__('Off', 'pofo-addons') => '0', 
                         esc_html__('On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('html5-video-1')),
      ),
      array(
        'type' => 'textfield',
        'std'  => esc_html__( 'Dismiss','pofo-addons' ),
        'heading' => esc_html__('Dismiss text', 'pofo-addons'),
        'param_name' => 'pofo_dismiss_text',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('modal-popup')),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Popup ID', 'pofo-addons'),
        'param_name' => 'pofo_popup_form_id',
        'value' => $time,
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('popup-form-1','modal-popup','html5-video-1')),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__('Animation style', 'pofo-addons'),
        'param_name' => 'pofo_popup_animation_effect',
        'value' => array(esc_html__('Select animation style', 'pofo-addons') => '',
                  esc_html__('Move animation', 'pofo-addons') => 'popup-with-move-anim',
                  esc_html__('Zoom animation', 'pofo-addons') => 'popup-with-zoom-anim',
        ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('modal-popup')),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Icon color', 'pofo-addons' ),
        'param_name' => 'pofo_icon_color',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'heading' => esc_html__( 'Icon background color', 'pofo-addons' ),
        'param_name' => 'background_icon_main_color',
        'dependency' => array( 'element' => 'enable_background_icon', 'value' => '1' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'heading' => esc_html__( 'Icon background gradient color', 'pofo-addons' ),
        'param_name' => 'background_icon_gradient_color',
        'dependency' => array( 'element' => 'enable_background_icon', 'value' => '1' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__('Button size', 'pofo-addons'),
        'param_name' => 'pofo_button_type',
        'value' => array(esc_html__('Select Button Size', 'pofo-addons') => '',
                  esc_html__('Extra Large', 'pofo-addons') => 'extra-large',
                  esc_html__('Large', 'pofo-addons') => 'large',
                  esc_html__('Medium', 'pofo-addons') => 'medium',
                  esc_html__('Small', 'pofo-addons') => 'small',
                  esc_html__('Very Small', 'pofo-addons') => 'very-small',
        ),
        'std' => 'medium',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('popup-form-1','modal-popup','youtube-video-1','vimeo-video-1','google-map-1','html5-video-1')),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button background color', 'pofo-addons' ),
        'param_name' => 'pofo_button_bg_color',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('popup-form-1','modal-popup','youtube-video-1','vimeo-video-1','google-map-1','html5-video-1')),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button text color', 'pofo-addons' ),
        'param_name' => 'pofo_button_text_color',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('popup-form-1','modal-popup','youtube-video-1','vimeo-video-1','google-map-1','html5-video-1')),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button hover background color', 'pofo-addons' ),
        'param_name' => 'pofo_button_hover_bg_color',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('popup-form-1','modal-popup','youtube-video-1','vimeo-video-1','google-map-1','html5-video-1')),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button hover text color', 'pofo-addons' ),
        'param_name' => 'pofo_button_hover_text_color',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('popup-form-1','modal-popup','youtube-video-1','vimeo-video-1','google-map-1','html5-video-1')),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button border color', 'pofo-addons' ),
        'param_name' => 'pofo_button_border_color',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('popup-form-1','modal-popup','youtube-video-1','vimeo-video-1','google-map-1','html5-video-1')),
      ),
        array(
      'type' => 'pofo_custom_switch_option',
      'holder' => 'div',
      'class' => '',
      'heading' => esc_html__('Responsive Video', 'pofo-addons'),
      'param_name' => 'enable_responsive_video',
      'value' => array(esc_html__('Off', 'pofo-addons') => '0', 
                       esc_html__('On', 'pofo-addons') => '1'
                      ),
      'std' => '0',
      'description' => esc_html__( 'Please enter width and height in the same proportion of video size in YouTube or Vimeo to have better result in case if you want fixed size video instead of auto responsive behaviour.', 'pofo-addons' ),
      'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array( 'youtube-video-1','vimeo-video-1','google-map-1','html5-video-1' )),
      'group'       => esc_html__('Responsive', 'pofo-addons')
    ),
    array(
      'type'        => 'textfield',
      'heading'     => esc_html__('Max Width for desktop', 'pofo-addons' ),
      'param_name'  => 'pofo_max_width_desktop',
      'description' => esc_html__( 'For use Youtube & Vimeo video In pixel like 900px', 'pofo-addons' ),
      'dependency'  => array( 'element' => 'enable_responsive_video', 'value' => array('0') ),
      'group'       => esc_html__('Responsive', 'pofo-addons'),
      'edit_field_class' => 'vc_col-sm-6',

    ),
    array(
      'type'        => 'textfield',
      'heading'     => esc_html__('Max width for Mini desktop', 'pofo-addons' ),
      'param_name'  => 'pofo_max_width_minidesktop',
      'description' => esc_html__( 'For use Youtube & Vimeo video In pixel like 900px', 'pofo-addons' ),
      'dependency'  => array( 'element' => 'enable_responsive_video', 'value' => array('0') ),
      'group'       => esc_html__('Responsive', 'pofo-addons'),
      'edit_field_class' => 'vc_col-sm-6',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => esc_html__('Max width for tablet', 'pofo-addons' ),
      'param_name'  => 'pofo_max_width_tablet',
      'description' => esc_html__( 'For use Youtube & Vimeo video In pixel like 900px', 'pofo-addons' ),
      'dependency'  => array( 'element' => 'enable_responsive_video', 'value' => array('0') ),
      'group'       => esc_html__('Responsive', 'pofo-addons'),
      'edit_field_class' => 'vc_col-sm-6',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => esc_html__('Max width for mobile', 'pofo-addons' ),
      'param_name'  => 'pofo_max_width_mobile',
      'description' => esc_html__( 'For use Youtube & Vimeo video In pixel like 900px', 'pofo-addons' ),
      'dependency'  => array( 'element' => 'enable_responsive_video', 'value' => array('0') ),
      'group'       => esc_html__('Responsive', 'pofo-addons'),
      'edit_field_class' => 'vc_col-sm-6',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => esc_html__('Width for desktop', 'pofo-addons' ),            
      'param_name'  => 'pofo_video_width_desktop',
      'description' => esc_html__( 'For use only html video In pixel like 100%', 'pofo-addons' ),
      'dependency'  => array( 'element' => 'enable_responsive_video', 'value' => array('0') ),
      'group'       => esc_html__('Responsive', 'pofo-addons'),
      'edit_field_class' => 'vc_col-sm-6',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => esc_html__('Width for mini desktop', 'pofo-addons' ),            
      'param_name'  => 'pofo_video_width_mini_desktop',
      'description' => esc_html__( 'For use only html video In pixel like 100%', 'pofo-addons' ),
      'dependency'  => array( 'element' => 'enable_responsive_video', 'value' => array('0') ),
      'group'       => esc_html__('Responsive', 'pofo-addons'),
      'edit_field_class' => 'vc_col-sm-6',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => esc_html__('Width for tablet', 'pofo-addons' ),            
      'param_name'  => 'pofo_video_width_tablet',
      'description' => esc_html__( 'For use only html video In pixel like 100%', 'pofo-addons' ),
      'dependency'  => array( 'element' => 'enable_responsive_video', 'value' => array('0') ),
      'group'       => esc_html__('Responsive', 'pofo-addons'),
      'edit_field_class' => 'vc_col-sm-6',
    ),
    array(
      'type'        => 'textfield',
      'heading'     => esc_html__('Width for mobile', 'pofo-addons' ),            
      'param_name'  => 'pofo_video_width_mobile',
      'description' => esc_html__( 'For use only html video In pixel like 100%', 'pofo-addons' ),
      'dependency'  => array( 'element' => 'enable_responsive_video', 'value' => array('0') ),
      'group'       => esc_html__('Responsive', 'pofo-addons'),
      'edit_field_class' => 'vc_col-sm-6',
    ),
    array(
      'type' => 'dropdown',
      'heading' => esc_html__('SM Width', 'pofo-addons' ),
      'param_name' => 'pofo_width',
      'value' => $pofo_vc_column,
      'group' => 'Responsive Options',
      'description' => 'Select column width',
      'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('popup-form-1','modal-popup')),
    ),
      array(
        'type' => 'column_offset',
        'heading' => esc_html__('Responsiveness', 'pofo-addons' ),
        'param_name' => 'pofo_offset',
        'group' => 'Responsive Options',
        'description' => 'Adjust column for different screen sizes. Control width, offset and visibility settings.',
        'dependency'  => array( 'element' => 'pofo_popup_type', 'value' => array('popup-form-1','modal-popup')),
      ),
      $pofo_vc_extra_id,
      $pofo_vc_extra_class,
  )
) );
