<?php
/**
 * Shortcode Map For Portfolio
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Portfolio */
/*-----------------------------------------------------------------------------------*/

  $portfolio_class = 'pofo_portfolio_'.time() . '-2-' . rand( 0, 100 );
  vc_map( array(
    'name' => esc_html__( 'Portfolio', 'pofo-addons'),
    'description' => esc_html__( 'Place portfolio items list', 'pofo-addons' ),
    'icon' => 'fas fa-briefcase pofo-shortcode-icon',
    'base' => 'pofo_portfolio',
    'category' => 'Pofo',
    'params' => array(
        array(
          'type' => 'hidden',
          'heading' => esc_html__( 'Text', 'pofo-addons' ),
          'param_name' => 'pofo_token_class',
          'value' => $portfolio_class,
        ),
        array(
          'type' => 'dropdown',
          'holder' => 'div',
          'class' => '',
          'heading' => esc_html__( 'Style', 'pofo-addons'),
          'param_name' => 'pofo_portfolio_style',
          'value' => array(esc_html__( 'Select portfolio style', 'pofo-addons')           => '',
                           esc_html__( 'Portfolio overlay style 1', 'pofo-addons')        => 'portfolio-style-1',
                           esc_html__( 'Portfolio overlay style 2', 'pofo-addons')        => 'portfolio-style-2',
                           esc_html__( 'Portfolio overlay style 3', 'pofo-addons')        => 'portfolio-style-11',
                           esc_html__( 'Portfolio image gallery', 'pofo-addons')          => 'portfolio-style-3',
                           esc_html__( 'Portfolio full overlay', 'pofo-addons')           => 'portfolio-style-4',
                           esc_html__( 'Portfolio inner overlay', 'pofo-addons')          => 'portfolio-style-5',
                           esc_html__( 'Portfolio overlay with icon', 'pofo-addons')      => 'portfolio-style-6',
                           esc_html__( 'Portfolio transform', 'pofo-addons')              => 'portfolio-style-7',
                           esc_html__( 'Portfolio zooming', 'pofo-addons')                => 'portfolio-style-8',
                           esc_html__( 'Portfolio justified gallery', 'pofo-addons')      => 'portfolio-style-9',
                           esc_html__( 'Portfolio fancy overlay with icon', 'pofo-addons')=> 'portfolio-style-10',
          ),
        ),
        array(
          'type' => 'pofo_preview_image',
          'heading' => esc_html__( 'Select pre-made style', 'pofo-addons'),
          'param_name' => 'slider_portfolio_preview_image',
          'admin_label' => true,
          'value' => array(esc_html__( 'Select portfolio image', 'pofo-addons')           => '',
                           esc_html__( 'Portfolio overlay style 1', 'pofo-addons')        => 'portfolio-style-1',
                           esc_html__( 'Portfolio overlay style 2', 'pofo-addons')        => 'portfolio-style-2',
                           esc_html__( 'Portfolio overlay style 3', 'pofo-addons')        => 'portfolio-style-11',
                           esc_html__( 'Portfolio image gallery', 'pofo-addons')          => 'portfolio-style-3',
                           esc_html__( 'Portfolio full overlay', 'pofo-addons')           => 'portfolio-style-4',
                           esc_html__( 'Portfolio inner overlay', 'pofo-addons')          => 'portfolio-style-5',
                           esc_html__( 'Portfolio overlay with icon', 'pofo-addons')      => 'portfolio-style-6',
                           esc_html__( 'Portfolio transform', 'pofo-addons')              => 'portfolio-style-7',
                           esc_html__( 'Portfolio zooming', 'pofo-addons')                => 'portfolio-style-8',
                           esc_html__( 'Portfolio justified gallery', 'pofo-addons')      => 'portfolio-style-9',
                           esc_html__( 'Portfolio fancy overlay with icon', 'pofo-addons')=> 'portfolio-style-10',
          ),
        ),
        array(
          'type' => 'dropdown',
          'holder' => 'div',
          'class' => '',
          'heading' => esc_html__( 'Column Type', 'pofo-addons'),
          'param_name' => 'pofo_portfolio_columns',
          'value' => array(esc_html__( 'No. of columns', 'pofo-addons') => '',
                           esc_html__( '2 Columns', 'pofo-addons') => '2',
                           esc_html__( '3 Columns', 'pofo-addons') => '3',
                           esc_html__( '4 Columns', 'pofo-addons') => '4',
                           esc_html__( '5 Columns', 'pofo-addons') => '5',
                           esc_html__( '6 Columns', 'pofo-addons') => '6',
          ),
          'std' => '4',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-10', 'portfolio-style-11') ),
        ),
        array(
          'type' => 'dropdown',
          'holder' => 'div',
          'class' => '',
          'heading' => esc_html__( 'Spacing between columns', 'pofo-addons'),
          'param_name' => 'pofo_portfolio_type',
          'value' => array(esc_html__( 'Select spacing between columns', 'pofo-addons') => '',
                           esc_html__( 'Gutter very small', 'pofo-addons') => 'gutter-very-small',
                           esc_html__( 'Gutter small', 'pofo-addons') => 'gutter-small',
                           esc_html__( 'Gutter medium', 'pofo-addons') => 'gutter-medium',
                           esc_html__( 'Gutter large', 'pofo-addons') => 'gutter-large',
                           esc_html__( 'Gutter extra large', 'pofo-addons') => 'gutter-extra-large',
          ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-10', 'portfolio-style-11') ),
        ),
        array(
          'type' => 'textfield',
          'holder' => 'div',
          'class' => '',
          'heading' => esc_html__( 'Select spacing between columns', 'pofo-addons'),
          'param_name' => 'pofo_justified_portfolio_gap',
          'value' => '',
          'std' => '10',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-9') ),
        ),
        array(
          'type' => 'textfield',
          'holder' => 'div',
          'class' => '',
          'heading' => esc_html__( 'Height', 'pofo-addons'),
          'param_name' => 'pofo_justified_portfolio_height',
          'value' => '',
          'std' => '400',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-9') ),
        ),
        array(
          'type' => 'dropdown',
          'holder' => 'div',
          'class' => '',
          'heading' => esc_html__( 'Last row', 'pofo-addons'),
          'param_name' => 'pofo_justified_last_row',
          'value' => array(esc_html__( 'Select Last row', 'pofo-addons') => '',
                           esc_html__( 'No Justify', 'pofo-addons') => 'nojustify',
                           esc_html__( 'Justify', 'pofo-addons') => 'justify',
                           esc_html__( 'Hide', 'pofo-addons') => 'hide',
          ),
          'std' => 'nojustify',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-9') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Metro portfolio', 'pofo-addons'),
          'param_name' => 'pofo_show_portfolio_metro',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-10', 'portfolio-style-11') ),
        ),
        array(
            'type' => 'textfield',
            'class' => '',
            'heading' => esc_html__( 'Metro grid positions', 'pofo-addons'),
            'param_name' => 'pofo_portfolio_double_grid_position',
            'description' => esc_html__( 'Mention the positions (comma separated like 1, 6, 7) where that image will cover spacing of multiple columns and / or rows considering the image width and height.', 'pofo-addons' ),
            'dependency' => array( 'element' => 'pofo_show_portfolio_metro', 'value' => array('1') ),
        ),
      array(
            'type' => 'dropdown',
            'admin_label' => true,
            'class' => '',
            'heading' => __('Type of Selection', 'pofo-addons'),
            'param_name' => 'pofo_portfolio_selection',
            'value' => array(__('Category', 'pofo-addons') => 'portfolio-category',
                             __('Tags', 'pofo-addons') => 'portfolio-tags',
            ),
            'std' => 'portfolio-category',
            'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-9','portfolio-style-10', 'portfolio-style-11') ),
      ),
        array(
            'type' => 'pofo_multiple_portfolio_categories',
            'heading' => esc_html__( 'Select Categories', 'pofo-addons'),
            'param_name' => 'pofo_categories_list',
            'description' => esc_html__( 'Select same categories as selected in Portfolio Filter shortcode if it is used.', 'pofo-addons' ),
            'dependency' => array( 'element' => 'pofo_portfolio_selection', 'value' => array('portfolio-category') ),
        ),
        array(
            'type' => 'pofo_multiple_portfolio_tags',
            'heading' => __('Select Tags', 'pofo-addons'),
            'param_name' => 'pofo_tags_list',
            'dependency' => array( 'element' => 'pofo_portfolio_selection', 'value' => array('portfolio-tags') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Posts order by', 'pofo-addons' ),
          'param_name' => 'pofo_orderby',
          'value' => array(esc_html__( 'Select order by', 'pofo-addons') => '',
                           esc_html__( 'Date', 'pofo-addons' ) => 'date',
                           esc_html__( 'ID', 'pofo-addons' ) => 'ID',
                           esc_html__( 'Author', 'pofo-addons' ) => 'author',
                           esc_html__( 'Title', 'pofo-addons' ) => 'title',
                           esc_html__( 'Modified', 'pofo-addons' ) => 'modified',
                           esc_html__( 'Random', 'pofo-addons' ) => 'rand',
                           esc_html__( 'Comment count', 'pofo-addons' ) => 'comment_count',
                           esc_html__( 'Menu order', 'pofo-addons' ) => 'menu_order',
                          ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-9','portfolio-style-10', 'portfolio-style-11') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Posts sort by', 'pofo-addons' ),
          'param_name' => 'pofo_order',
          'value' => array(esc_html__( 'Select sort by', 'pofo-addons') => '',
                           esc_html__( 'Descending', 'pofo-addons' ) => 'DESC',
                           esc_html__( 'Ascending', 'pofo-addons' ) => 'ASC',
                          ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-9','portfolio-style-10', 'portfolio-style-11') ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'No. of posts per page', 'pofo-addons'),
          'param_name' => 'pofo_post_per_page',
          'value'     => '15',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-9','portfolio-style-10', 'portfolio-style-11') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Pagination', 'pofo-addons'),
          'param_name' => 'pofo_show_pagination',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'description' => esc_html__( 'If portfolio filter is used then pagination will work in ALL filter mode only.', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-9','portfolio-style-10', 'portfolio-style-11') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Pagination style', 'pofo-addons' ),
          'param_name' => 'pofo_pagination_style',
          'value' => array(esc_html__( 'Select pagination style', 'pofo-addons') => '',
                           esc_html__( 'Number', 'pofo-addons') => 'number-pagination',
                           esc_html__( 'Infinite scroll', 'pofo-addons') => 'infinite-scroll-pagination',
                          ),
          'std' => 'number-pagination',
          'dependency' => array( 'element' => 'pofo_show_pagination', 'value' => array('1') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Enable Link', 'pofo-addons'),
          'param_name' => 'pofo_enable_link',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-4','portfolio-style-5','portfolio-style-7','portfolio-style-8','portfolio-style-9', 'portfolio-style-11') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Title', 'pofo-addons'),
          'param_name' => 'pofo_show_title',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-9','portfolio-style-10', 'portfolio-style-11') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Title text case', 'pofo-addons'),
          'param_name' => 'pofo_title_text_transform',
          'value' => array(  esc_html__('Select', 'pofo-addons') => '', 
                             esc_html__('Lowercase', 'pofo-addons') => 'text-lowercase',
                             esc_html__('Uppercase', 'pofo-addons') => 'text-uppercase',
                             esc_html__('Capitalize', 'pofo-addons') => 'text-capitalize',
                             esc_html__( 'None', 'pofo-addons' ) => 'text-none',
                            ),
          'std' => 'text-uppercase',
          'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Subtitle', 'pofo-addons'),
          'param_name' => 'pofo_show_category',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-9','portfolio-style-10') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Subtitle type', 'pofo-addons'),
          'param_name' => 'pofo_subtitle_type',
          'value' => array(  esc_html__( 'Subtitle', 'pofo-addons' ) => '', 
                             esc_html__( 'Category', 'pofo-addons' ) => 'category',
                            ),
          'std' => '',
          'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Subtitle text case', 'pofo-addons'),
          'param_name' => 'pofo_category_text_transform',
          'value' => array(  esc_html__('Select', 'pofo-addons') => '', 
                             esc_html__('Lowercase', 'pofo-addons') => 'text-lowercase',
                             esc_html__('Uppercase', 'pofo-addons') => 'text-uppercase',
                             esc_html__('Capitalize', 'pofo-addons') => 'text-capitalize',
                             esc_html__( 'None', 'pofo-addons' ) => 'text-none',
                            ),
          'std' => 'text-uppercase',
          'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Separator', 'pofo-addons'),
          'param_name' => 'pofo_show_separator',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-4','portfolio-style-5') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post link icon', 'pofo-addons'),
          'param_name' => 'pofo_show_internal_link',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-6','portfolio-style-10') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Lightbox gallery', 'pofo-addons'),
          'param_name' => 'pofo_show_lightbox',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-3','portfolio-style-6','portfolio-style-9','portfolio-style-10') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Zoom effect on hover', 'pofo-addons'),
          'param_name' => 'pofo_zoom_on_hover',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-5','portfolio-style-8','portfolio-style-10') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Opacity', 'pofo-addons'),
          'param_name' => 'pofo_overlay_opacity',
          'admin_label' => true,
          'value' => array( esc_html__( 'Select opacity','pofo-addons') => '',
                            esc_html__( 'No opacity','pofo-addons') => '0.0',
                            '0.1'  => '0.1',
                            '0.2'  => '0.2',
                            '0.3'  => '0.3',
                            '0.4'  => '0.4',
                            '0.5'  => '0.5',
                            '0.6'  => '0.6',
                            '0.7'  => '0.7',
                            '0.8'  => '0.8',
                            '0.9'  => '0.9',
                            '1.0'  => '1.0',
                          ),
          'std' => '',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-10','portfolio-style-11') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Post image plus icon', 'pofo-addons'),
          'param_name' => 'pofo_show_plus_icon',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-8') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Image thumbnail size', 'pofo-addons' ),
          'param_name' => 'pofo_image_srcset',
          'value' => pofo_get_thumbnail_image_sizes(),
          'std' => 'full',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-9','portfolio-style-10', 'portfolio-style-11') ),
        ),
        array(
          'type' => 'animation_style',
          'heading' => esc_html__( 'CSS animation', 'pofo-addons' ),
          'param_name' => 'pofo_animation_style',
          'value' => '',
          'settings' => array(
            'type' => array(
              'in',
              'other',
            ),
          ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-9','portfolio-style-10', 'portfolio-style-11') ),
          'description' => __( 'Select type of animation for element to be animated when it "enters" the browsers viewport (Note: works only in modern browsers).', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Animation delay', 'pofo-addons' ),
          'param_name' => 'pofo_animation_delay',
          'dependency' => array( 'element' => 'pofo_animation_style', 'value_not_equal_to' => array( 'none' ) ),
          'description' => esc_html__( 'Add animation delay in mls', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Separator thickness', 'pofo-addons' ),
          'param_name' => 'pofo_separator_height',
          'dependency' => array( 'element' => 'pofo_show_separator', 'value' => array('1') ),
          'description' => esc_html__( 'Define custom separator thickness in px like 2px', 'pofo-addons' ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Separator color', 'pofo-addons' ),
          'param_name' => 'pofo_separator_color',
          'dependency' => array( 'element' => 'pofo_show_separator', 'value' => array('1') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Box hover background color', 'pofo-addons' ),
          'param_name' => 'pofo_box_hover_bg_color',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-10', 'portfolio-style-11') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Box hover title color', 'pofo-addons' ),
          'param_name' => 'pofo_box_hover_title_color',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-11') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Icon color', 'pofo-addons' ),
          'param_name' => 'pofo_plus_icon_color',
          'dependency' => array( 'element' => 'pofo_show_plus_icon', 'value' => array('1') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Icon color', 'pofo-addons' ),
          'param_name' => 'pofo_icon_color',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-6','portfolio-style-10',) ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Icon hover color', 'pofo-addons' ),
          'param_name' => 'pofo_icon_hover_color',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-6','portfolio-style-10',) ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Icon background color', 'pofo-addons' ),
          'param_name' => 'pofo_icon_background_color',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-6','portfolio-style-10',) ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Icon background hover color', 'pofo-addons' ),
          'param_name' => 'pofo_icon_background_hover_color',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-6','portfolio-style-10',) ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Icon border color', 'pofo-addons' ),
          'param_name' => 'pofo_icon_border_color',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-6','portfolio-style-10',) ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Caption background color', 'pofo-addons' ),
          'param_name' => 'pofo_caption_bg_color',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-9') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'desktop_alignment',
          'heading' => esc_html__( 'Alignment in desktop', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Left align', 'pofo-addons') => 'text-left',
                           esc_html__( 'Right align', 'pofo-addons') => 'text-right',
                           esc_html__( 'Center align', 'pofo-addons') => 'text-center',
                          ),
          'std' => 'text-center',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-10') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'desktop_mini_alignment',
          'heading' => esc_html__( 'Alignment in mini desktop', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Left align', 'pofo-addons') => 'md-text-left',
                           esc_html__( 'Right align', 'pofo-addons') => 'md-text-right',
                           esc_html__( 'Center align', 'pofo-addons') => 'md-text-center',
                          ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-10') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'ipad_alignment',
          'heading' => esc_html__( 'Alignment in tablet', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Left align', 'pofo-addons') => 'sm-text-left',
                           esc_html__( 'Right align', 'pofo-addons') => 'sm-text-right',
                           esc_html__( 'Center align', 'pofo-addons') => 'sm-text-center',
                          ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-10') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'mobile_alignment',
          'heading' => esc_html__( 'Alignment in mobile', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Left align', 'pofo-addons') => 'xs-text-left',
                           esc_html__( 'Right align', 'pofo-addons') => 'xs-text-right',
                           esc_html__( 'Center align', 'pofo-addons') => 'xs-text-center',
                          ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-7','portfolio-style-8','portfolio-style-10') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'vertical_desktop_alignment',
          'heading' => esc_html__( 'Vertical alignment in desktop', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Top align', 'pofo-addons') => 'vertical-align-top',
                           esc_html__( 'Middle align', 'pofo-addons') => 'vertical-align-middle',
                           esc_html__( 'Bottom align', 'pofo-addons') => 'vertical-align-bottom',
                          ),
          'std' => 'vertical-align-middle',
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-8','portfolio-style-10') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'vertical_desktop_mini_alignment',
          'heading' => esc_html__( 'Vertical alignment in mini desktop', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Top align', 'pofo-addons') => 'md-vertical-align-top',
                           esc_html__( 'Middle align', 'pofo-addons') => 'md-vertical-align-middle',
                           esc_html__( 'Bottom align', 'pofo-addons') => 'md-vertical-align-bottom',
                          ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-8','portfolio-style-10') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'vertical_ipad_alignment',
          'heading' => esc_html__( 'Vertical alignment in tablet', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Top align', 'pofo-addons') => 'sm-vertical-align-top',
                           esc_html__( 'Middle align', 'pofo-addons') => 'sm-vertical-align-middle',
                           esc_html__( 'Bottom align', 'pofo-addons') => 'sm-vertical-align-bottom',
                          ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-8','portfolio-style-10') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'vertical_mobile_alignment',
          'heading' => esc_html__( 'Vertical alignment in mobile', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Top align', 'pofo-addons') => 'xs-vertical-align-top',
                           esc_html__( 'Middle align', 'pofo-addons') => 'xs-vertical-align-middle',
                           esc_html__( 'Bottom align', 'pofo-addons') => 'xs-vertical-align-bottom',
                          ),
          'dependency' => array( 'element' => 'pofo_portfolio_style', 'value' => array('portfolio-style-1','portfolio-style-2','portfolio-style-3','portfolio-style-4','portfolio-style-5','portfolio-style-6','portfolio-style-8','portfolio-style-10') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        
        array(
          'type'        => 'pofo_custom_title', // this param type
          'param_name'  => 'pofo_custom_title_heading', // all params must have a unique name
          'value'       => esc_html__( 'Title typography', 'pofo-addons' ), // your custom markup
          'dependency'  => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
          'group'       => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Font size', 'pofo-addons' ),
          'param_name' => 'pofo_title_font_size',
          'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4 vc_column-with-padding',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Line height', 'pofo-addons' ),
          'param_name' => 'pofo_title_line_height',
          'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
          'param_name' => 'pofo_title_letter_spacing',
          'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'pofo_title_font_weight',
          'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
          'value' => pofo_font_weight_style(),
          'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Font italic', 'pofo-addons'),
          'param_name' => 'pofo_title_italic',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Font underline', 'pofo-addons'),
          'param_name' => 'pofo_title_underline',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Element tag', 'pofo-addons'),
          'param_name' => 'pofo_title_element_tag',
          'value' => array(esc_html__( 'Select tag', 'pofo-addons') => '',
                           esc_html__( 'h1', 'pofo-addons') => 'h1',
                           esc_html__( 'h2', 'pofo-addons') => 'h2',
                           esc_html__( 'h3', 'pofo-addons') => 'h3',
                           esc_html__( 'h4', 'pofo-addons') => 'h4',
                           esc_html__( 'h5', 'pofo-addons') => 'h5',
                           esc_html__( 'h6', 'pofo-addons') => 'h6',
                          ),
          'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Color', 'pofo-addons' ),
          'param_name' => 'pofo_title_color',
          'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
          'param_name' => 'pofo_title_enable_responsive_font',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type'        => 'pofo_custom_title', // this param type
          'param_name'  => 'pofo_custom_subtitle_heading', // all params must have a unique name
          'value'       => esc_html__( 'Subtitle typography', 'pofo-addons' ), // your custom markup
          'dependency'  => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
          'group'       => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Font size', 'pofo-addons' ),
          'param_name' => 'pofo_subtitle_font_size',
          'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4 vc_column-with-padding',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Line height', 'pofo-addons' ),
          'param_name' => 'pofo_subtitle_line_height',
          'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
          'param_name' => 'pofo_subtitle_letter_spacing',
          'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'pofo_subtitle_font_weight',
          'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
          'value' => pofo_font_weight_style(),
          'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Color', 'pofo-addons' ),
          'param_name' => 'pofo_subtitle_color',
          'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
          'param_name' => 'pofo_subtitle_enable_responsive_font',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
          'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
          'edit_field_class' => 'vc_col-sm-4',
          'group' => esc_html__( 'Typography', 'pofo-addons' ),
        ),
        $pofo_vc_extra_id,
        $pofo_vc_extra_class,
    )
  ) );
