<?php
/**
 * Shortcode Map For Portfolio Slider
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Portfolio Slider */
/*-----------------------------------------------------------------------------------*/

    vc_map( array(
        'name' => esc_html__( 'Portfolio Slider' , 'pofo-addons' ), //Name of your shortcode for human reading inside element list
        'base' => 'pofo_portfolio_slider', //Shortcode tag. For [my_shortcode] shortcode base is my_shortcode
        'description' => esc_html__( 'Place portfolio items list', 'pofo-addons' ), //Short description of your element, it will be visible in 'Add element' window
        'class' => '', //CSS class which will be added to the shortcode's content element in the page edit screen in Visual Composer backend edit mode
        'icon' => 'fas fa-arrows-alt-h pofo-shortcode-icon', //URL or CSS class with icon image.
        'category' => 'Pofo',
        'params' => array( //List of shortcode attributes. Array which holds your shortcode params, these params will be editable in shortcode settings page
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Style', 'pofo-addons'),
              'param_name' => 'pofo_slider_style',
              'admin_label' => true,
              'value' => array( esc_html__( 'Select style', 'pofo-addons') => '',
                                esc_html__( 'Style 1', 'pofo-addons') => 'portfolio-slider-style-1',
                                esc_html__( 'Style 2', 'pofo-addons') => 'portfolio-slider-style-2',
                                esc_html__( 'Style 3', 'pofo-addons') => 'portfolio-slider-style-3',
                                esc_html__( 'Style 4', 'pofo-addons') => 'portfolio-slider-style-4',
                                esc_html__( 'Style 5', 'pofo-addons') => 'portfolio-slider-style-5',
                                esc_html__( 'Style 6', 'pofo-addons') => 'portfolio-slider-style-6',
                              ),
            ),
            array(
              'type' => 'pofo_preview_image',
              'heading' => esc_html__( 'Select pre-made style for portfolio', 'pofo-addons'),
              'param_name' => 'pofo_portfolio_preview_image',
              'admin_label' => true,
              'value' => array( esc_html__( 'Select slider image', 'pofo-addons') => '',
                                esc_html__( 'Style 1', 'pofo-addons') => 'portfolio-slider-style-1',
                                esc_html__( 'Style 2', 'pofo-addons') => 'portfolio-slider-style-2',
                                esc_html__( 'Style 3', 'pofo-addons') => 'portfolio-slider-style-3',
                                esc_html__( 'Style 4', 'pofo-addons') => 'portfolio-slider-style-4',
                                esc_html__( 'Style 5', 'pofo-addons') => 'portfolio-slider-style-5',
                                esc_html__( 'Style 6', 'pofo-addons') => 'portfolio-slider-style-6',
                              ),
            ),
            array(
              'type' => 'textarea_html',
              'heading' => esc_html__( 'First slide content', 'pofo-addons' ),
              'param_name' => 'content',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-3') ),
            ),
            array(
              'type' => 'pofo_multiple_portfolio_categories',
              'heading' => esc_html__( 'Categories', 'pofo-addons'),
              'param_name' => 'pofo_categories_list',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-4','portfolio-slider-style-5','portfolio-slider-style-6') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Image thumbnail size', 'pofo-addons' ),
              'param_name' => 'pofo_image_srcset',
              'value' => pofo_get_thumbnail_image_sizes(),
              'std' => 'full',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-4','portfolio-slider-style-5','portfolio-slider-style-6') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Posts order by', 'pofo-addons' ),
              'param_name' => 'pofo_orderby',
              'value' => array(esc_html__( 'Select order by', 'pofo-addons') => '',
                               esc_html__( 'Date', 'pofo-addons' ) => 'date',
                               esc_html__( 'ID', 'pofo-addons' ) => 'ID',
                               esc_html__( 'Author', 'pofo-addons' ) => 'author',
                               esc_html__( 'Title', 'pofo-addons' ) => 'title',
                               esc_html__( 'Modified', 'pofo-addons' ) => 'modified',
                               esc_html__( 'Random', 'pofo-addons' ) => 'rand',
                               esc_html__( 'Comment count', 'pofo-addons' ) => 'comment_count',
                               esc_html__( 'Menu order', 'pofo-addons' ) => 'menu_order',
                              ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-4','portfolio-slider-style-5','portfolio-slider-style-6') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Posts sort by', 'pofo-addons' ),
              'param_name' => 'pofo_order',
              'value' => array(esc_html__( 'Select sort by', 'pofo-addons') => '',
                               esc_html__( 'Descending', 'pofo-addons' ) => 'DESC',
                               esc_html__( 'Ascending', 'pofo-addons' ) => 'ASC',
                              ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-4','portfolio-slider-style-5','portfolio-slider-style-6') ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'No. of posts to display', 'pofo-addons'),
              'param_name' => 'pofo_post_per_page',
              'value'     => '5',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-4','portfolio-slider-style-5','portfolio-slider-style-6') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Mousewheel Control', 'pofo-addons'),
              'param_name' => 'mousewheel_control',
              'value' => array(esc_html__( 'Default', 'pofo-addons') => '',
                               esc_html__( 'Off', 'pofo-addons') => 'off', 
                               esc_html__( 'On', 'pofo-addons') => 'on'
                              ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-4','portfolio-slider-style-5','portfolio-slider-style-6') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Pagination', 'pofo-addons'),
              'param_name' => 'show_pagination',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-4','portfolio-slider-style-5') ),
              'description' => esc_html__( 'Select ON to show pagination in slider', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Pagination style', 'pofo-addons'),
              'param_name' => 'show_pagination_style',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select pagination style', 'pofo-addons') => '',
                             esc_html__( 'Dot style', 'pofo-addons') => '0',
                             esc_html__( 'Line style', 'pofo-addons') => '1',
                            ),
              'dependency' => array( 'element' => 'show_pagination', 'value' => array('1') ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Pagination color style', 'pofo-addons'),
                'param_name' => 'show_pagination_color_style',
                'admin_label' => true,
                'value' => array(esc_html__( 'Select pagination color style', 'pofo-addons') => '',
                                 esc_html__( 'Dark style', 'pofo-addons') => '0',
                                 esc_html__( 'Light style', 'pofo-addons') => '1'
                                ),
                'std' => '1',
                'dependency' => array( 'element' => 'show_pagination', 'value' => array('1') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Navigation', 'pofo-addons'),
              'param_name' => 'show_navigation',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-6') ),
              'description' => esc_html__( 'Select ON to show navigation in slider', 'pofo-addons' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Navigation style', 'pofo-addons'),
                'param_name' => 'show_navigation_style',
                'admin_label' => true,
                'value' => array(esc_html__( 'Select navigation style', 'pofo-addons') => '',
                                 esc_html__( 'Next/Prev long arrow', 'pofo-addons') => '0',
                                 esc_html__( 'Next/Prev black arrow', 'pofo-addons') => '1',
                                 esc_html__( 'Next/Prev white arrow', 'pofo-addons') => '2'
                                ),
                'dependency' => array( 'element' => 'show_navigation', 'value' => array('1') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Scroll navigation', 'pofo-addons'),
              'param_name' => 'show_scroll_navigation',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-2','portfolio-slider-style-3') ),
              'description' => esc_html__( 'Select ON to show scroll navigation in slider', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Cursor color style', 'pofo-addons'),
              'param_name' => 'show_cursor_color_style',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select cursor color style', 'pofo-addons') => '',
                             esc_html__( 'White cursor', 'pofo-addons') => 'white-move',
                             esc_html__( 'Black cursor', 'pofo-addons') => 'black-move',
                             esc_html__( 'Default cursor', 'pofo-addons') => 'no-move',
                            ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-5') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Separator', 'pofo-addons'),
              'param_name' => 'pofo_show_separator',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-3','portfolio-slider-style-5') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Enable Link', 'pofo-addons'),
              'param_name' => 'pofo_enable_link',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-5') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Link On', 'pofo-addons'),
              'param_name' => 'pofo_link_on',
              'admin_label' => true,
              'value' => array(esc_html__( 'Title', 'pofo-addons') => '',
                             esc_html__( 'Box', 'pofo-addons') => 'box',
                            ),
              'dependency' => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Title', 'pofo-addons'),
              'param_name' => 'pofo_show_title',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-4','portfolio-slider-style-5','portfolio-slider-style-6') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Post excerpt', 'pofo-addons'),
              'param_name' => 'pofo_show_excerpt',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std'         => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-5') ),
            ),
            array(
              'type'        => 'textfield',
              'heading'     => esc_html__( 'Excerpt length', 'pofo-addons' ),
              'param_name'  => 'pofo_excerpt_length',
              'value'     => '15',
              'dependency'  => array( 'element' => 'pofo_show_excerpt', 'value' => array('1') ),
              'description' => esc_html__( 'Words length', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Post full content', 'pofo-addons'),
              'param_name' => 'pofo_show_content',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std'         => '1',
              'dependency'  => array( 'element' => 'pofo_show_excerpt', 'value' => array('0') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Subtitle', 'pofo-addons'),
              'param_name' => 'pofo_show_category',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-4','portfolio-slider-style-6') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Subtitle strikethrough', 'pofo-addons'),
              'param_name' => 'pofo_subtitle_strikethrough',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Button', 'pofo-addons'),
              'param_name' => 'pofo_show_button',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1') ),
            ),
            array(
              'type'        => 'textfield',
              'heading'     => esc_html__( 'Button Text', 'pofo-addons' ),
              'param_name'  => 'pofo_button_text',
              'dependency'  => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Height in desktop', 'pofo-addons'),
              'param_name' => 'pofo_lg_min_height',
              'value' => '',
              'description' => esc_html__( 'In pixel like 400px', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1', 'portfolio-slider-style-2', 'portfolio-slider-style-3', 'portfolio-slider-style-4', 'portfolio-slider-style-5') ),
              'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Height in mini desktop', 'pofo-addons'),
              'param_name' => 'pofo_md_min_height',
              'value' => '',
              'description' => esc_html__( 'In pixel like 400px', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1', 'portfolio-slider-style-2', 'portfolio-slider-style-3', 'portfolio-slider-style-4', 'portfolio-slider-style-5') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Height in tablet', 'pofo-addons'),
              'param_name' => 'pofo_sm_min_height',
              'value' => '',
              'description' => esc_html__( 'In pixel like 400px', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1', 'portfolio-slider-style-2', 'portfolio-slider-style-3', 'portfolio-slider-style-4', 'portfolio-slider-style-5') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Height in mobile', 'pofo-addons'),
              'param_name' => 'pofo_xs_min_height',
              'value' => '',
              'description' => esc_html__( 'In pixel like 400px', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1', 'portfolio-slider-style-2', 'portfolio-slider-style-4', 'portfolio-slider-style-5') ),
              'edit_field_class' => 'vc_col-sm-6',
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button background color', 'pofo-addons' ),
              'param_name' => 'pofo_button_color',
              'dependency' => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button text color', 'pofo-addons' ),
              'param_name' => 'pofo_button_text_color',
              'dependency' => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button hover background color', 'pofo-addons' ),
              'param_name' => 'pofo_button_hover_color',
              'dependency' => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button hover text color', 'pofo-addons' ),
              'param_name' => 'pofo_button_hover_text_color',
              'dependency' => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Button border color', 'pofo-addons' ),
              'param_name' => 'pofo_button_border_color',
              'dependency' => array( 'element' => 'pofo_show_button', 'value' => array('1') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Scroll progress line color', 'pofo-addons' ),
              'param_name' => 'pofo_scroll_progress_line_color',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-2', 'portfolio-slider-style-3') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Scroll progress point color', 'pofo-addons' ),
              'param_name' => 'pofo_scroll_progress_point_color',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-2', 'portfolio-slider-style-3') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Scroll navigation color', 'pofo-addons' ),
              'param_name' => 'pofo_scroll_navigation_color',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-2') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Scroll navigation icon color', 'pofo-addons' ),
              'param_name' => 'pofo_scroll_navigation_icon_color',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-2') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Separator thickness', 'pofo-addons' ),
              'param_name' => 'pofo_separator_height',
              'dependency' => array( 'element' => 'pofo_show_separator', 'value' => array('1') ),
              'description' => esc_html__( 'In pixel like 1px', 'pofo-addons' ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Separator color', 'pofo-addons' ),
              'param_name' => 'pofo_separator_color',
              'dependency' => array( 'element' => 'pofo_show_separator', 'value' => array('1') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Content background color', 'pofo-addons' ),
              'param_name' => 'pofo_content_bg_color',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-4','portfolio-slider-style-6') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Subtitle hover color', 'pofo-addons' ),
              'param_name' => 'pofo_subtitle_hover_color',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-4') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'attach_image',
              'heading' => esc_html__( 'Link image', 'pofo-addons'),
              'param_name' => 'pofo_link_image',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-4') ),
              'group' => esc_html__( 'Style', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in desktop', 'pofo-addons'),
              'param_name' => 'slides_per_view_desktop',
              'value' => array(esc_html__( 'Select Slide Per View', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '4',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-5','portfolio-slider-style-6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in mini desktop', 'pofo-addons'),
              'param_name' => 'slides_per_view_mini_desktop',
              'value' => array(esc_html__( 'Select Slide Per View', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '3',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-5','portfolio-slider-style-6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in tablet', 'pofo-addons'),
              'param_name' => 'slides_per_view_tablet',
              'value' => array(esc_html__( 'Select Slide Per View', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '2',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-5','portfolio-slider-style-6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in mobile', 'pofo-addons'),
              'param_name' => 'slides_per_view_mobile',
              'value' => array(esc_html__( 'Select Slide Per View', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-5','portfolio-slider-style-6') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Transition Style', 'pofo-addons'),
                'param_name' => 'slider_transition_style',
                'admin_label' => true,
                'value' => array(
                    esc_html__( 'Select Transition Style', 'pofo-addons') => '',
                    esc_html__( 'Slide Style', 'pofo-addons') => 'slide',
                    esc_html__( 'Fade Style', 'pofo-addons') => 'fade',
                    esc_html__( 'Cube Style', 'pofo-addons') => 'cube',
                    esc_html__( 'Coverflow Style', 'pofo-addons') => 'coverflow',
                    esc_html__( 'Flip Style', 'pofo-addons') => 'flip',
                ),
                'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array( 'portfolio-slider-style-1', 'portfolio-slider-style-4' ) ),
                'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Transition speed', 'pofo-addons'),
              'param_name' => 'slidespeed',
              'admin_label' => true,
              'value' => '',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-4','portfolio-slider-style-5','portfolio-slider-style-6') ),
              'description' => esc_html__( 'Enter slide speed time like 500, where 1000 = 1 second', 'pofo-addons'),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Auto play', 'pofo-addons'),
              'param_name' => 'autoplay',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-3','portfolio-slider-style-4','portfolio-slider-style-5','portfolio-slider-style-6') ),
              'description' => esc_html__( 'Select On to autoplay slider', 'pofo-addons' ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),            
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Delay time', 'pofo-addons'),
              'param_name' => 'slidedelay',
              'admin_label' => true,
              'value' => '',
              'std' => '3000',
              'description' => esc_html__( 'Enter delay time (before switching to other slide) like 500, where 1000 = 1 second', 'pofo-addons'),
              'dependency'  => array( 'element' => 'autoplay', 'value' => array('1') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Loop', 'pofo-addons'),
              'param_name' => 'autoloop',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('portfolio-slider-style-1','portfolio-slider-style-2','portfolio-slider-style-4','portfolio-slider-style-5','portfolio-slider-style-6') ),
              'description' => esc_html__( 'Select On to autoloop slider', 'pofo-addons' ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'param_name' => 'pofo_custom_title_heading', // all params must have a unique name
              'type' => 'pofo_custom_title', // this param type
              'value' => esc_html__( 'Title typography', 'pofo-addons' ), // your custom markup
              'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
              'responsive_settings' => true,
              'hide_show_element' => 'pofo_title_responsive_settings',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Font size', 'pofo-addons' ),
              'param_name' => 'pofo_title_font_size',
              'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4 vc_column-with-padding',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Line height', 'pofo-addons' ),
              'param_name' => 'pofo_title_line_height',
              'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
              'param_name' => 'pofo_title_letter_spacing',
              'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'pofo_title_font_weight',
              'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
              'value' => pofo_font_weight_style(),
              'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Font italic', 'pofo-addons'),
              'param_name' => 'pofo_title_italic',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Font underline', 'pofo-addons'),
              'param_name' => 'pofo_title_underline',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Element tag', 'pofo-addons'),
              'param_name' => 'pofo_title_element_tag',
              'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                               esc_html__( 'h1', 'pofo-addons') => 'h1',
                               esc_html__( 'h2', 'pofo-addons') => 'h2',
                               esc_html__( 'h3', 'pofo-addons') => 'h3',
                               esc_html__( 'h4', 'pofo-addons') => 'h4',
                               esc_html__( 'h5', 'pofo-addons') => 'h5',
                               esc_html__( 'h6', 'pofo-addons') => 'h6',
                              ),
              'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Color', 'pofo-addons' ),
              'param_name' => 'pofo_title_color',
              'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
              'param_name' => 'pofo_title_enable_responsive_font',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_show_title', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
            'type' => 'responsive_font_settings',
            'param_name' => 'pofo_title_responsive_settings',
            'group' => esc_html__( 'Typography', 'pofo-addons' ),
            'hide_element_keys' => array( 'text-align', 'font-transform', ),
          ),
            array(
              'param_name' => 'pofo_custom_subtitle_heading', // all params must have a unique name
              'type' => 'pofo_custom_title', // this param type
              'value' => esc_html__( 'Subtitle typography', 'pofo-addons' ), // your custom markup
              'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
              'responsive_settings' => true,
              'hide_show_element' => 'pofo_subtitle_responsive_settings',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Font size', 'pofo-addons' ),
              'param_name' => 'pofo_subtitle_font_size',
              'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4 vc_column-with-padding',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Line height', 'pofo-addons' ),
              'param_name' => 'pofo_subtitle_line_height',
              'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
              'param_name' => 'pofo_subtitle_letter_spacing',
              'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'pofo_subtitle_font_weight',
              'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
              'value' => pofo_font_weight_style(),
              'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Color', 'pofo-addons' ),
              'param_name' => 'pofo_subtitle_color',
              'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
              'param_name' => 'pofo_subtitle_enable_responsive_font',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_show_category', 'value' => array('1') ),
              'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'responsive_font_settings',
              'param_name' => 'pofo_subtitle_responsive_settings',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
              'hide_element_keys' => array( 'text-align', 'font-transform', ),
            ),
            array(
              'type'        => 'textfield',
              'heading'     => esc_html__( 'Element ID', 'pofo-addons' ),
              'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %s).', 'pofo-addons'), '<a target="_blank" href="https://www.w3schools.com/tags/att_global_id.asp">w3c specification</a>'),
              'param_name'  => 'pofo_slider_id',
              'group'       => esc_html__( 'Extras', 'pofo-addons' )
            ),
            array(
              'type'        => 'textfield',
              'heading'     => esc_html__( 'Extra class name', 'pofo-addons' ),
              'description' => esc_html__( 'Add additional CSS class to this element, you can define multiple CSS class with use of space like "Class1 Class2". You can write css code using this class and add it in customizer or your child theme css file.', 'pofo-addons' ),
              'param_name'  => 'pofo_slider_class',
              'group'       => esc_html__( 'Extras', 'pofo-addons' )
            ),
        ),
    )
  );
