<?php
/**
 * Shortcode Map For Pricing Table 
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Pofo Pricing Table  */
/*-----------------------------------------------------------------------------------*/

  vc_map( 
    array(
    'name' => esc_html__( 'Pricing Table', 'pofo-addons'),
    'base' => 'pofo_pricing_table',
    'category' => 'Pofo',
    'description' => esc_html__( 'Place a pricing table', 'pofo-addons' ),
    'icon' => 'far fa-money-bill-alt pofo-shortcode-icon', //URL or CSS class with icon image.
    'params' => array(
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Style', 'pofo-addons'),
        'param_name' => 'pofo_pricing_style',
        'admin_label' => true,
        'value' => array( esc_html__( 'Select style', 'pofo-addons') => '',
                          esc_html__( 'Pricing style 1', 'pofo-addons') => 'pricing-style-1',
                          esc_html__( 'Pricing style 2', 'pofo-addons') => 'pricing-style-2',
                        ),
      ),
      array(
        'type' => 'pofo_preview_image',
        'heading' => esc_html__( 'Select pre-made style for pricing', 'pofo-addons'),
        'param_name' => 'pofo_pricing_preview_image',
        'admin_label' => true,
        'value' => array( esc_html__( 'Pricing image', 'pofo-addons') => '',
                          esc_html__( 'Pricing style 1', 'pofo-addons') => 'pricing-style-1',
                          esc_html__( 'Pricing style 2', 'pofo-addons') => 'pricing-style-2',
                        ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Highlighting style', 'pofo-addons'),
        'param_name' => 'pofo_highlight_table',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-2' ) ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Custom icon image', 'pofo-addons'),
        'param_name' => 'custom_icon',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1' ) ),
      ),
      array(
        'type' => 'attach_image',
        'heading' => esc_html__( 'Custom image', 'pofo-addons'),
        'param_name' => 'custom_icon_image',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
        'description' => esc_html__( 'Recommended size: Extra Large - 60px X 60px, Large - 50px X 50px, Extra Medium - 40px X 40px, Medium - 35px X 35px, Small - 24px X 24px, Extra Small - 16px X 16px', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Maximum width', 'pofo-addons' ),
        'param_name' => 'custom_icon_max_height',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
        'description' => esc_html__( 'In pixel like 40px.', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_icon',
        'heading' => esc_html__( 'Font icon', 'pofo-addons'),
        'param_name' => 'pricing_table_icon',
        'admin_label' => true,
        'value' => '',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Title', 'pofo-addons'),
        'param_name' => 'sale_type',
        'admin_label' => true,
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Price', 'pofo-addons'),
        'param_name' => 'price',
        'admin_label' => true,
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Duration', 'pofo-addons'),
        'param_name' => 'per_price',
        'admin_label' => true,
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
      ),
      array(
        'type' => 'textarea_html',
        'heading' => esc_html__( 'Features content', 'pofo-addons'),
        'param_name' => 'content',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
      ),
      array(
        'type'        => 'vc_link',
        'heading'     => esc_html__('Button configuration', 'pofo-addons' ),
        'param_name'  => 'pofo_button_config',
        'admin_label' => true,
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__('Button one page navigation', 'pofo-addons'),
        'param_name' => 'pofo_button_one_page',
        'value' => array(esc_html__('Off', 'pofo-addons') => '0',
                         esc_html__('On', 'pofo-addons') => '1'
                        ),
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Border', 'pofo-addons'),
        'param_name' => 'pofo_enable_border',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'std' => '1',
        'description' => esc_html__( 'Select On to show Border', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Icon background color', 'pofo-addons' ),
        'param_name' => 'pofo_icon_bg_color',
        'edit_field_class' => 'vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1' ) ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Title background color', 'pofo-addons' ),
        'param_name' => 'pofo_sale_type_bg_color',
        'edit_field_class' => 'vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-2' ) ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Title text case', 'pofo-addons'),
        'param_name' => 'pofo_title_text_transform',
        'value' => array(  esc_html__('Select', 'pofo-addons') => '', 
                           esc_html__('Lowercase', 'pofo-addons') => 'text-lowercase',
                           esc_html__('Uppercase', 'pofo-addons') => 'text-uppercase',
                           esc_html__('Capitalize', 'pofo-addons') => 'text-capitalize',
                           esc_html__( 'None', 'pofo-addons' ) => 'text-none',
                          ),
        'std' => 'text-uppercase',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Duration text case', 'pofo-addons'),
        'param_name' => 'pofo_per_price_text_transform',
        'value' => array(  esc_html__('Select', 'pofo-addons') => '', 
                           esc_html__('Lowercase', 'pofo-addons') => 'text-lowercase',
                           esc_html__('Uppercase', 'pofo-addons') => 'text-uppercase',
                           esc_html__('Capitalize', 'pofo-addons') => 'text-capitalize',
                           esc_html__( 'None', 'pofo-addons' ) => 'text-none',
                          ),
        'std' => 'text-uppercase',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Top box background color', 'pofo-addons' ),
        'param_name' => 'pofo_top_box_background_color',
        'value' => '',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Bottom box background color', 'pofo-addons' ),
        'param_name' => 'pofo_bottom_box_background_color',
        'value' => '',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Icon size', 'pofo-addons'),
        'param_name' => 'pofo_pricing_table_icon_size',
        'admin_label' => true,
        'value' => array( esc_html__( 'Default','pofo-addons') => '',
                          esc_html__( 'Extra large','pofo-addons') => 'icon-extra-large', 
                          esc_html__( 'Large','pofo-addons') => 'icon-large',
                          esc_html__( 'Extra medium','pofo-addons') => 'icon-extra-medium',
                          esc_html__( 'Medium','pofo-addons') => 'icon-medium',
                          esc_html__( 'Small','pofo-addons') => 'icon-small',
                          esc_html__( 'Extra small','pofo-addons') => 'icon-extra-small',
                        ),
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Icon color', 'pofo-addons' ),
        'param_name' => 'pofo_icon_color',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_border_type',
        'heading' => esc_html__( 'Border type', 'pofo-addons' ),
        'value' => array(esc_html__( 'no border', 'pofo-addons') => '',
                         esc_html__( 'Dotted', 'pofo-addons') => 'dotted',
                         esc_html__( 'Dashed', 'pofo-addons') => 'dashed',
                         esc_html__( 'Solid', 'pofo-addons') => 'solid',
                         esc_html__( 'Double', 'pofo-addons') => 'double',
                        ),
        'std' => 'solid',
        'dependency' => array( 'element' => 'pofo_enable_border', 'value' => array('1') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Border size', 'pofo-addons' ),
        'param_name' => 'pofo_border_size',
        'dependency' => array( 'element' => 'pofo_enable_border', 'value' => array('1') ),
        'description' => esc_html__( 'In pixel like 2px', 'pofo-addons' ),
        'value' => '1px',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Border color', 'pofo-addons' ),
        'param_name' => 'pofo_border_color',
        'dependency' => array( 'element' => 'pofo_enable_border', 'value' => array('1') ),
        'value' => '#ededed',
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Border radius', 'pofo-addons' ),
        'param_name' => 'pofo_border_radius',
        'description' => esc_html__( 'In pixel like 2px', 'pofo-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button background color', 'pofo-addons' ),
        'param_name' => 'pofo_button_bg_color',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button text color', 'pofo-addons' ),
        'param_name' => 'pofo_button_text_color',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button hover background color', 'pofo-addons' ),
        'param_name' => 'pofo_button_hover_bg_color',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button hover text color', 'pofo-addons' ),
        'param_name' => 'pofo_button_hover_text_color',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Button border color', 'pofo-addons' ),
        'param_name' => 'pofo_button_border_color',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'param_name' => 'pofo_custom_title_heading', // all params must have a unique name
        'type' => 'pofo_custom_title', // this param type
        'value' => esc_html__( 'Title typography', 'pofo-addons' ), // your custom markup
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'responsive_settings' => true,
        'hide_show_element' => 'pofo_title_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Font size', 'pofo-addons' ),
        'param_name' => 'pofo_sale_type_font_size',
        'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4 vc_column-with-padding',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Line height', 'pofo-addons' ),
        'param_name' => 'pofo_sale_type_line_height',
        'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
        'param_name' => 'pofo_sale_type_letter_spacing',
        'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_sale_type_font_weight',
        'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
        'value' => pofo_font_weight_style(),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font italic', 'pofo-addons'),
        'param_name' => 'pofo_sale_type_italic',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font underline', 'pofo-addons'),
        'param_name' => 'pofo_sale_type_underline',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Color', 'pofo-addons' ),
        'param_name' => 'pofo_sale_type_color',
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
        'param_name' => 'pofo_sale_type_enable_responsive_font',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'responsive_font_settings',
        'param_name' => 'pofo_title_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
        'hide_element_keys' => array( 'text-align', 'font-transform', ),
      ),
      array(
        'param_name' => 'pofo_custom_price_heading', // all params must have a unique name
        'type' => 'pofo_custom_title', // this param type
        'value' => esc_html__( 'Price typography', 'pofo-addons' ), // your custom markup
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'responsive_settings' => true,
        'hide_show_element' => 'pofo_price_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Font size', 'pofo-addons' ),
        'param_name' => 'pofo_price_font_size',
        'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_price vc_col-sm-4 vc_column-with-padding',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Line height', 'pofo-addons' ),
        'param_name' => 'pofo_price_line_height',
        'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_price vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
        'param_name' => 'pofo_price_letter_spacing',
        'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_price vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_price_font_weight',
        'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
        'value' => pofo_font_weight_style(),
        'edit_field_class' => 'pofo_responsive_tab_price vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font italic', 'pofo-addons'),
        'param_name' => 'pofo_price_italic',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'edit_field_class' => 'pofo_responsive_tab_price vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font underline', 'pofo-addons'),
        'param_name' => 'pofo_price_underline',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'edit_field_class' => 'pofo_responsive_tab_price vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Element tag', 'pofo-addons'),
        'param_name' => 'pofo_price_element_tag',
        'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                         esc_html__( 'h1', 'pofo-addons') => 'h1',
                         esc_html__( 'h2', 'pofo-addons') => 'h2',
                         esc_html__( 'h3', 'pofo-addons') => 'h3',
                         esc_html__( 'h4', 'pofo-addons') => 'h4',
                         esc_html__( 'h5', 'pofo-addons') => 'h5',
                         esc_html__( 'h6', 'pofo-addons') => 'h6',
                        ),
        'edit_field_class' => 'pofo_responsive_tab_price vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Color', 'pofo-addons' ),
        'param_name' => 'pofo_price_color',
        'edit_field_class' => 'pofo_responsive_tab_price vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
        'param_name' => 'pofo_price_enable_responsive_font',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_price vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'responsive_font_settings',
        'param_name' => 'pofo_price_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
        'hide_element_keys' => array( 'text-align', 'font-transform', ),
      ),
      array(
        'param_name' => 'pofo_custom_duation_heading', // all params must have a unique name
        'type' => 'pofo_custom_title', // this param type
        'value' => esc_html__( 'Duration typography', 'pofo-addons' ), // your custom markup
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'responsive_settings' => true,
        'hide_show_element' => 'pofo_duration_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Font size', 'pofo-addons' ),
        'param_name' => 'pofo_per_price_font_size',
        'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_duration vc_col-sm-4 vc_column-with-padding',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Line height', 'pofo-addons' ),
        'param_name' => 'pofo_per_price_line_height',
        'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_duration vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
        'param_name' => 'pofo_per_price_letter_spacing',
        'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_duration vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'param_name' => 'pofo_per_price_font_weight',
        'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
        'value' => pofo_font_weight_style(),
        'edit_field_class' => 'pofo_responsive_tab_duration vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font italic', 'pofo-addons'),
        'param_name' => 'pofo_per_price_italic',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'edit_field_class' => 'pofo_responsive_tab_duration vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Font underline', 'pofo-addons'),
        'param_name' => 'pofo_per_price_underline',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'edit_field_class' => 'pofo_responsive_tab_duration vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Color', 'pofo-addons' ),
        'param_name' => 'pofo_per_price_color',
        'edit_field_class' => 'pofo_responsive_tab_duration vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'pofo_custom_switch_option',
        'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
        'param_name' => 'pofo_per_price_enable_responsive_font',
        'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                         esc_html__( 'On', 'pofo-addons') => '1'
                        ),
        'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
        'edit_field_class' => 'pofo_responsive_tab_duration vc_col-sm-4',
        'dependency' => array( 'element' => 'pofo_pricing_style', 'value' => array( 'pricing-style-1', 'pricing-style-2' ) ),
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
      ),
      array(
        'type' => 'responsive_font_settings',
        'param_name' => 'pofo_duration_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
        'hide_element_keys' => array( 'text-align', 'font-transform', ),
      ),
      $pofo_vc_extra_id,
      $pofo_vc_extra_class,
      ),
    ) 
  );
