<?php
/**
 * Map For Social
 *
 * @package Pofo
 */

vc_map( array(
  'icon' => 'pofo-shortcode-icon fas fa-stop',
  'name' => esc_html__('Social Icons', 'pofo-addons'),
  'description' => esc_html__( 'Add an awesome social', 'pofo-addons' ),  
  'base' => 'pofo_social',
  'category' => 'Pofo',
  'content_element' => true,
  'params' => array(
      array(
        'type' => 'dropdown',
        'heading' => esc_html__('Style', 'pofo-addons'),
        'param_name' => 'pofo_social_style',
        'admin_label' => true,
        'value' => array(esc_html__('Select style', 'pofo-addons') => '',
                  esc_html__('Style 1', 'pofo-addons') => 'social-icon-style-1',
                  esc_html__('Style 2', 'pofo-addons') => 'social-icon-style-2',
                  esc_html__('Style 3', 'pofo-addons') => 'social-icon-style-3',
                  esc_html__('Style 4', 'pofo-addons') => 'social-icon-style-4',
                  esc_html__('Style 5', 'pofo-addons') => 'social-icon-style-5',
                  esc_html__('Style 6', 'pofo-addons') => 'social-icon-style-6',
                  esc_html__('Style 7', 'pofo-addons') => 'social-icon-style-7',
                  esc_html__('Style 8', 'pofo-addons') => 'social-icon-style-8',
                  esc_html__('Style 9', 'pofo-addons') => 'social-icon-style-9',
                  esc_html__('Style 10', 'pofo-addons') => 'social-icon-style-10',
                  esc_html__('Style 11', 'pofo-addons') => 'social-icon-style-11',
        ),
      ),  
      array(
        'type' => 'pofo_preview_image',
        'heading' => esc_html__('Select pre-made style', 'pofo-addons'),
        'param_name' => 'pofo_social_preview_image',
        'value' => array(esc_html__('Please select style', 'pofo-addons') => '',
                          esc_html__('Style 1', 'pofo-addons') => 'social-icon-style-1',
                          esc_html__('Style 2', 'pofo-addons') => 'social-icon-style-2',
                          esc_html__('Style 3', 'pofo-addons') => 'social-icon-style-3',
                          esc_html__('Style 4', 'pofo-addons') => 'social-icon-style-4',
                          esc_html__('Style 5', 'pofo-addons') => 'social-icon-style-5',
                          esc_html__('Style 6', 'pofo-addons') => 'social-icon-style-6',
                          esc_html__('Style 7', 'pofo-addons') => 'social-icon-style-7',
                          esc_html__('Style 8', 'pofo-addons') => 'social-icon-style-8',
                          esc_html__('Style 9', 'pofo-addons') => 'social-icon-style-9',
                          esc_html__('Style 10', 'pofo-addons') => 'social-icon-style-10',
                          esc_html__('Style 11', 'pofo-addons') => 'social-icon-style-11',
                        ),
      ),
      array(
        'type'        => 'pofo_custom_social_sorting',
        'heading'     => esc_html__( 'Social sorting', 'pofo-addons'),
        'param_name'  => 'pofo_social_sorting',
        'value'       => array(
                            esc_html__( 'Facebook', 'pofo-addons')      => 'facebook',
                            esc_html__( 'Twitter', 'pofo-addons')       => 'twitter',
                            esc_html__( 'Google+', 'pofo-addons')       => 'gplus',
                            esc_html__( 'Dribbble', 'pofo-addons')      => 'dribbble',
                            esc_html__( 'LinkedIn', 'pofo-addons')      => 'linkedin',
                            esc_html__( 'Instagram', 'pofo-addons')     => 'instagram',
                            esc_html__( 'Tumblr', 'pofo-addons')        => 'tumblr',
                            esc_html__( 'Pinterest', 'pofo-addons')     => 'pinterest',
                            esc_html__( 'Youtube', 'pofo-addons')       => 'youtube',
                            esc_html__( 'Vimeo', 'pofo-addons')         => 'vimeo',
                            esc_html__( 'Soundcloud', 'pofo-addons')    => 'soundcloud',
                            esc_html__( 'Flickr', 'pofo-addons')        => 'flickr',
                            esc_html__( 'RSS', 'pofo-addons')           => 'rss',
                            esc_html__( 'Reddit', 'pofo-addons')        => 'reddit',
                            esc_html__( 'Behance', 'pofo-addons')       => 'behance',
                            esc_html__( 'Vine', 'pofo-addons')          => 'vine',
                            esc_html__( 'GitHub', 'pofo-addons')        => 'github',
                            esc_html__( 'Xing', 'pofo-addons')          => 'xing',
                            esc_html__( 'VK', 'pofo-addons')            => 'vk',
                            esc_html__( 'Yelp', 'pofo-addons')          => 'yelp',
                            esc_html__( 'Discord', 'pofo-addons')       => 'discord',
                            esc_html__( 'Email address', 'pofo-addons') => 'email',
                            esc_html__( 'Skype', 'pofo-addons')         => 'skype',
                        ),
        'std' => '',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Facebook URL', 'pofo-addons'),
        'param_name' => 'pofo_fb_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Twitter URL', 'pofo-addons'),
        'param_name' => 'pofo_tw_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Google+ URL', 'pofo-addons'),
        'param_name' => 'pofo_gp_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Dribbble URL', 'pofo-addons'),
        'param_name' => 'pofo_db_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Linkedin URL', 'pofo-addons'),
        'param_name' => 'pofo_li_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Instagram URL', 'pofo-addons'),
        'param_name' => 'pofo_ig_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Tumblr URL', 'pofo-addons'),
        'param_name' => 'pofo_tb_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Pinterest URL', 'pofo-addons'),
        'param_name' => 'pofo_pi_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('YouTube URL', 'pofo-addons'),
        'param_name' => 'pofo_yt_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Vimeo URL', 'pofo-addons'),
        'param_name' => 'pofo_vm_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Soundcloud URL', 'pofo-addons'),
        'param_name' => 'pofo_sc_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Flickr URL', 'pofo-addons'),
        'param_name' => 'pofo_fk_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('RSS URL', 'pofo-addons'),
        'param_name' => 'pofo_rss_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Reddit URL', 'pofo-addons'),
        'param_name' => 'pofo_rd_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Behance URL', 'pofo-addons'),
        'param_name' => 'pofo_bh_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Vine URL', 'pofo-addons'),
        'param_name' => 'pofo_vine_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('GitHub URL', 'pofo-addons'),
        'param_name' => 'pofo_gh_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Xing URL', 'pofo-addons'),
        'param_name' => 'pofo_xing_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('VK URL', 'pofo-addons'),
        'param_name' => 'pofo_vk_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Yelp URL', 'pofo-addons'),
        'param_name' => 'pofo_yelp_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Discord URL', 'pofo-addons'),
        'param_name' => 'pofo_discord_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Email address', 'pofo-addons'),
        'param_name' => 'pofo_email_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textfield',
        'heading' => esc_html__('Skype', 'pofo-addons'),
        'param_name' => 'pofo_skype_url',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'textarea_raw_html',
        'heading' => esc_html__( 'Custom icons code', 'pofo-addons' ),
        'param_name' => 'pofo_custom_link',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'animation_style',
        'heading' => esc_html__( 'CSS animation', 'pofo-addons' ),
        'param_name' => 'pofo_animation_style',
        'value' => '',
        'settings' => array(
          'type' => array(
            'in',
            'other',
          ),
        ),
        'description' => __( 'Select type of animation for element to be animated when it "enters" the browsers viewport (Note: works only in modern browsers).', 'pofo-addons' ),
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__('Icon size', 'pofo-addons'),
        'param_name' => 'pofo_icon_type',
        'value' => array(esc_html__('Select icon size', 'pofo-addons') => '',
                  esc_html__('Extra large', 'pofo-addons') => 'extra-large-icon',
                  esc_html__('Large', 'pofo-addons') => 'large-icon',
                  esc_html__('Medium', 'pofo-addons') => 'medium-icon',
                  esc_html__('Small', 'pofo-addons') => 'small-icon',
                  esc_html__('Extra small', 'pofo-addons') => 'extra-small-icon',
        ),
        'std' => 'small-icon',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Icon color', 'pofo-addons' ),
        'param_name' => 'pofo_icon_color',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Icon hover color', 'pofo-addons' ),
        'param_name' => 'pofo_icon_hover_color',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Link target', 'pofo-addons'),
        'param_name' => 'pofo_link_target',
        'value' => array(
            esc_html__('New tab / window', 'pofo-addons') => '_blank',
            esc_html__('Self', 'pofo-addons') => '_self', 
        ),
        'group' => esc_html__( 'Style', 'pofo-addons' ),
        'std' => '_blank',
        'dependency'  => array( 'element' => 'pofo_social_style', 'value' => array('social-icon-style-1','social-icon-style-2','social-icon-style-3','social-icon-style-4','social-icon-style-5','social-icon-style-6','social-icon-style-7','social-icon-style-8','social-icon-style-9','social-icon-style-10','social-icon-style-11') ),
      ),
      $pofo_vc_extra_id,
      $pofo_vc_extra_class,
  )
) );