<?php
/**
 * Shortcode Map For Team Member
 *
 * @package Pofo
 */
?>
<?php

/*-----------------------------------------------------------------------------------*/
/* Team Member */
/*-----------------------------------------------------------------------------------*/

  vc_map(
    array(
      'name' => esc_html__( 'Team Member', 'pofo-addons' ),
      'base' => 'pofo_team_member',
      'category' => 'Pofo',
      'icon' => 'fas fa-user pofo-shortcode-icon',
      'description' => esc_html__( 'Create a team block', 'pofo-addons' ),
      'params' => array(
        array(
          'type'        => 'dropdown',
          'heading'     => esc_html__( 'Style', 'pofo-addons'),
          'param_name'  => 'pofo_team_member_style',
          'value' => array( esc_html__( 'Select style', 'pofo-addons') => '',
                            esc_html__( 'Team style 1', 'pofo-addons') => 'team-1',
                            esc_html__( 'Team style 2', 'pofo-addons') => 'team-2',
                          ),
        ),
        array(
          'type'        => 'pofo_preview_image',
          'heading'     => esc_html__( 'Select pre-made style for block', 'pofo-addons'),
          'param_name'  => 'pofo_team_preview_image',
          'admin_label' => true,
          'value' => array( esc_html__( 'Block image', 'pofo-addons') => '',
                            esc_html__( 'Team style 1', 'pofo-addons') => 'team-1',
                            esc_html__( 'Team style 2', 'pofo-addons') => 'team-2',
                          ),
        ),
        array(
          'type'        => 'attach_image',
          'heading'     => esc_html__( 'Image', 'pofo-addons' ),
          'param_name'  => 'pofo_team_member_image',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
        ),
        array(
          'type'        => 'dropdown',
          'heading'     => esc_html__( 'Image thumbnail size', 'pofo-addons' ),
          'param_name'  => 'pofo_image_srcset',
          'value'       => pofo_get_thumbnail_image_sizes(),
          'std' => 'full',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Name', 'pofo-addons' ),
          'param_name'  => 'pofo_member_name',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Designation', 'pofo-addons' ),
          'param_name'  => 'pofo_member_des',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
        ),
        array(
          'type'        => 'pofo_custom_switch_option',
          'heading'     => esc_html__( 'Content', 'pofo-addons'),
          'param_name'  => 'pofo_enable_content',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
        ),
        array(
          'type'        => 'textarea_html',
          'heading'     => esc_html__( 'Content text', 'pofo-addons'),
          'param_name'  => 'content',
          'dependency'  => array( 'element' => 'pofo_enable_content', 'value' => array('1') ),
        ),
        array(
          'type'        => 'pofo_custom_switch_option',
          'heading'     => esc_html__( 'Separator', 'pofo-addons'),
          'param_name'  => 'pofo_enable_separator',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
        ),
        array(
          'type' => 'pofo_custom_switch_option',
          'heading' => esc_html__( 'Link on name', 'pofo-addons'),
          'param_name' => 'pofo_enable_link',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Link target', 'pofo-addons'),
          'param_name' => 'pofo_link_target',
          'value' => array(esc_html__('Self', 'pofo-addons') => '_self', 
                             esc_html__('New tab / window', 'pofo-addons') => '_blank',
                             esc_html__('One page', 'pofo-addons') => 'one_page',
                            ),
          'dependency'  => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
        ),
        array(
          'type' => 'textfield',
          'heading' =>esc_html__( 'Link / URL', 'pofo-addons'),
          'param_name' => 'pofo_link_url',
          'admin_label' => true,
          'dependency'  => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
          'description' => esc_html__( 'Enter full URL with http, like http://www.example.com', 'pofo-addons' ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => esc_html__( 'Link hover color', 'pofo-addons' ),
          'param_name' => 'pofo_link_hover_color',
          'dependency'  => array( 'element' => 'pofo_enable_link', 'value' => '1' ),
        ),
        array(
          'type'        => 'pofo_custom_social_sorting',
          'heading'     => esc_html__( 'Social sorting', 'pofo-addons'),
          'param_name'  => 'pofo_social_sorting',
          'value'       => array(
                              esc_html__( 'Facebook', 'pofo-addons')      => 'facebook',
                              esc_html__( 'Twitter', 'pofo-addons')       => 'twitter',
                              esc_html__( 'Google+', 'pofo-addons')       => 'gplus',
                              esc_html__( 'Dribbble', 'pofo-addons')      => 'dribbble',
                              esc_html__( 'LinkedIn', 'pofo-addons')      => 'linkedin',
                              esc_html__( 'Instagram', 'pofo-addons')     => 'instagram',
                              esc_html__( 'Tumblr', 'pofo-addons')        => 'tumblr',
                              esc_html__( 'Pinterest', 'pofo-addons')     => 'pinterest',
                              esc_html__( 'Youtube', 'pofo-addons')       => 'youtube',
                              esc_html__( 'Vimeo', 'pofo-addons')         => 'vimeo',
                              esc_html__( 'Soundcloud', 'pofo-addons')    => 'soundcloud',
                              esc_html__( 'Flickr', 'pofo-addons')        => 'flickr',
                              esc_html__( 'RSS', 'pofo-addons')           => 'rss',
                              esc_html__( 'Reddit', 'pofo-addons')        => 'reddit',
                              esc_html__( 'Behance', 'pofo-addons')       => 'behance',
                              esc_html__( 'Vine', 'pofo-addons')          => 'vine',
                              esc_html__( 'GitHub', 'pofo-addons')        => 'github',
                              esc_html__( 'Xing', 'pofo-addons')          => 'xing',
                              esc_html__( 'VK', 'pofo-addons')            => 'vk',
                              esc_html__( 'Yelp', 'pofo-addons')          => 'yelp',
                              esc_html__( 'Discord', 'pofo-addons')       => 'discord',
                              esc_html__( 'Email address', 'pofo-addons') => 'email',
                              esc_html__( 'Skype', 'pofo-addons')         => 'skype',
                          ),
          'std' => '',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Facebook URL', 'pofo-addons' ),
          'param_name'  => 'pofo_facebook_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Twitter URL', 'pofo-addons' ),
          'param_name'  => 'pofo_twitter_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Google+ URL', 'pofo-addons' ),
          'param_name'  => 'pofo_gplus_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Dribbble URL', 'pofo-addons' ),
          'param_name'  => 'pofo_db_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'LinkedIn URL', 'pofo-addons' ),
          'param_name'  => 'pofo_linkedin_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Instagram URL', 'pofo-addons' ),
          'param_name'  => 'pofo_instagram_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Tumblr URL', 'pofo-addons' ),
          'param_name'  => 'pofo_tb_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Pinterest URL', 'pofo-addons' ),
          'param_name'  => 'pofo_pinterest_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('Youtube URL', 'pofo-addons'),
          'param_name'  => 'pofo_yt_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('Vimeo URL', 'pofo-addons'),
          'param_name'  => 'pofo_vm_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('Soundcloud URL', 'pofo-addons'),
          'param_name'  => 'pofo_sc_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('Flickr URL', 'pofo-addons'),
          'param_name'  => 'pofo_fk_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('RSS URL', 'pofo-addons'),
          'param_name'  => 'pofo_rss_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('Reddit URL', 'pofo-addons'),
          'param_name'  => 'pofo_rd_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Behance URL', 'pofo-addons' ),
          'param_name'  => 'pofo_behance_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('Vine URL', 'pofo-addons'),
          'param_name'  => 'pofo_vine_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('GitHub URL', 'pofo-addons'),
          'param_name'  => 'pofo_gh_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('Xing URL', 'pofo-addons'),
          'param_name'  => 'pofo_xing_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('VK URL', 'pofo-addons'),
          'param_name'  => 'pofo_vk_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('Yelp URL', 'pofo-addons'),
          'param_name'  => 'pofo_yelp_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('Discord URL', 'pofo-addons'),
          'param_name'  => 'pofo_discord_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('Email address', 'pofo-addons'),
          'param_name'  => 'pofo_email_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__('Skype', 'pofo-addons'),
          'param_name'  => 'pofo_skype_url',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type'        => 'textarea_raw_html',
          'heading'     => esc_html__( 'Custom icons code', 'pofo-addons' ),
          'param_name'  => 'pofo_custom_link',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Social', 'pofo-addons'),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Name text case', 'pofo-addons'),
          'param_name' => 'pofo_title_text_transform',
          'value' => array(  esc_html__('Select', 'pofo-addons') => '', 
                             esc_html__('Lowercase', 'pofo-addons') => 'text-lowercase',
                             esc_html__('Uppercase', 'pofo-addons') => 'text-uppercase',
                             esc_html__('Capitalize', 'pofo-addons') => 'text-capitalize',
                             esc_html__( 'None', 'pofo-addons' ) => 'text-none',
                            ),
          'std' => 'text-uppercase',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => esc_html__( 'Designation text case', 'pofo-addons'),
          'param_name' => 'pofo_des_text_transform',
          'value' => array(  esc_html__('Select', 'pofo-addons') => '', 
                             esc_html__('Lowercase', 'pofo-addons') => 'text-lowercase',
                             esc_html__('Uppercase', 'pofo-addons') => 'text-uppercase',
                             esc_html__('Capitalize', 'pofo-addons') => 'text-capitalize',
                             esc_html__( 'None', 'pofo-addons' ) => 'text-none',
                            ),
          'std' => 'text-uppercase',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group' => esc_html__( 'Style', 'pofo-addons' ),
        ),
        array(
          'type'        => 'colorpicker',
          'class'       => '',
          'heading'     => esc_html__( 'Box hover background color and opacity', 'pofo-addons' ),
          'param_name'  => 'pofo_box_hover_bg_color',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'heading'     => esc_html__( 'Icon size', 'pofo-addons'),
          'param_name'  => 'pofo_icon_size',
          'admin_label' => true,
          'value' => array(esc_html__( 'Default', 'pofo-addons') => '',
                           esc_html__( 'Extra Large', 'pofo-addons') => 'icon-extra-large', 
                           esc_html__( 'Large', 'pofo-addons') => 'icon-large',
                           esc_html__( 'Extra Medium', 'pofo-addons') => 'icon-extra-medium',
                           esc_html__( 'Medium', 'pofo-addons') => 'icon-medium',
                           esc_html__( 'Small', 'pofo-addons') => 'icon-small',
                           esc_html__( 'Extra Small', 'pofo-addons') => 'icon-extra-small',
                          ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'colorpicker',
          'class'       => '',
          'heading'     => esc_html__( 'Icon color', 'pofo-addons' ),
          'param_name'  => 'pofo_icon_color',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'colorpicker',
          'class'       => '',
          'heading'     => esc_html__( 'Icon hover color', 'pofo-addons' ),
          'param_name'  => 'pofo_icon_hover_color',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Separator thickness', 'pofo-addons' ),
          'param_name'  => 'pofo_separator_height',
          'value'       => '2px',
          'description' => esc_html__( 'In pixel like 1px.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_enable_separator', 'value' => array('1') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'colorpicker',
          'class'       => '',
          'heading'     => esc_html__( 'Separator color', 'pofo-addons' ),
          'param_name'  => 'pofo_separator_color',
          'dependency'  => array( 'element' => 'pofo_enable_separator', 'value' => array('1') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'param_name'  => 'desktop_alignment',
          'heading'     => esc_html__( 'Horizontal alignment in desktop', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Left align', 'pofo-addons') => 'text-left',
                           esc_html__( 'Right align', 'pofo-addons') => 'text-right',
                           esc_html__( 'Center align', 'pofo-addons') => 'text-center',
                          ),
          'std' => 'text-center',
          'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'param_name'  => 'desktop_mini_alignment',
          'heading'     => esc_html__( 'Horizontal alignment in mini desktop', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Left align', 'pofo-addons') => 'md-text-left',
                           esc_html__( 'Right align', 'pofo-addons') => 'md-text-right',
                           esc_html__( 'Center align', 'pofo-addons') => 'md-text-center',
                          ),
          'edit_field_class' => 'vc_col-sm-6',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'param_name'  => 'ipad_alignment',
          'heading'     => esc_html__( 'Horizontal alignment in tablet', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Left align', 'pofo-addons') => 'sm-text-left',
                           esc_html__( 'Right align', 'pofo-addons') => 'sm-text-right',
                           esc_html__( 'Center align', 'pofo-addons') => 'sm-text-center',
                          ),
          'edit_field_class' => 'vc_col-sm-6',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'param_name'  => 'mobile_alignment',
          'heading'     => esc_html__( 'Horizontal alignment in mobile', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Left align', 'pofo-addons') => 'xs-text-left',
                           esc_html__( 'Right align', 'pofo-addons') => 'xs-text-right',
                           esc_html__( 'Center align', 'pofo-addons') => 'xs-text-center',
                          ),
          'edit_field_class' => 'vc_col-sm-6',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'param_name'  => 'vertical_desktop_alignment',
          'heading'     => esc_html__( 'Vertical alignment in desktop', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Top align', 'pofo-addons') => 'vertical-align-top',
                           esc_html__( 'Middle align', 'pofo-addons') => 'vertical-align-middle',
                           esc_html__( 'Bottom align', 'pofo-addons') => 'vertical-align-bottom',
                          ),
          'std' => 'vertical-align-middle',
          'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'param_name'  => 'vertical_desktop_mini_alignment',
          'heading'     => esc_html__( 'Vertical alignment in mini desktop', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Top align', 'pofo-addons') => 'md-vertical-align-top',
                           esc_html__( 'Middle align', 'pofo-addons') => 'md-vertical-align-middle',
                           esc_html__( 'Bottom align', 'pofo-addons') => 'md-vertical-align-bottom',
                          ),
          'edit_field_class' => 'vc_col-sm-6',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'param_name'  => 'vertical_ipad_alignment',
          'heading'     => esc_html__( 'Vertical alignment in tablet', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Top align', 'pofo-addons') => 'sm-vertical-align-top',
                           esc_html__( 'Middle align', 'pofo-addons') => 'sm-vertical-align-middle',
                           esc_html__( 'Bottom align', 'pofo-addons') => 'sm-vertical-align-bottom',
                          ),
          'edit_field_class' => 'vc_col-sm-6',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'param_name'  => 'vertical_mobile_alignment',
          'heading'     => esc_html__( 'Vertical alignment in mobile', 'pofo-addons' ),
          'value' => array(esc_html__( 'No align', 'pofo-addons') => '',
                           esc_html__( 'Top align', 'pofo-addons') => 'xs-vertical-align-top',
                           esc_html__( 'Middle align', 'pofo-addons') => 'xs-vertical-align-middle',
                           esc_html__( 'Bottom align', 'pofo-addons') => 'xs-vertical-align-bottom',
                          ),
          'edit_field_class' => 'vc_col-sm-6',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1') ),
          'group'       => esc_html__( 'Style', 'pofo-addons'),
        ),
        array(
          'param_name'  => 'pofo_custom_name_heading', // all params must have a unique name
          'type'        => 'pofo_custom_title', // this param type
          'value'       => esc_html__( 'Name typography', 'pofo-addons' ), // your custom markup
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'responsive_settings' => true,
          'hide_show_element' => 'pofo_member_name_responsive_settings',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Font size', 'pofo-addons' ),
          'param_name'  => 'pofo_member_name_font_size',
          'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_name vc_col-sm-4 vc_column-with-padding',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Line height', 'pofo-addons' ),
          'param_name'  => 'pofo_member_name_line_height',
          'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_name vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Letter spacing', 'pofo-addons' ),
          'param_name'  => 'pofo_member_name_letter_spacing',
          'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_name vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'param_name'  => 'pofo_member_name_font_weight',
          'heading'     => esc_html__( 'Font weight', 'pofo-addons' ),
          'value'       => pofo_font_weight_style(),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_name vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'pofo_custom_switch_option',
          'heading'     => esc_html__( 'Font italic', 'pofo-addons'),
          'param_name'  => 'pofo_member_name_italic',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_name vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'pofo_custom_switch_option',
          'heading'     => esc_html__( 'Font underline', 'pofo-addons'),
          'param_name'  => 'pofo_member_name_underline',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_name vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'heading'     => esc_html__( 'Element tag', 'pofo-addons'),
          'param_name'  => 'pofo_member_name_element_tag',
          'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                           esc_html__( 'h1', 'pofo-addons') => 'h1',
                           esc_html__( 'h2', 'pofo-addons') => 'h2',
                           esc_html__( 'h3', 'pofo-addons') => 'h3',
                           esc_html__( 'h4', 'pofo-addons') => 'h4',
                           esc_html__( 'h5', 'pofo-addons') => 'h5',
                           esc_html__( 'h6', 'pofo-addons') => 'h6',
                          ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_name vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'colorpicker',
          'class'       => '',
          'heading'     => esc_html__( 'Color', 'pofo-addons' ),
          'param_name'  => 'pofo_member_name_color',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_name vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'pofo_custom_switch_option',
          'heading'     => esc_html__( 'Auto responsive font size', 'pofo-addons'),
          'param_name'  => 'pofo_member_name_enable_responsive_font',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_name vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
        'type' => 'responsive_font_settings',
        'param_name' => 'pofo_member_name_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
        'hide_element_keys' => array( 'text-align', 'font-transform', ),
      ),
        array(
          'param_name'  => 'pofo_custom_designation_heading', // all params must have a unique name
          'type'        => 'pofo_custom_title', // this param type
          'value'       => esc_html__( 'Designation Typography', 'pofo-addons' ), // your custom markup
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'responsive_settings' => true,
          'hide_show_element' => 'pofo_member_des_responsive_settings',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Font size', 'pofo-addons' ),
          'param_name'  => 'pofo_member_des_font_size',
          'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_des vc_col-sm-4 vc_column-with-padding',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Line height', 'pofo-addons' ),
          'param_name'  => 'pofo_member_des_line_height',
          'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_des vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Letter spacing', 'pofo-addons' ),
          'param_name'  => 'pofo_member_des_letter_spacing',
          'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_des vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'param_name'  => 'pofo_member_des_font_weight',
          'heading'     => esc_html__( 'Font weight', 'pofo-addons' ),
          'value'       => pofo_font_weight_style(),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_des vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'pofo_custom_switch_option',
          'heading'     => esc_html__( 'Font italic', 'pofo-addons'),
          'param_name'  => 'pofo_member_des_italic',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_des vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'pofo_custom_switch_option',
          'heading'     => esc_html__( 'Font underline', 'pofo-addons'),
          'param_name'  => 'pofo_member_des_underline',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_des vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'dropdown',
          'heading'     => esc_html__( 'Element tag', 'pofo-addons'),
          'param_name'  => 'pofo_member_des_element_tag',
          'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                           esc_html__( 'h1', 'pofo-addons') => 'h1',
                           esc_html__( 'h2', 'pofo-addons') => 'h2',
                           esc_html__( 'h3', 'pofo-addons') => 'h3',
                           esc_html__( 'h4', 'pofo-addons') => 'h4',
                           esc_html__( 'h5', 'pofo-addons') => 'h5',
                           esc_html__( 'h6', 'pofo-addons') => 'h6',
                          ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_des vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'colorpicker',
          'class'       => '',
          'heading'     => esc_html__( 'Color', 'pofo-addons' ),
          'param_name'  => 'pofo_member_des_color',
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_des vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
          'type'        => 'pofo_custom_switch_option',
          'heading'     => esc_html__( 'Auto responsive font size', 'pofo-addons'),
          'param_name'  => 'pofo_member_des_enable_responsive_font',
          'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                           esc_html__( 'On', 'pofo-addons') => '1'
                          ),
          'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
          'dependency'  => array( 'element' => 'pofo_team_member_style', 'value' => array('team-1', 'team-2') ),
          'edit_field_class' => 'pofo_responsive_tab_des vc_col-sm-4',
          'group'       => esc_html__( 'Typography', 'pofo-addons'),
        ),
        array(
        'type' => 'responsive_font_settings',
        'param_name' => 'pofo_member_des_responsive_settings',
        'group' => esc_html__( 'Typography', 'pofo-addons' ),
        'hide_element_keys' => array( 'text-align', 'font-transform', ),
      ),
        $pofo_vc_extra_id,
        $pofo_vc_extra_class,
      )
    )
  );
