<?php
/**
 * Shortcode Map For Testimonial Slider
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Testimonial Slider */
/*-----------------------------------------------------------------------------------*/

  vc_map( 
    array(
        'name' => esc_html__( 'Testimonial Slider' , 'pofo-addons' ), //Name of your shortcode for human reading inside element list
        'base' => 'pofo_testimonial_slider', //Shortcode tag. For [my_shortcode] shortcode base is my_shortcode
        'description' => esc_html__( 'Create a testimonial slider', 'pofo-addons' ), //Short description of your element, it will be visible in 'Add element' window
        'icon' => 'fas fa-quote-left pofo-shortcode-icon', //URL or CSS class with icon image.
        'category' => 'Pofo',
        'params' => array( //List of shortcode attributes. Array which holds your shortcode params, these params will be editable in shortcode settings page
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Style', 'pofo-addons'),
              'param_name' => 'pofo_slider_style',
              'admin_label' => true,
              'value' => array( esc_html__( 'Select style', 'pofo-addons') => '',
                                esc_html__( 'Style 1', 'pofo-addons') => 'style-1',
                                esc_html__( 'Style 2', 'pofo-addons') => 'style-2',
                                esc_html__( 'Style 3', 'pofo-addons') => 'style-3',
                              ),
            ),
            array(
              'type' => 'pofo_preview_image',
              'heading' => esc_html__( 'Select pre-made style for testimonial', 'pofo-addons'),
              'param_name' => 'pofo_testimonial_preview_image',
              'admin_label' => true,
              'value' => array( esc_html__( 'Select style', 'pofo-addons') => '',
                                esc_html__( 'Style 1', 'pofo-addons') => 'style-1',
                                esc_html__( 'Style 2', 'pofo-addons') => 'style-2',
                                esc_html__( 'Style 3', 'pofo-addons') => 'style-3',
                              ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Box background color', 'pofo-addons' ),
              'param_name' => 'pofo_box_bg_color',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-2', 'style-3') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Pagination', 'pofo-addons'),
              'param_name' => 'show_pagination',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'description' => esc_html__( 'Select ON to show pagination in slider', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Pagination style', 'pofo-addons'),
              'param_name' => 'show_pagination_style',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select pagination style', 'pofo-addons') => '',
                             esc_html__( 'Dot style', 'pofo-addons') => '0',
                             esc_html__( 'Line style', 'pofo-addons') => '1',
                            ),
              'dependency' => array( 'element' => 'show_pagination', 'value' => array('1') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Pagination color style', 'pofo-addons'),
              'param_name' => 'show_pagination_color_style',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select pagination color style', 'pofo-addons') => '',
                               esc_html__( 'Dark style', 'pofo-addons') => '0',
                               esc_html__( 'Light style', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'show_pagination', 'value' => array('1') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Navigation', 'pofo-addons'),
              'param_name' => 'show_navigation',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Navigation style', 'pofo-addons'),
              'param_name' => 'show_navigation_style',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select navigation style', 'pofo-addons') => '',
                               esc_html__( 'Next/Prev long arrow', 'pofo-addons') => '0',
                               esc_html__( 'Next/Prev black arrow', 'pofo-addons') => '1',
                               esc_html__( 'Next/Prev white arrow', 'pofo-addons') => '2'
                              ),
              'dependency' => array( 'element' => 'show_navigation', 'value' => array('1') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Cursor color style', 'pofo-addons'),
              'param_name' => 'show_cursor_color_style',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select cursor color style', 'pofo-addons') => '',
                             esc_html__( 'White cursor', 'pofo-addons') => 'white-move',
                             esc_html__( 'Black cursor', 'pofo-addons') => 'black-move',
                             esc_html__( 'Default cursor', 'pofo-addons') => 'no-move',
                            ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Round Image', 'pofo-addons'),
              'param_name' => 'show_round_image',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'std' => '1',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
            ),
            array(
              'param_name' => 'pofo_testimonial_slides', // all params must have a unique name
              'type' => 'param_group', // this param type
              'heading' => esc_html__( 'Slide', 'pofo-addons' ),
              'value' => '',
              'params' => array(
                  array(
                      'type' => 'attach_image',
                      'heading' => esc_html__( 'Image', 'pofo-addons' ),
                      'param_name' => 'pofo_image',
                  ),
                  array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Image thumbnail size', 'pofo-addons' ),
                    'param_name' => 'pofo_image_srcset',
                    'value' => pofo_get_thumbnail_image_sizes(),
                    'std' => 'full',
                    'edit_field_class' => 'vc_col-sm-4',
                  ),
                  array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Title', 'pofo-addons'),
                    'param_name' => 'pofo_title',
                    'admin_label' => true,
                    'description' => esc_html__( 'Use || to break the word in new line.', 'pofo-addons' ),
                    'edit_field_class' => 'vc_col-sm-4',
                  ),
                  array(
                    'type' => 'textfield',
                    'heading' => esc_html__( 'Designation', 'pofo-addons'),
                    'param_name' => 'pofo_designation',
                    'admin_label' => true,
                    'edit_field_class' => 'vc_col-sm-4',
                    'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-2', 'style-3') ),
                  ),
                  array(
                    'type' => 'textarea',
                    'heading' => esc_html__( 'Content', 'pofo-addons'),
                    'param_name' => 'pofo_content',
                  ),
              ),
              'callbacks' => array(
                  'after_add' => 'vcChartParamAfterAddCallback',
              ),
              'group'       => esc_html__( 'Slides', 'pofo-addons'),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Transition style', 'pofo-addons'),
              'param_name' => 'transition_style',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select transition style', 'pofo-addons') => '',
                             esc_html__( 'Slide style', 'pofo-addons') => 'slide',
                             esc_html__( 'Fade style', 'pofo-addons') => 'fade',
                             esc_html__( 'Cube style', 'pofo-addons') => 'cube',
                             esc_html__( 'Coverflow style', 'pofo-addons') => 'coverflow',
                             esc_html__( 'Flip style', 'pofo-addons') => 'flip'
                             
                            ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2') ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Transition speed', 'pofo-addons'),
              'param_name' => 'slidespeed',
              'admin_label' => true,
              'value' => '',
              'description' => esc_html__( 'Enter slide speed time like 500, where 1000 = 1 second', 'pofo-addons'),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Auto play', 'pofo-addons'),
              'param_name' => 'autoplay',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'Select On to autoplay slider', 'pofo-addons' ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Delay time', 'pofo-addons'),
              'param_name' => 'slidedelay',
              'admin_label' => true,
              'value' => '',
              'description' => esc_html__( 'Enter delay time (before switching to other slide) like 500, where 1000 = 1 second', 'pofo-addons'),
              'dependency'  => array( 'element' => 'autoplay', 'value' => array('1') ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'holder' => 'div',
              'class' => '',
              'heading' => esc_html__( 'Loop', 'pofo-addons'),
              'param_name' => 'autoloop',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'Select On to autoloop slider', 'pofo-addons' ),
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in desktop', 'pofo-addons'),
              'param_name' => 'slides_per_view_desktop',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select Slide Per View', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '3',
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-3') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in mini desktop', 'pofo-addons'),
              'param_name' => 'slides_per_view_mini_desktop',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select Slide Per View', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '3',
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-3') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in tablet', 'pofo-addons'),
              'param_name' => 'slides_per_view_tablet',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select Slide Per View', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '2',
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-3') ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Slides per view in mobile', 'pofo-addons'),
              'param_name' => 'slides_per_view_mobile',
              'admin_label' => true,
              'value' => array(esc_html__( 'Select Slide Per View', 'pofo-addons') => '',
                             esc_html__( '1', 'pofo-addons') => '1',
                             esc_html__( '2', 'pofo-addons') => '2',
                             esc_html__( '3', 'pofo-addons') => '3',
                             esc_html__( '4', 'pofo-addons') => '4',
                             esc_html__( '5', 'pofo-addons') => '5',
                             esc_html__( '6', 'pofo-addons') => '6',
                            ),
              'std' => '1',
              'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-3') ),
            ),
            array(
              'param_name' => 'pofo_custom_title_heading', // all params must have a unique name
              'type' => 'pofo_custom_title', // this param type
              'value' => esc_html__( 'Title typography', 'pofo-addons' ), // your custom markup
              'responsive_settings' => true,
              'hide_show_element' => 'pofo_title_responsive_settings',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Font size', 'pofo-addons' ),
              'param_name' => 'pofo_title_font_size',
              'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4 vc_column-with-padding',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Line height', 'pofo-addons' ),
              'param_name' => 'pofo_title_line_height',
              'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
              'param_name' => 'pofo_title_letter_spacing',
              'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'pofo_title_font_weight',
              'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
              'value' => pofo_font_weight_style(),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Font italic', 'pofo-addons'),
              'param_name' => 'pofo_title_italic',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Font underline', 'pofo-addons'),
              'param_name' => 'pofo_title_underline',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Element tag', 'pofo-addons'),
              'param_name' => 'pofo_title_element_tag',
              'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                               esc_html__( 'h1', 'pofo-addons') => 'h1',
                               esc_html__( 'h2', 'pofo-addons') => 'h2',
                               esc_html__( 'h3', 'pofo-addons') => 'h3',
                               esc_html__( 'h4', 'pofo-addons') => 'h4',
                               esc_html__( 'h5', 'pofo-addons') => 'h5',
                               esc_html__( 'h6', 'pofo-addons') => 'h6',
                              ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Color', 'pofo-addons' ),
              'param_name' => 'pofo_title_color',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
              'param_name' => 'pofo_title_enable_responsive_font',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'responsive_font_settings',
              'param_name' => 'pofo_title_responsive_settings',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
              'hide_element_keys' => array( 'text-align', 'font-transform', ),
            ),
            array(
              'param_name' => 'pofo_custom_designation_heading', // all params must have a unique name
              'type' => 'pofo_custom_title', // this param type
              'value' => esc_html__( 'Designation typography', 'pofo-addons' ), // your custom markup
              'responsive_settings' => true,
              'hide_show_element' => 'pofo_designation_responsive_settings',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Font size', 'pofo-addons' ),
              'param_name' => 'pofo_designation_font_size',
              'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_designation vc_col-sm-4 vc_column-with-padding',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Line height', 'pofo-addons' ),
              'param_name' => 'pofo_designation_line_height',
              'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_designation vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
              'param_name' => 'pofo_designation_letter_spacing',
              'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_designation vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'pofo_designation_font_weight',
              'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
              'value' => pofo_font_weight_style(),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_designation vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Font italic', 'pofo-addons'),
              'param_name' => 'pofo_designation_italic',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_designation vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Font underline', 'pofo-addons'),
              'param_name' => 'pofo_designation_underline',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_designation vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'heading' => esc_html__( 'Element tag', 'pofo-addons'),
              'param_name' => 'pofo_designation_element_tag',
              'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                               esc_html__( 'h1', 'pofo-addons') => 'h1',
                               esc_html__( 'h2', 'pofo-addons') => 'h2',
                               esc_html__( 'h3', 'pofo-addons') => 'h3',
                               esc_html__( 'h4', 'pofo-addons') => 'h4',
                               esc_html__( 'h5', 'pofo-addons') => 'h5',
                               esc_html__( 'h6', 'pofo-addons') => 'h6',
                              ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_designation vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Color', 'pofo-addons' ),
              'param_name' => 'pofo_designation_color',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_designation vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
              'param_name' => 'pofo_designation_enable_responsive_font',
              'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                               esc_html__( 'On', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_designation vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'responsive_font_settings',
              'param_name' => 'pofo_designation_responsive_settings',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
              'hide_element_keys' => array( 'text-align', 'font-transform', ),
            ),
            array(
              'param_name' => 'pofo_custom_content_heading', // all params must have a unique name
              'type' => 'pofo_custom_title', // this param type
              'value' => esc_html__( 'Content Typography', 'pofo-addons' ), // your custom markup
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'responsive_settings' => true,
              'hide_show_element' => 'pofo_content_responsive_settings',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Font size', 'pofo-addons' ),
              'param_name' => 'pofo_content_font_size',
              'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4 vc_column-with-padding',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Line height', 'pofo-addons' ),
              'param_name' => 'pofo_content_line_height',
              'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'textfield',
              'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
              'param_name' => 'pofo_content_letter_spacing',
              'description' => esc_html__( 'In pixel like 1px.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'dropdown',
              'param_name' => 'pofo_content_font_weight',
              'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
              'value' => pofo_font_weight_style(),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'colorpicker',
              'class' => '',
              'heading' => esc_html__( 'Color', 'pofo-addons' ),
              'param_name' => 'pofo_content_color',
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'pofo_custom_switch_option',
              'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
              'param_name' => 'pofo_content_enable_responsive_font',
              'value' => array(esc_html__( 'NO', 'pofo-addons') => '0',
                               esc_html__( 'YES', 'pofo-addons') => '1'
                              ),
              'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
              'dependency' => array( 'element' => 'pofo_slider_style', 'value' => array('style-1', 'style-2', 'style-3') ),
              'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
            ),
            array(
              'type' => 'responsive_font_settings',
              'param_name' => 'pofo_content_responsive_settings',
              'group' => esc_html__( 'Typography', 'pofo-addons' ),
              'hide_element_keys' => array( 'text-align', 'font-transform', ),
            ),
            array(
              'type'        => 'textfield',
              'heading'     => esc_html__( 'Element ID', 'pofo-addons' ),
              'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %s).', 'pofo-addons'), '<a target="_blank" href="https://www.w3schools.com/tags/att_global_id.asp">w3c specification</a>'),
              'param_name'  => 'pofo_slider_id',
              'group'       => esc_html__( 'Extras', 'pofo-addons' )
            ),
            array(
              'type'        => 'textfield',
              'heading'     => esc_html__( 'Extra class name', 'pofo-addons' ),
              'description' => esc_html__( 'Add additional CSS class to this element, you can define multiple CSS class with use of space like "Class1 Class2". You can write css code using this class and add it in customizer or your child theme css file.', 'pofo-addons' ),
              'param_name'  => 'pofo_slider_class',
              'group'       => esc_html__( 'Extras', 'pofo-addons' )
            ),
        ),
    )
  );