<?php
/**
 * Shortcode Map For Text Slider
 *
 * @package Pofo
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Text Slider */
/*-----------------------------------------------------------------------------------*/

  $pofo_text_slider_class = 'pofo-text-slider-'.time() .'-2-'.rand( 0, 100 );

  vc_map( 
      array(
      'name' => esc_html__( 'Text Slider' , 'pofo-addons' ), //Name of your shortcode for human reading inside element list
      'base' => 'pofo_text_slider', //Shortcode tag. For [my_shortcode] shortcode base is my_shortcode
      'description' => esc_html__( 'Place a text slider', 'pofo-addons' ), //Short description of your element, it will be visible in 'Add element' window
      'icon' => 'fas fa-sliders-h pofo-shortcode-icon', //URL or CSS class with icon image.
      'category' => 'Pofo',
      'params' => array(
              array(
                  'type' => 'dropdown',
                  'heading' => esc_html__( 'Style', 'pofo-addons'),
                  'param_name' => 'text_slider_style',
                  'admin_label' => true,
                  'value' => array(esc_html__( 'Select style', 'pofo-addons') => '',
                                   esc_html__( 'Slider style 1', 'pofo-addons') => 'pofo-text-slider1',
                                   esc_html__( 'Slider style 2', 'pofo-addons') => 'pofo-text-slider2',
                                  ),
              ),
              array(
                  'type' => 'pofo_preview_image',
                  'heading' => esc_html__( 'Select pre-made style', 'pofo-addons'),
                  'param_name' => 'text_slider_style_preview_image',
                  'admin_label' => true,
                  'value' => array(esc_html__( 'Select slider image', 'pofo-addons') => '',
                                   esc_html__( 'Slider style 1', 'pofo-addons') => 'pofo-text-slider1',
                                   esc_html__( 'Slider style 2', 'pofo-addons') => 'pofo-text-slider2',
                                  ),
              ),
              array(
                  'type' => 'pofo_custom_switch_option',
                  'holder' => 'div',
                  'class' => '',
                  'heading' => esc_html__( 'Pagination', 'pofo-addons' ),
                  'param_name' => 'pofo_show_pagination',
                  'value' => array(
                                  esc_html__( 'Off', 'pofo-addons' ) => '0', 
                                  esc_html__( 'On', 'pofo-addons' ) => '1'
                              ),
                  'std' => '1',
                  'description' => esc_html__( 'Select ON to show pagination in slider', 'pofo-addons' ),
                  'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1') ),
              ),
              array(
                  'type' => 'pofo_custom_switch_option',
                  'holder' => 'div',
                  'class' => '',
                  'heading' => esc_html__( 'Navigation', 'pofo-addons'),
                  'param_name' => 'pofo_show_navigation',
                  'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                                   esc_html__( 'On', 'pofo-addons') => '1'
                                  ),
                  'std' => '1',
                  'description' => esc_html__( 'Select ON to show navigation in slider', 'pofo-addons' ),
                  'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
              ),
              array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Navigation style', 'pofo-addons'),
                'param_name' => 'pofo_show_navigation_style',
                'admin_label' => true,
                'value' => array(esc_html__( 'Select navigation style', 'pofo-addons') => '',
                                 esc_html__( 'Next/Prev black arrow', 'pofo-addons') => '0',
                                 esc_html__( 'Next/Prev white arrow', 'pofo-addons') => '1'
                                ),
                'dependency' => array( 'element' => 'pofo_show_navigation', 'value' => array('1') ),
              ),
              array(
                  'type' => 'dropdown',
                  'heading' => esc_html__( 'Cursor color style', 'pofo-addons' ),
                  'param_name' => 'pofo_show_cursor_color_style',
                  'admin_label' => true,
                  'value' => array(
                          esc_html__( 'Select cursor color style', 'pofo-addons' ) => '',
                                  esc_html__( 'White cursor', 'pofo-addons' ) => 'white-move',
                                  esc_html__( 'Black cursor', 'pofo-addons' ) => 'black-move',
                                  esc_html__( 'Default cursor', 'pofo-addons' ) => 'no-cursor',
                              ),
                  'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
              ),
              array(
                  'type' => 'pofo_custom_switch_option',
                  'holder' => 'div',
                  'class' => '',
                  'heading' => esc_html__( 'Strikethrough', 'pofo-addons'),
                  'param_name' => 'pofo_show_strikethrough',
                  'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                                   esc_html__( 'On', 'pofo-addons') => '1'
                                  ),
                  'std' => '1',
                  'description' => esc_html__( 'Select ON to show strike in title', 'pofo-addons' ),
                  'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1') ),
              ),
              array(
                'param_name' => 'pofo_text_slides', // all params must have a unique name
                'type' => 'param_group', // this param type
                'heading' => esc_html__( 'Slide', 'pofo-addons' ),
                'value' => '',
                'params' => array(
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Title', 'pofo-addons' ),
                        'param_name' => 'pofo_title',
                        'admin_label' => true,
                        'description' => esc_html__( 'Use || to break the word in new line.', 'pofo-addons' ),
                    ),
                    array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Subtitle', 'pofo-addons' ),
                        'param_name' => 'pofo_subtitle',
                        'admin_label' => true,
                    ),
                    array(
                        'type' => 'textarea',
                        'heading' => esc_html__( 'Content', 'pofo-addons' ),
                        'param_name' => 'pofo_content',
                    ),
                    array(
                        'type'        => 'vc_link',
                        'heading'     => esc_html__( 'Button configuration', 'pofo-addons' ),
                        'param_name'  => 'pofo_button_config',
                    ),
                    array(
                        'type' => 'pofo_custom_switch_option',
                        'heading' => esc_html__('Button one page navigation', 'pofo-addons'),
                        'param_name' => 'pofo_button_one_page',
                        'value' => array(esc_html__('Off', 'pofo-addons') => '0',
                                         esc_html__('On', 'pofo-addons') => '1'
                                        ),
                    ),
                ),
                'callbacks' => array(
                    'after_add' => 'vcChartParamAfterAddCallback',
                ),
                'group' => esc_html__( 'Slides', 'pofo-addons'),
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
              ),
              array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Transition speed', 'pofo-addons'),
                'param_name' => 'slidespeed',
                'admin_label' => true,
                'value' => '',
                'description' => esc_html__( 'Enter slide speed time like 500, where 1000 = 1 second', 'pofo-addons'),
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              ),
              array(
                'type' => 'pofo_custom_switch_option',
                'holder' => 'div',
                'class' => '',
                'heading' => esc_html__( 'Auto play', 'pofo-addons'),
                'param_name' => 'autoplay',
                'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                                 esc_html__( 'On', 'pofo-addons') => '1'
                                ),
                'description' => esc_html__( 'Select On to autoplay slider', 'pofo-addons' ),
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              ),
              array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Delay time', 'pofo-addons'),
                'param_name' => 'slidedelay',
                'admin_label' => true,
                'value' => '',
                'std' => '3000',
                'description' => esc_html__( 'Enter delay time (before switching to other slide) like 500, where 1000 = 1 second', 'pofo-addons'),
                'dependency'  => array( 'element' => 'autoplay', 'value' => array('1') ),
                'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              ),
              array(
                'type' => 'pofo_custom_switch_option',
                'holder' => 'div',
                'class' => '',
                'heading' => esc_html__( 'Loop', 'pofo-addons'),
                'param_name' => 'autoloop',
                'value' => array(esc_html__( 'Off', 'pofo-addons') => '0', 
                                 esc_html__( 'On', 'pofo-addons') => '1'
                                ),
                'description' => esc_html__( 'Select TRUE to autoloop slider', 'pofo-addons' ),
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Slider Configuration', 'pofo-addons'),
              ),
              array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__( 'Number color', 'pofo-addons' ),
                'param_name' => 'pofo_number_color',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Style', 'pofo-addons' ),
              ),
              array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__( 'Button background color', 'pofo-addons' ),
                'param_name' => 'pofo_button_color',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Style', 'pofo-addons' ),
              ),
              array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__( 'Button background hover color', 'pofo-addons' ),
                'param_name' => 'pofo_button_hover_color',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Style', 'pofo-addons' ),
              ),
              array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__( 'Button text color', 'pofo-addons' ),
                'param_name' => 'pofo_button_text_color',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Style', 'pofo-addons' ),
              ),
              array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__( 'Button hover text color', 'pofo-addons' ),
                'param_name' => 'pofo_button_hover_text_color',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Style', 'pofo-addons' ),
              ),
              array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__( 'Button border color', 'pofo-addons' ),
                'param_name' => 'pofo_button_border_color',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Style', 'pofo-addons' ),
              ),
              array(
                'param_name' => 'pofo_custom_title_heading', // all params must have a unique name
                'type' => 'pofo_custom_title', // this param type
                'value' => esc_html__( 'Title typography', 'pofo-addons' ), // your custom markup
                'responsive_settings' => true,
                'hide_show_element' => 'pofo_title_responsive_settings',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Font size', 'pofo-addons' ),
                'param_name' => 'pofo_title_font_size',
                'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
                'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4 vc_column-with-padding',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Line height', 'pofo-addons' ),
                'param_name' => 'pofo_title_line_height',
                'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
                'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
                'param_name' => 'pofo_title_letter_spacing',
                'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
                'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'dropdown',
                'param_name' => 'pofo_title_font_weight',
                'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
                'value' => pofo_font_weight_style(),
                'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'pofo_custom_switch_option',
                'heading' => esc_html__( 'Font italic', 'pofo-addons'),
                'param_name' => 'pofo_title_italic',
                'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                                 esc_html__( 'On', 'pofo-addons') => '1'
                                ),
                'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'pofo_custom_switch_option',
                'heading' => esc_html__( 'Font underline', 'pofo-addons'),
                'param_name' => 'pofo_title_underline',
                'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                                 esc_html__( 'On', 'pofo-addons') => '1'
                                ),
                'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Element tag', 'pofo-addons'),
                'param_name' => 'pofo_title_element_tag',
                'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                                 esc_html__( 'h1', 'pofo-addons') => 'h1',
                                 esc_html__( 'h2', 'pofo-addons') => 'h2',
                                 esc_html__( 'h3', 'pofo-addons') => 'h3',
                                 esc_html__( 'h4', 'pofo-addons') => 'h4',
                                 esc_html__( 'h5', 'pofo-addons') => 'h5',
                                 esc_html__( 'h6', 'pofo-addons') => 'h6',
                                ),
                'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__( 'Color', 'pofo-addons' ),
                'param_name' => 'pofo_title_color',
                'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'pofo_custom_switch_option',
                'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
                'param_name' => 'pofo_title_enable_responsive_font',
                'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                                 esc_html__( 'On', 'pofo-addons') => '1'
                                ),
                'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
                'edit_field_class' => 'pofo_responsive_tab_title vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'responsive_font_settings',
                'param_name' => 'pofo_title_responsive_settings',
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
                'hide_element_keys' => array( 'text-align', 'font-transform', ),
              ),
              array(
                'param_name' => 'pofo_custom_subtitle_heading', // all params must have a unique name
                'type' => 'pofo_custom_title', // this param type
                'value' => esc_html__( 'Subtitle Typography', 'pofo-addons' ), // your custom markup
                'responsive_settings' => true,
                'hide_show_element' => 'pofo_subtitle_responsive_settings',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Font size', 'pofo-addons' ),
                'param_name' => 'pofo_subtitle_font_size',
                'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
                'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4 vc_column-with-padding',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Line height', 'pofo-addons' ),
                'param_name' => 'pofo_subtitle_line_height',
                'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
                'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
                'param_name' => 'pofo_subtitle_letter_spacing',
                'description' => esc_html__( 'Define letter spacing like 12px', 'pofo-addons' ),
                'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'dropdown',
                'param_name' => 'pofo_subtitle_font_weight',
                'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
                'value' => pofo_font_weight_style(),
                'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'pofo_custom_switch_option',
                'heading' => esc_html__( 'Font italic', 'pofo-addons'),
                'param_name' => 'pofo_subtitle_italic',
                'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                                 esc_html__( 'On', 'pofo-addons') => '1'
                                ),
                'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'pofo_custom_switch_option',
                'heading' => esc_html__( 'Font underline', 'pofo-addons'),
                'param_name' => 'pofo_subtitle_underline',
                'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                                 esc_html__( 'On', 'pofo-addons') => '1'
                                ),
                'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Element tag', 'pofo-addons'),
                'param_name' => 'pofo_subtitle_element_tag',
                'value' => array(esc_html__( 'Element tag', 'pofo-addons') => '',
                                 esc_html__( 'h1', 'pofo-addons') => 'h1',
                                 esc_html__( 'h2', 'pofo-addons') => 'h2',
                                 esc_html__( 'h3', 'pofo-addons') => 'h3',
                                 esc_html__( 'h4', 'pofo-addons') => 'h4',
                                 esc_html__( 'h5', 'pofo-addons') => 'h5',
                                 esc_html__( 'h6', 'pofo-addons') => 'h6',
                                ),
                'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__( 'Color', 'pofo-addons' ),
                'param_name' => 'pofo_subtitle_color',
                'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'pofo_custom_switch_option',
                'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
                'param_name' => 'pofo_subtitle_enable_responsive_font',
                'value' => array(esc_html__( 'Off', 'pofo-addons') => '0',
                                 esc_html__( 'On', 'pofo-addons') => '1'
                                ),
                'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
                'edit_field_class' => 'pofo_responsive_tab_subtitle vc_col-sm-4',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'responsive_font_settings',
                'param_name' => 'pofo_subtitle_responsive_settings',
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
                'hide_element_keys' => array( 'text-align', 'font-transform', ),
              ),
              array(
                'param_name' => 'pofo_custom_content_heading', // all params must have a unique name
                'type' => 'pofo_custom_title', // this param type
                'value' => esc_html__( 'Content Typography', 'pofo-addons' ), // your custom markup
                'responsive_settings' => true,
                'hide_show_element' => 'pofo_conent_responsive_settings',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Font size', 'pofo-addons' ),
                'param_name' => 'pofo_content_font_size',
                'description' => esc_html__( 'In pixel like 12px.', 'pofo-addons' ),
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4 vc_column-with-padding',
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Line height', 'pofo-addons' ),
                'param_name' => 'pofo_content_line_height',
                'description' => esc_html__( 'In pixel like 20px.', 'pofo-addons' ),
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Letter spacing', 'pofo-addons' ),
                'param_name' => 'pofo_content_letter_spacing',
                'description' => esc_html__( 'In pixel like 1px.', 'pofo-addons' ),
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'dropdown',
                'param_name' => 'pofo_content_font_weight',
                'heading' => esc_html__( 'Font weight', 'pofo-addons' ),
                'value' => pofo_font_weight_style(),
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__( 'Color', 'pofo-addons' ),
                'param_name' => 'pofo_content_color',
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'pofo_custom_switch_option',
                'heading' => esc_html__( 'Auto responsive font size', 'pofo-addons'),
                'param_name' => 'pofo_content_enable_responsive_font',
                'value' => array(esc_html__( 'NO', 'pofo-addons') => '0',
                                 esc_html__( 'YES', 'pofo-addons') => '1'
                                ),
                'description' => esc_html__( 'If ON then it will display font size automatically as per device size instead of above mentioned fixed font size in all devices.', 'pofo-addons' ),
                'dependency' => array( 'element' => 'text_slider_style', 'value' => array('pofo-text-slider1', 'pofo-text-slider2') ),
                'edit_field_class' => 'pofo_responsive_tab_content vc_col-sm-4',
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
              ),
              array(
                'type' => 'responsive_font_settings',
                'param_name' => 'pofo_conent_responsive_settings',
                'group' => esc_html__( 'Typography', 'pofo-addons' ),
                'hide_element_keys' => array( 'text-align', 'font-transform', ),
              ),
              array(
                 'type'        => 'textfield',
                 'heading'     => esc_html__( 'Element ID', 'pofo-addons' ),
                 'description' => sprintf( esc_html__( 'Enter element ID (Note: make sure it is unique and valid according to %s).', 'pofo-addons'), '<a target="_blank" href="https://www.w3schools.com/tags/att_global_id.asp">w3c specification</a>'),
                 'param_name'  => 'pofo_slider_id',
                 'group'       => esc_html__( 'Extras', 'pofo-addons' ),
              ),
              array(
                 'type'        => 'textfield',
                 'heading'     => esc_html__( 'Extra class name', 'pofo-addons' ),
                 'description' => esc_html__( 'Add additional CSS class to this element, you can define multiple CSS class with use of space like "Class1 Class2". You can write css code using this class and add it in customizer or your child theme css file.', 'pofo-addons' ),
                 'param_name'  => 'pofo_slider_class',
                 'group'       => esc_html__( 'Extras', 'pofo-addons' ),
              ),
          ),
      )
  );